/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Team;
import com.dmgame.particle.AnimatedParticle;
import com.dmgame.particle.GravityParticleLogic;
import com.dmgame.particle.ParticleLogic;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class ThrowBox
extends EditableEntity
implements Holdable {
    private static final long serialVersionUID = -3018551080995481942L;
    private transient Animation sprite;
    public transient boolean canDestruct = false;
    public transient boolean canMove = false;

    public ThrowBox(float entityX, float entityY, boolean editorMode) {
        super("throwbox", entityX, entityY, editorMode);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/Default/mapobjects/" + spriteFilename + ".png"));
            BufferedImage[] sprites = new BufferedImage[]{spritesheet.getSubimage(0, 0, 32, 32), spritesheet.getSubimage(32, 0, 32, 32), spritesheet.getSubimage(64, 0, 32, 32), spritesheet.getSubimage(96, 0, 32, 32)};
            this.sprite = new Animation(190L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTeamColor(Team teamColor) {
        this.teamColor = teamColor;
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (this.canDestruct && i instanceof Entity && this.teamColor != ((Entity)i).teamColor) {
            GameLogic.gamemode.reportKill(this, (Entity)i);
            ((Entity)i).die();
        }
    }

    @Override
    public void die() {
        this.createParticles();
        super.die();
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        if (this.onGround) {
            if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
                this.hspeed = this.onSlippery ? (this.hspeed -= 0.05f) : (this.hspeed -= 0.2f);
                if (this.hspeed < 0.0f) {
                    this.hspeed = 0.0f;
                }
            } else if (this.hspeed != 0.0f && this.canMoveLeft) {
                this.hspeed = this.onSlippery ? (this.hspeed += 0.05f) : (this.hspeed += 0.2f);
                if (this.hspeed > 0.0f) {
                    this.hspeed = 0.0f;
                }
            }
        } else if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
            this.hspeed -= 0.05f;
            if (this.hspeed < 0.0f) {
                this.hspeed = 0.0f;
            }
        } else if (this.hspeed != 0.0f && this.canMoveLeft) {
            this.hspeed += 0.05f;
            if (this.hspeed > 0.0f) {
                this.hspeed = 0.0f;
            }
        }
        if (this.canMove) {
            this.entityX += this.hspeed;
        }
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.sprite.update(timePassed);
        this.currentImage = this.sprite.getImage();
    }

    private void createParticles() {
        try {
            SoundPlayer.playSound(Sound.BREAK);
            BufferedImage brokeBlock = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/particles/brokenbrickblock.png"));
            int width = brokeBlock.getWidth() / 4;
            int height = brokeBlock.getHeight();
            Animation ani = new Animation(90L, brokeBlock.getSubimage(0, 0, width, height), brokeBlock.getSubimage(width * 1, 0, width, height), brokeBlock.getSubimage(width * 2, 0, width, height), brokeBlock.getSubimage(width * 3, 0, width, height));
            AnimatedParticle p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, -8.0f), (float)((int)this.entityX), (float)((int)this.entityY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, -8.0f), (float)((int)this.entityX + this.getImage().getWidth() - width), (float)((int)this.entityY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, 0.0f), (float)((int)this.entityX + this.getImage().getWidth() - width), (float)((int)this.entityY + this.getImage().getHeight() - height));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, 0.0f), (float)((int)this.entityX), (float)((int)this.entityY + this.getImage().getHeight() - height));
            p.addToMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public BufferedImage getHeldImage() {
        return this.currentImage;
    }

    @Override
    public void release(Entity thrower) {
        this.facingRight = thrower.facingRight;
        this.entityX = thrower.facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY;
        this.hspeed = thrower.facingRight ? 3.0f : -3.0f;
        this.vspeed = -3.0f;
        this.ctypes.add(Entity.CollisionType.CONTACT_DIE);
        this.canDestruct = true;
        this.canMove = true;
        this.spawn();
    }

    @Override
    protected JComponent[] setupComponents() {
        return null;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        return null;
    }

    @Override
    protected LayoutManager getLayout() {
        return null;
    }

    @Override
    public Object clone() {
        ThrowBox t = new ThrowBox(this.entityX, this.entityY, this.editorMode);
        t.x = Math.round(this.entityX);
        t.y = Math.round(this.entityY);
        return t;
    }

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowBox other = (ThrowBox)obj;
        if (this.canDestruct != other.canDestruct) {
            return false;
        }
        if (this.canMove != other.canMove) {
            return false;
        }
        if (Float.floatToIntBits(this.entityX) != Float.floatToIntBits(other.entityX)) {
            return false;
        }
        return Float.floatToIntBits(this.entityY) == Float.floatToIntBits(other.entityY);
    }
}

