/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.logic;

import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.entity.AI;
import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.DroppedBomb;
import com.dmgame.entity.Entity;
import com.dmgame.entity.ExplosionEntity;
import com.dmgame.entity.Flamethrower;
import com.dmgame.entity.PiranhaPlant;
import com.dmgame.entity.Player;
import com.dmgame.entity.RedThrowBlockEntity;
import com.dmgame.entity.Rotodisc;
import com.dmgame.entity.Shell;
import com.dmgame.entity.Spike;
import com.dmgame.entity.SpikeShell;
import com.dmgame.entity.ThrowBlockEntity;
import com.dmgame.entity.logic.Logic;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.Projectile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.interactivetiles.BlueThrowBlock;
import com.dmgame.map.interactivetiles.ClearItemBlock;
import com.dmgame.map.interactivetiles.GrayThrowBlock;
import com.dmgame.map.interactivetiles.QuestionBlock;
import com.dmgame.map.interactivetiles.RedThrowBlock;
import java.awt.geom.Point2D;

public class BasicLogic
extends Logic {
    public BasicLogic(AI user) {
        super(user);
    }

    @Override
    public void assess() {
        this.mapObjects.clear();
        for (Entity e : GameLogic.entities.values()) {
            if (e == null) continue;
            this.assessHelper(e);
        }
        for (Entity e : GameLogic.mapEntities) {
            if (e == null) continue;
            this.assessHelper(e);
        }
        InteractiveTile[][] arr$ = GameLogic.currentMap.iTiles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            InteractiveTile[] array;
            for (InteractiveTile iTile : array = arr$[i$]) {
                if (iTile == null) continue;
                this.assessHelper(iTile);
            }
        }
        this.findFirstPriority();
    }

    private void assessHelper(Interactive focus) {
        int priorityLevel;
        block46: {
            Point2D.Float two;
            Point2D.Float one;
            block45: {
                block44: {
                    priorityLevel = 0;
                    if (focus == null || focus.equals(this.user)) {
                        return;
                    }
                    if (!(focus instanceof Entity)) break block44;
                    one = new Point2D.Float(this.user.entityX, this.user.entityY);
                    two = new Point2D.Float(((Entity)focus).entityX, ((Entity)focus).entityY);
                    break block45;
                }
                if (!(focus instanceof InteractiveTile)) break block46;
                one = new Point2D.Float(this.user.entityX, this.user.entityY);
                two = new Point2D.Float(((InteractiveTile)focus).mapX, ((InteractiveTile)focus).mapY);
            }
            double add = Math.ceil(1.0 / Math.log(one.distance(two)) * 17.0) - 1.0;
            priorityLevel = (byte)((double)priorityLevel + add);
        }
        if (focus instanceof Player) {
            Player p = (Player)focus;
            if (p.teamColor != this.user.teamColor && p.isAlive()) {
                priorityLevel = p.isInWarp() ? 1 : (p.isInvincible() || p.isAttackingCape() || p.isAttackingLeaf() || p.hasAttackItem() || p.isHoldingItem() ? 6 : 5);
            }
        } else if (focus instanceof Shell) {
            priorityLevel = ((Shell)focus).isInMotion() ? (focus instanceof SpikeShell ? 4 : 3) : 1;
        } else if (focus instanceof ThrowBlockEntity) {
            priorityLevel = focus instanceof RedThrowBlockEntity ? 4 : 3;
        } else if (focus instanceof BulletBillEntity) {
            if (((BulletBillEntity)focus).teamColor != this.user.teamColor) {
                priorityLevel = 4;
            }
        } else if (focus instanceof DroppedBomb) {
            if (((DroppedBomb)focus).teamColor != this.user.teamColor) {
                priorityLevel = 6;
            }
        } else if (focus instanceof ExplosionEntity) {
            if (((ExplosionEntity)focus).teamColor != this.user.teamColor) {
                priorityLevel = 6;
            }
        } else if (focus instanceof Flamethrower) {
            priorityLevel = 2;
        } else if (focus instanceof PiranhaPlant) {
            switch (((PiranhaPlant)focus).getType()) {
                case RED: 
                case GREEN: {
                    priorityLevel = 3;
                    break;
                }
                case SHORT: 
                case TALL: {
                    priorityLevel = 2;
                    break;
                }
                default: {
                    priorityLevel = 3;
                    break;
                }
            }
        } else if (focus instanceof PowerUp) {
            priorityLevel = focus instanceof PoisonMushroom ? 5 : 1;
        } else if (focus instanceof Projectile) {
            if (((Projectile)focus).teamColor != this.user.teamColor) {
                priorityLevel = 6;
            }
        } else if (focus instanceof Rotodisc.Disc) {
            priorityLevel = 4;
        } else if (focus instanceof Spike) {
            priorityLevel = 2;
        } else if (focus instanceof InteractiveTile) {
            if (focus instanceof QuestionBlock) {
                priorityLevel = ((QuestionBlock)focus).disabled ? 1 : 4;
            } else if (focus instanceof ClearItemBlock) {
                priorityLevel = ((ClearItemBlock)focus).disabled ? 1 : 4;
            } else if (focus instanceof BlueThrowBlock || focus instanceof RedThrowBlock || focus instanceof GrayThrowBlock) {
                priorityLevel = 3;
            }
        }
        this.mapObjects.offer(new Logic.AlertObject(this, focus, (byte)priorityLevel));
    }

    @Override
    protected void findFirstPriority() {
        this.currentFocus = (Logic.AlertObject)this.mapObjects.peek();
    }
}

