/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.logic;

import com.dmgame.Interactive;
import com.dmgame.entity.AI;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.map.InteractiveTile;
import java.util.concurrent.PriorityBlockingQueue;

public abstract class Logic {
    public static final byte PRIORITY_LEVEL_VERY_LOW = 0;
    public static final byte PRIORITY_LEVEL_LOW = 1;
    public static final byte PRIORITY_LEVEL_LOW_MEDIUM = 2;
    public static final byte PRIORITY_LEVEL_MEDIUM = 3;
    public static final byte PRIORITY_LEVEL_MEDIUM_HIGH = 4;
    public static final byte PRIORITY_LEVEL_HIGH = 5;
    public static final byte PRIORITY_LEVEL_VERY_HIGH = 6;
    protected PriorityBlockingQueue<AlertObject> mapObjects;
    protected AlertObject currentFocus;
    protected AI user;

    public Logic(AI user) {
        this.user = user;
        this.mapObjects = new PriorityBlockingQueue();
    }

    public abstract void assess();

    protected abstract void findFirstPriority();

    public final AlertObject getCurrentFocus() {
        return this.currentFocus;
    }

    public final PriorityBlockingQueue<AlertObject> getPriorities() {
        return this.mapObjects;
    }

    public class AlertObject
    implements Comparable<AlertObject> {
        private float targetX;
        private float targetY;
        private Interactive target;
        private byte priorityLevel;
        private Team teamColor;

        public AlertObject(Interactive target, byte priorityLevel) {
            this.target = target;
            this.priorityLevel = priorityLevel;
            if (target instanceof Entity) {
                this.targetX = ((Entity)target).entityX;
                this.targetY = ((Entity)target).entityY;
                this.teamColor = ((Entity)target).teamColor;
            } else if (target instanceof InteractiveTile) {
                this.targetX = ((InteractiveTile)target).mapX;
                this.targetY = ((InteractiveTile)target).mapY;
                this.teamColor = Team.UNALLIED;
            }
        }

        public float getTargetX() {
            if (this.target instanceof Entity) {
                this.targetX = ((Entity)this.target).entityX;
            } else if (this.target instanceof InteractiveTile) {
                this.targetX = ((InteractiveTile)this.target).mapX;
            }
            return this.targetX;
        }

        public float getTargetY() {
            if (this.target instanceof Entity) {
                this.targetY = ((Entity)this.target).entityY;
            } else if (this.target instanceof InteractiveTile) {
                this.targetY = ((InteractiveTile)this.target).mapY;
            }
            return this.targetY;
        }

        public Interactive getTarget() {
            return this.target;
        }

        public byte getPriorityLevel() {
            return this.priorityLevel;
        }

        public Team getTeamColor() {
            return this.teamColor;
        }

        @Override
        public int compareTo(AlertObject other) {
            if (this.priorityLevel < other.getPriorityLevel()) {
                return 1;
            }
            if (this.priorityLevel > other.getPriorityLevel()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.target.getClass().getSimpleName() + ", Priority: " + this.priorityLevel + ", " + "X: " + this.targetX + ", Y: " + this.targetY + "]";
        }
    }
}

