/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;

public abstract class AbstractLifeMushroom
extends PowerUp {
    private static final long serialVersionUID = -3266785243539985973L;
    public int lifeValue;

    public AbstractLifeMushroom(String spriteFilename, float x, float y, int lifeValue) {
        super(spriteFilename, x, y, Sound.LIFE);
        this.lifeValue = lifeValue;
        this.ctypes.add(Entity.CollisionType.HORIZ_BOUNCE);
    }

    @Override
    protected synchronized void updateMovement(long timePassed) {
        if (!this.canReact) {
            super.updateMovement(timePassed);
            return;
        }
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        if (this.ridingPlatform != null) {
            this.entityX = (float)((double)this.entityX + this.ridingPlatform.hspeed);
            this.entityY = (float)((double)this.entityY + this.ridingPlatform.vspeed);
        }
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }
}

