/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.SMWException;
import com.dmgame.SpriteColorModel;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.ExplosionEntity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class BobOmb
extends PowerUp {
    private static final long serialVersionUID = -4733866775765887373L;
    public transient BufferedImage[] sprites;
    public transient Animation walkingRight;
    public transient Animation walkingLeft;

    public BobOmb(float x, float y, Team teamColor) {
        super("bobomb", x, y, Sound.COLLECT);
        this.getSprites();
        this.teamColor = teamColor;
        this.setTeamColor(teamColor);
    }

    @Override
    public String getScriptCreateStatement() {
        String tc = null;
        if (this.teamColor != null) {
            tc = "Team." + this.teamColor.name();
        }
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", tc, ")");
    }

    @Override
    protected void setTeamColor(Team teamColor) {
        try {
            float colorShift = 0.0f;
            switch (teamColor) {
                case GREEN: {
                    colorShift = 0.3f;
                    break;
                }
                case YELLOW: {
                    colorShift = 0.15f;
                    break;
                }
                case BLUE: {
                    colorShift = -0.3f;
                    break;
                }
                default: {
                    return;
                }
            }
            if (colorShift != 0.0f) {
                this.teamColors.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
            }
        }
        catch (SMWException ex) {
            ex.printStackTrace();
        }
    }

    private void getSprites() {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/Default/modeskins/bobomb.png"));
            this.sprites = new BufferedImage[10];
            this.sprites[0] = spritesheet.getSubimage(0, 0, 32, 32);
            this.sprites[1] = spritesheet.getSubimage(32, 0, 32, 32);
            this.sprites[2] = spritesheet.getSubimage(64, 0, 32, 32);
            this.sprites[3] = spritesheet.getSubimage(96, 0, 32, 32);
            this.sprites[4] = spritesheet.getSubimage(128, 0, 32, 32);
            this.sprites[5] = spritesheet.getSubimage(160, 0, 32, 32);
            this.sprites[6] = Utility.getHorizontalFlippedCopy(this.sprites[0]);
            this.sprites[7] = Utility.getHorizontalFlippedCopy(this.sprites[1]);
            this.sprites[8] = Utility.getHorizontalFlippedCopy(this.sprites[2]);
            this.sprites[9] = Utility.getHorizontalFlippedCopy(this.sprites[3]);
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, this.sprites);
            this.walkingRight = new Animation(80L, this.sprites[0], this.sprites[1]);
            this.walkingLeft = new Animation(80L, this.sprites[6], this.sprites[7]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void explode(Entity spawner) {
        ExplosionEntity e = new ExplosionEntity(32, 32, spawner);
        GameLogic.addEntity(e);
        e.startTimer();
        ((Player)spawner).setCurrentItem(null);
    }

    @Override
    public String toString() {
        return "Bob-Omb";
    }

    @Override
    public Object clone() {
        return new BobOmb(this.x, this.y, this.teamColor);
    }
}

