/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.GameLogic;
import com.dmgame.PathFollower;
import com.dmgame.entity.Entity;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.BoomerangProjectile;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.geom.Ellipse2D;

public class Boomerang
extends PowerUp {
    private static final long serialVersionUID = 2869284554568565297L;

    public Boomerang(float x, float y) {
        super("boomerang", x, y, Sound.COLLECT);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    public void throwProjectile(Entity thrower) {
        SoundPlayer.playSound(Sound.BOOMERANG);
        BoomerangProjectile toThrow = new BoomerangProjectile(thrower.entityX, thrower.entityY, thrower);
        float f = toThrow.hspeed = thrower.facingRight ? 4.0f : -4.0f;
        if (BoomerangProjectile.motion == BoomerangProjectile.BoomerangMotion.SMB3) {
            if (thrower.facingRight) {
                toThrow.pathSMB3 = new Ellipse2D.Float(thrower.entityX, thrower.entityY, 256.0f, 64.0f);
                toThrow.helper = new PathFollower(toThrow.pathSMB3, true, toThrow.hspeed, 0.5, 1);
            } else {
                toThrow.pathSMB3 = new Ellipse2D.Float(thrower.entityX - 256.0f, thrower.entityY, 256.0f, 64.0f);
                toThrow.helper = new PathFollower(toThrow.pathSMB3, false, (double)Math.abs(toThrow.hspeed) * 0.01, 0.0, 1);
            }
        } else if (BoomerangProjectile.motion == BoomerangProjectile.BoomerangMotion.ZELDA) {
            GameLogic.startDelayedAction(1000L, toThrow.zelda);
        }
        ++thrower.ownedProjectiles;
        toThrow.spawn();
    }

    @Override
    public String toString() {
        return "Boomerang";
    }

    @Override
    public Object clone() {
        return new Boomerang((float)this.x, (float)this.y);
    }
}

