/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.GameLogic;
import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.DirectUsable;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;

public class BulletBill
extends PowerUp
implements DirectUsable {
    private static final long serialVersionUID = -3023793950398765937L;
    public static final int SPAWN_AMOUNT = 16;

    public BulletBill(float x, float y, Team teamColor) {
        super("bulletbill", x, y, Sound.COLLECT);
        this.teamColor = teamColor;
    }

    @Override
    public String getScriptCreateStatement() {
        String tc = null;
        if (this.teamColor != null) {
            tc = "Team." + this.teamColor.name();
        }
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", tc, ")");
    }

    @Override
    public String toString() {
        return "Bullet Bill";
    }

    @Override
    public Object clone() {
        return new BulletBill(this.entityX, this.entityY, this.teamColor);
    }

    @Override
    public void use() {
        for (int i = 1; i <= 16; ++i) {
            GameLogic.startDelayedAction(250 * i, new Runnable(){

                @Override
                public void run() {
                    GameLogic.addEntity(new BulletBillEntity(BulletBill.this.teamColor, GameLogic.random.nextDouble() > 0.5));
                    SoundPlayer.playSound(Sound.CANNON);
                }
            });
        }
    }
}

