/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public strictfp class Feather
extends PowerUp {
    private static final long serialVersionUID = 6684797723986027412L;
    private final long HSPEED_TIME = 1000L;
    private long timeSinceFlip;
    private boolean firstTime;
    private transient BufferedImage frameOne;
    private transient BufferedImage frameTwo;
    public static final int HSPEED_NOT_ZERO = 0;
    public static final int VSPEED_LESS_EQUAL_ZERO = 1;
    public static final int VSPEED_GREATER_ZERO = 2;
    public static final int SPIN_ATTACK = 3;
    public transient Animation[] animations;
    public transient Animation[] animationsLeft;
    private transient BufferedImage hspeedZero;
    private transient BufferedImage hspeedZeroLeft;
    public volatile boolean spinAttacking;
    private boolean inStorage;
    public int numJumps;

    public Feather(float x, float y) {
        super("feather", x, y, Sound.FEATHERGET);
        this.hspeed = 2.25f;
        this.vspeed = 1.0f;
        this.timeSinceFlip = 0L;
        this.firstTime = true;
        this.facingRight = true;
        this.spinAttacking = false;
        this.inStorage = false;
        this.numJumps = 0;
        this.getOverlayGraphics();
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    @Override
    protected void createSprites(String spriteFileName) {
        try {
            this.frameOne = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/powerups/" + spriteFileName + ".png"));
            this.frameTwo = Utility.getHorizontalFlippedCopy(this.frameOne);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void spinAttackingMovementPolicy(Entity user) {
        user.hspeed = user.hspeed - (user.isOnSlipperyTile() ? 0.05f : 0.2f);
        if (user.hspeed < 0.0f) {
            user.hspeed = 0.0f;
        }
        user.vspeed += 0.4f;
        if (user.vspeed > 18.0f) {
            user.vspeed = 18.0f;
        }
        user.entityX += user.hspeed;
        user.entityY += user.vspeed;
        user.x = Math.round(user.entityX);
        user.y = Math.round(user.entityY);
        if (user.entityX < 0.0f) {
            user.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (user.entityX >= (float)GameLogic.currentMap.MAP_WIDTH) {
            user.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
    }

    private void getOverlayGraphics() {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/cape.png"));
            BufferedImage[] normal = new BufferedImage[12];
            BufferedImage[] flipped = new BufferedImage[12];
            normal[0] = spritesheet.getSubimage(0, 0, 32, 32);
            normal[1] = spritesheet.getSubimage(32, 0, 32, 32);
            normal[2] = spritesheet.getSubimage(64, 0, 32, 32);
            normal[3] = spritesheet.getSubimage(96, 0, 32, 32);
            normal[4] = spritesheet.getSubimage(0, 32, 32, 32);
            normal[5] = spritesheet.getSubimage(32, 32, 32, 32);
            normal[6] = spritesheet.getSubimage(0, 64, 32, 32);
            normal[7] = spritesheet.getSubimage(32, 64, 32, 32);
            normal[8] = spritesheet.getSubimage(64, 64, 32, 32);
            normal[9] = spritesheet.getSubimage(0, 96, 32, 32);
            normal[10] = spritesheet.getSubimage(32, 96, 32, 32);
            normal[11] = spritesheet.getSubimage(64, 96, 32, 32);
            for (int i = 0; i < 12; ++i) {
                flipped[i] = Utility.getHorizontalFlippedCopy(normal[i]);
            }
            this.hspeedZero = normal[10];
            this.hspeedZeroLeft = flipped[10];
            this.animations = new Animation[4];
            this.animationsLeft = new Animation[4];
            this.animations[0] = new Animation(80L, normal[0], normal[1], normal[2], normal[3]);
            this.animationsLeft[0] = new Animation(80L, flipped[0], flipped[1], flipped[2], flipped[3]);
            this.animations[1] = new Animation(80L, normal[0], normal[1], normal[2], normal[3]);
            this.animationsLeft[1] = new Animation(80L, flipped[0], flipped[1], flipped[2], flipped[3]);
            this.animations[2] = new Animation(80L, normal[6], normal[7], normal[8]);
            this.animationsLeft[2] = new Animation(80L, flipped[6], flipped[7], flipped[8]);
            this.animations[3] = new Animation(80L, normal[5], flipped[5], flipped[4], flipped[5], normal[5]);
            this.animationsLeft[3] = new Animation(80L, flipped[5], normal[5], normal[4], normal[5], flipped[5]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.spinAttacking) {
            this.animations[3].update(timePassed);
            this.animationsLeft[3].update(timePassed);
        } else {
            this.animations[3].reset();
            this.animationsLeft[3].reset();
        }
        if (!this.inStorage) {
            super.update(timePassed);
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.currentImage = this.facingRight ? this.frameOne : this.frameTwo;
    }

    @Override
    protected synchronized void updateMovement(long timePassed) {
        if (!this.canReact) {
            super.updateMovement(timePassed);
            return;
        }
        this.timeSinceFlip += timePassed;
        if (this.firstTime) {
            if (this.timeSinceFlip > 500L) {
                this.firstTime = false;
                this.hspeed = -this.hspeed;
                this.facingRight = !this.facingRight;
                this.timeSinceFlip = 0L;
            }
        } else if (this.timeSinceFlip > 1000L) {
            this.firstTime = false;
            this.hspeed = -this.hspeed;
            this.facingRight = !this.facingRight;
            this.timeSinceFlip = 0L;
        }
        this.vspeed = (1250L - this.timeSinceFlip) / 600L;
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.die();
        }
    }

    public void drawOverlayToScreen(Graphics2D g2D, float xPos, float yPos, Entity wearer) {
        if (this.spinAttacking) {
            g2D.drawImage((Image)(this.facingRight ? this.animations[3].getImage() : this.animationsLeft[3].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.vspeed < 0.0f || wearer.vspeed == 0.0f && !wearer.onGround) {
            g2D.drawImage((Image)(wearer.facingRight ? this.animations[1].getImage() : this.animationsLeft[1].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.vspeed > 0.0f) {
            g2D.drawImage((Image)(wearer.facingRight ? this.animations[2].getImage() : this.animationsLeft[2].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.hspeed == 0.0f) {
            g2D.drawImage((Image)(wearer.facingRight ? this.hspeedZero : this.hspeedZeroLeft), Math.round(xPos - (float)(wearer.facingRight ? 10 : 0)), Math.round(yPos + 2.0f), null);
        } else if (wearer.hspeed != 0.0f) {
            g2D.drawImage((Image)(wearer.facingRight ? this.animations[0].getImage() : this.animationsLeft[0].getImage()), Math.round(xPos), Math.round(yPos), null);
        }
    }

    @Override
    public synchronized void collisionLogic() {
    }

    public void movementPolicy(Player p) {
        ++this.numJumps;
        p.vspeed = -4.0f;
        p.airTime = 192;
        p.canJump = false;
        p.alreadyJumped = true;
        SoundPlayer.playSound(Sound.CAPEJUMP);
    }

    @Override
    public String toString() {
        return "Cape Feather";
    }

    @Override
    public Object clone() {
        Feather f = new Feather((float)this.x, (float)this.y);
        f.inStorage = this.inStorage;
        f.facingRight = this.facingRight;
        return f;
    }

    public boolean getInStorage() {
        return this.inStorage;
    }

    public void setInStorage(boolean inStorage) {
        this.inStorage = inStorage;
    }
}

