/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.FireballProjectile;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;

public class FireFlower
extends PowerUp {
    private static final long serialVersionUID = -2446146560255868614L;

    public FireFlower(float x, float y, Team teamColor) {
        super("fireflower", x, y, Sound.COLLECT);
    }

    @Override
    public String getScriptCreateStatement() {
        String tc = null;
        if (this.teamColor != null) {
            tc = "Team." + this.teamColor.name();
        }
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", tc, ")");
    }

    public void throwProjectile(Entity thrower) {
        SoundPlayer.playSound(Sound.FIREBALL);
        FireballProjectile toThrow = new FireballProjectile(thrower.entityX, thrower.entityY, thrower.teamColor, thrower, true);
        toThrow.hspeed = thrower.facingRight ? 5.0f : -5.0f;
        toThrow.spawn();
        ++thrower.ownedProjectiles;
    }

    @Override
    public String toString() {
        return "Fire Flower";
    }

    @Override
    public Object clone() {
        return new FireFlower(this.x, this.y, this.teamColor);
    }
}

