/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.entity.Entity;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.HammerProjectile;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;

public class Hammer
extends PowerUp {
    private static final long serialVersionUID = 7291775703144370309L;

    public Hammer(float x, float y) {
        super("hammer", x, y, Sound.COLLECT);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    public void throwProjectile(Entity thrower) {
        SoundPlayer.playSound(Sound.FIREBALL);
        ++thrower.ownedProjectiles;
        HammerProjectile toThrow = new HammerProjectile(thrower.entityX, thrower.entityY, thrower.teamColor, thrower);
        toThrow.hspeed = thrower.hspeed == 0.0f ? (thrower.facingRight ? 4.0f : -4.0f) : (this.facingRight ? thrower.hspeed / 2.0f : -(thrower.hspeed / 2.0f)) * 4.0f;
        toThrow.vspeed = this.vspeed <= 0.0f ? -7.0f : thrower.vspeed * 2.0f * 7.0f;
        toThrow.spawn();
    }

    @Override
    public String toString() {
        return "Hammer";
    }

    @Override
    public Object clone() {
        return new Hammer((float)this.x, (float)this.y);
    }
}

