/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.entity.Entity;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.IceWandBlast;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;

public class IceWand
extends PowerUp {
    private static final long serialVersionUID = -6852506713624645221L;

    public IceWand(float x, float y) {
        super("icewand", x, y, Sound.COLLECT);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    public void throwProjectile(Entity thrower) {
        SoundPlayer.playSound(Sound.WAND);
        ++thrower.ownedProjectiles;
        IceWandBlast toThrow = new IceWandBlast(thrower.entityX, thrower.entityY, thrower.teamColor, thrower);
        toThrow.hspeed = thrower.facingRight ? 4.0f : -4.0f;
        toThrow.spawn();
    }

    @Override
    public String toString() {
        return "Ice Wand";
    }

    @Override
    public Object clone() {
        return new IceWand((float)this.x, (float)this.y);
    }
}

