/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public strictfp class Leaf
extends PowerUp {
    private static final long serialVersionUID = 8703639568321791622L;
    private final long HSPEED_TIME = 1000L;
    private long timeSinceFlip;
    private boolean firstTime;
    private transient BufferedImage frameOne;
    private transient BufferedImage frameTwo;
    public static final int HSPEED_NOT_ZERO = 0;
    public static final int FLOATING = 1;
    public static final int SPIN_ATTACK = 2;
    public static final int HSPEED_ZERO = 0;
    public static final int VSPEED_LESS_ZERO = 1;
    public static final int VSPEED_GREATER_ZERO = 2;
    public transient Animation[] animations;
    public transient Animation[] animationsLeft;
    private transient BufferedImage[] sprites;
    private transient BufferedImage[] spritesLeft;
    public volatile boolean spinAttacking;
    public volatile boolean floating;
    private boolean inStorage;

    public Leaf(float x, float y) {
        super("leaf", x, y, Sound.COLLECT);
        this.hspeed = 2.25f;
        this.vspeed = 1.0f;
        this.timeSinceFlip = 0L;
        this.firstTime = true;
        this.facingRight = true;
        this.floating = false;
        this.spinAttacking = false;
        this.inStorage = false;
        this.getOverlayGraphics();
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    @Override
    protected void createSprites(String spriteFileName) {
        try {
            this.frameOne = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/powerups/" + spriteFileName + ".png"));
            this.frameTwo = Utility.getHorizontalFlippedCopy(this.frameOne);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void spinAttackingMovementPolicy(Entity user) {
        user.hspeed = user.hspeed - (user.isOnSlipperyTile() ? 0.05f : 0.2f);
        if (user.hspeed < 0.0f) {
            user.hspeed = 0.0f;
        }
        user.vspeed += 0.4f;
        if (user.vspeed > 18.0f) {
            user.vspeed = 18.0f;
        }
        user.entityX += user.hspeed;
        user.entityY += user.vspeed;
        user.x = Math.round(user.entityX);
        user.y = Math.round(user.entityY);
        if (user.entityX < 0.0f) {
            user.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (user.entityX >= (float)GameLogic.currentMap.MAP_WIDTH) {
            user.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
    }

    private void getOverlayGraphics() {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/tail.png"));
            BufferedImage[] normal = new BufferedImage[8];
            BufferedImage[] flipped = new BufferedImage[8];
            normal[0] = spritesheet.getSubimage(0, 0, 22, 26);
            normal[1] = spritesheet.getSubimage(22, 0, 22, 26);
            normal[2] = spritesheet.getSubimage(44, 0, 22, 26);
            normal[3] = spritesheet.getSubimage(66, 0, 22, 26);
            normal[4] = spritesheet.getSubimage(88, 0, 22, 26);
            normal[5] = spritesheet.getSubimage(110, 0, 22, 26);
            normal[6] = spritesheet.getSubimage(0, 26, 22, 26);
            normal[7] = spritesheet.getSubimage(22, 26, 22, 26);
            for (int i = 0; i < 8; ++i) {
                flipped[i] = Utility.getHorizontalFlippedCopy(normal[i]);
            }
            this.sprites = new BufferedImage[3];
            this.spritesLeft = new BufferedImage[3];
            this.animations = new Animation[3];
            this.animationsLeft = new Animation[3];
            this.sprites[0] = normal[1];
            this.spritesLeft[0] = flipped[1];
            this.sprites[1] = normal[3];
            this.spritesLeft[1] = flipped[3];
            this.sprites[2] = normal[5];
            this.spritesLeft[2] = flipped[5];
            this.animations[0] = new Animation(80L, normal[1], normal[2], normal[3]);
            this.animationsLeft[0] = new Animation(80L, flipped[1], flipped[2], flipped[3]);
            this.animations[1] = new Animation(120L, normal[4], normal[3], normal[2]);
            this.animationsLeft[1] = new Animation(120L, flipped[4], flipped[3], flipped[2]);
            this.animations[2] = new Animation(80L, normal[7], flipped[7], flipped[6], flipped[7], normal[7], normal[6]);
            this.animationsLeft[2] = new Animation(80L, flipped[7], normal[7], normal[6], normal[7], flipped[7], flipped[6]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.spinAttacking) {
            this.animations[2].update(timePassed);
            this.animationsLeft[2].update(timePassed);
        } else {
            this.animations[2].reset();
            this.animationsLeft[2].reset();
        }
        if (this.floating) {
            this.animations[1].update(timePassed);
            this.animationsLeft[1].update(timePassed);
            if (this.animations[1].firstCycleCompleted() || this.animationsLeft[1].firstCycleCompleted()) {
                this.floating = false;
            }
        } else {
            this.animations[1].reset();
            this.animationsLeft[1].reset();
        }
        if (!this.inStorage) {
            super.update(timePassed);
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.currentImage = this.facingRight ? this.frameOne : this.frameTwo;
    }

    @Override
    protected synchronized void updateMovement(long timePassed) {
        if (!this.canReact) {
            super.updateMovement(timePassed);
            return;
        }
        this.timeSinceFlip += timePassed;
        if (this.firstTime) {
            if (this.timeSinceFlip > 500L) {
                this.firstTime = false;
                this.hspeed = -this.hspeed;
                this.facingRight = !this.facingRight;
                this.timeSinceFlip = 0L;
            }
        } else if (this.timeSinceFlip > 1000L) {
            this.firstTime = false;
            this.hspeed = -this.hspeed;
            this.facingRight = !this.facingRight;
            this.timeSinceFlip = 0L;
        }
        this.vspeed = (1250L - this.timeSinceFlip) / 600L;
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.die();
        }
    }

    public synchronized void drawOverlayToScreen(Graphics2D g2D, float xPos, float yPos, Entity wearer) {
        BufferedImage[] images;
        BufferedImage[] bufferedImageArray = images = wearer.facingRight ? this.sprites : this.spritesLeft;
        if (this.spinAttacking) {
            g2D.drawImage((Image)(this.facingRight ? this.animations[2].getImage() : this.animationsLeft[2].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else if (this.floating) {
            g2D.drawImage((Image)(wearer.facingRight ? this.animations[1].getImage() : this.animationsLeft[1].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.vspeed < 0.0f || wearer.vspeed == 0.0f && !wearer.onGround) {
            g2D.drawImage((Image)images[1], Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.vspeed > 0.0f) {
            g2D.drawImage((Image)images[2], Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.hspeed == 0.0f) {
            g2D.drawImage((Image)images[0], Math.round(xPos), Math.round(yPos), null);
        } else if (wearer.hspeed != 0.0f) {
            g2D.drawImage((Image)(wearer.facingRight ? this.animations[0].getImage() : this.animationsLeft[0].getImage()), Math.round(xPos), Math.round(yPos), null);
        }
    }

    @Override
    public synchronized void collisionLogic() {
    }

    @Override
    public String toString() {
        return "Raccoon Leaf";
    }

    @Override
    public Object clone() {
        Leaf l = new Leaf((float)this.x, (float)this.y);
        l.inStorage = this.inStorage;
        l.facingRight = this.facingRight;
        return l;
    }

    public boolean getInStorage() {
        return this.inStorage;
    }

    public void setInStorage(boolean inStorage) {
        this.inStorage = inStorage;
    }
}

