/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.DirectUsable;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ModBlock
extends PowerUp
implements DirectUsable {
    private static final long serialVersionUID = 6044708972475897837L;
    private transient Animation spriteAnim;

    public ModBlock(float x, float y, Team teamColor) {
        super("mod", x, y, Sound.COLLECT);
        this.teamColor = teamColor;
    }

    @Override
    public String getScriptCreateStatement() {
        String tc = null;
        if (this.teamColor != null) {
            tc = "Team." + this.teamColor.name();
        }
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", tc, ")");
    }

    @Override
    protected void createSprites(String spriteFileName) {
        File spriteFile = new File("res/gfx/packs/Default/powerups/" + spriteFileName + ".png");
        try {
            BufferedImage allFrames = ImageIO.read(spriteFile);
            BufferedImage[] frames = new BufferedImage[]{allFrames.getSubimage(0, 0, 32, 32), allFrames.getSubimage(32, 0, 32, 32), allFrames.getSubimage(64, 0, 32, 32), allFrames.getSubimage(96, 0, 32, 32), allFrames.getSubimage(128, 0, 32, 32), allFrames.getSubimage(160, 0, 32, 32), allFrames.getSubimage(192, 0, 32, 32), allFrames.getSubimage(224, 0, 32, 32)};
            this.spriteAnim = new Animation(80L, frames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected synchronized void updateImage(long timePassed) {
        this.spriteAnim.update(timePassed);
        this.currentImage = this.spriteAnim.getImage();
    }

    @Override
    public void use() {
        SoundPlayer.playSound(Sound.THUNDER);
        for (Entity e : GameLogic.entities.values()) {
            if (e.teamColor == this.teamColor || e.isOnGround()) continue;
            e.die();
        }
    }

    @Override
    public String toString() {
        return "MOd Block";
    }

    @Override
    public Object clone() {
        return new ModBlock(this.x, this.y, this.teamColor);
    }
}

