/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.MapScene;
import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class PWing
extends PowerUp
implements Updatable {
    private static final long serialVersionUID = 1092951632506309613L;
    public static final int MAX_NUM_JUMPS = 2;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public transient BufferedImage[] overlay;
    public transient Animation[] overlayAnim;
    public int numJumps;
    public boolean flying;

    public PWing(float x, float y) {
        super("pwing", x, y, Sound.COLLECT);
        this.getOverlayGraphics();
        this.numJumps = 0;
        this.flying = false;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    private void getOverlayGraphics() {
        try {
            BufferedImage wings = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/wings.png"));
            BufferedImage[] sprites = new BufferedImage[]{wings.getSubimage(0, 0, 32, 32), wings.getSubimage(32, 0, 32, 32)};
            BufferedImage[] spritesReversed = new BufferedImage[]{Utility.getHorizontalFlippedCopy(sprites[0]), Utility.getHorizontalFlippedCopy(sprites[1])};
            this.overlay = new BufferedImage[2];
            this.overlayAnim = new Animation[2];
            this.overlay[0] = sprites[1];
            this.overlay[1] = spritesReversed[1];
            this.overlayAnim[0] = new Animation(150L, sprites);
            this.overlayAnim[1] = new Animation(150L, spritesReversed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.numJumps > 1 || this.flying) {
            this.overlayAnim[0].update(timePassed);
            this.overlayAnim[1].update(timePassed);
        } else {
            this.overlayAnim[0].reset();
            this.overlayAnim[1].reset();
        }
    }

    public void drawOverlayToScreen(Graphics2D g2D, float xPos, float yPos, Entity wearer) {
        if (this.numJumps < 3 && this.numJumps > 0) {
            g2D.drawImage((Image)(wearer.facingRight ? this.overlayAnim[0].getImage() : this.overlayAnim[1].getImage()), Math.round(xPos), Math.round(yPos), null);
        } else {
            g2D.drawImage((Image)(wearer.facingRight ? this.overlay[0] : this.overlay[1]), Math.round(xPos), Math.round(yPos), null);
        }
    }

    @Override
    public String toString() {
        return "P-Wing";
    }

    @Override
    public Object clone() {
        return new PWing((float)this.x, (float)this.y);
    }

    public void movementPolicy(Player p) {
        ++this.numJumps;
        p.canJump = false;
        p.alreadyJumped = true;
        SoundPlayer.playSound(Sound.SLOWDOWN);
    }
}

