/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Direction;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.BobOmb;
import com.dmgame.entity.powerups.Bomb;
import com.dmgame.entity.powerups.Boomerang;
import com.dmgame.entity.powerups.BulletBill;
import com.dmgame.entity.powerups.Feather;
import com.dmgame.entity.powerups.FireFlower;
import com.dmgame.entity.powerups.Hammer;
import com.dmgame.entity.powerups.IceWand;
import com.dmgame.entity.powerups.Leaf;
import com.dmgame.entity.powerups.ModBlock;
import com.dmgame.entity.powerups.MysteryMushroom;
import com.dmgame.entity.powerups.OneUp;
import com.dmgame.entity.powerups.PWing;
import com.dmgame.entity.powerups.Podobo;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowBlock;
import com.dmgame.entity.powerups.SlowdownClock;
import com.dmgame.entity.powerups.SpeedupClock;
import com.dmgame.entity.powerups.Starman;
import com.dmgame.entity.powerups.TanookiSuit;
import com.dmgame.entity.powerups.ThreeUp;
import com.dmgame.entity.powerups.TwoUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public strictfp abstract class PowerUp
extends Entity
implements Interactive,
Cloneable {
    private static final long serialVersionUID = 9081646549759397113L;
    public static final byte BOBOMB = 0;
    public static final byte BOMB = 1;
    public static final byte BOOMERANG = 2;
    public static final byte BULLET_BILL = 3;
    public static final byte FEATHER = 4;
    public static final byte FIRE_FLOWER = 5;
    public static final byte HAMMER = 6;
    public static final byte ICE_WAND = 7;
    public static final byte LEAF = 8;
    public static final byte MOD_BLOCK = 9;
    public static final byte MYSTERY_MUSHROOM = 10;
    public static final byte ONE_UP = 11;
    public static final byte PODOBO = 12;
    public static final byte POISON_MUSHROOM = 13;
    public static final byte POW_BLOCK = 14;
    public static final byte P_WING = 15;
    public static final byte SLOWDOWN_CLOCK = 16;
    public static final byte SPEEDUP_CLOCK = 17;
    public static final byte STARMAN = 18;
    public static final byte TANOOKI_SUIT = 19;
    public static final byte THREE_UP = 20;
    public static final byte TWO_UP = 21;
    protected final int NETWORK_BYTES;
    protected Sound itemSound;
    protected transient int counter;

    public PowerUp(String spriteFilename, float x, float y, Sound itemSound) {
        super(spriteFilename, x, y, Team.UNALLIED);
        this.getClass();
        this.NETWORK_BYTES = 23 + 1;
        this.itemSound = null;
        this.hspeed = 2.0f;
        this.vspeed = 0.0f;
        this.itemSound = itemSound;
    }

    @Override
    protected void setTeamColor(Team teamColor) {
    }

    public void setTeam(Team teamColor) {
        this.teamColor = teamColor;
    }

    public static PowerUp getById(byte id, Team teamColor) {
        PowerUp selected;
        switch (id) {
            case 0: {
                selected = new BobOmb(0.0f, 0.0f, teamColor);
                break;
            }
            case 1: {
                selected = new Bomb(0.0f, 0.0f);
                break;
            }
            case 2: {
                selected = new Boomerang(0.0f, 0.0f);
                break;
            }
            case 3: {
                selected = new BulletBill(0.0f, 0.0f, teamColor);
                break;
            }
            case 4: {
                selected = new Feather(0.0f, 0.0f);
                break;
            }
            case 5: {
                selected = new FireFlower(0.0f, 0.0f, teamColor);
                break;
            }
            case 6: {
                selected = new Hammer(0.0f, 0.0f);
                break;
            }
            case 7: {
                selected = new IceWand(0.0f, 0.0f);
                break;
            }
            case 8: {
                selected = new Leaf(0.0f, 0.0f);
                break;
            }
            case 9: {
                selected = new ModBlock(0.0f, 0.0f, teamColor);
                break;
            }
            case 10: {
                selected = new MysteryMushroom(0.0f, 0.0f);
                break;
            }
            case 11: {
                selected = new OneUp(0.0f, 0.0f);
                break;
            }
            case 12: {
                selected = new Podobo(0.0f, 0.0f, teamColor);
                break;
            }
            case 13: {
                selected = new PoisonMushroom(0.0f, 0.0f);
                break;
            }
            case 14: {
                selected = new PowBlock(0.0f, 0.0f, teamColor);
                break;
            }
            case 15: {
                selected = new PWing(0.0f, 0.0f);
                break;
            }
            case 16: {
                selected = new SlowdownClock(0.0f, 0.0f);
                break;
            }
            case 17: {
                selected = new SpeedupClock(0.0f, 0.0f);
                break;
            }
            case 18: {
                selected = new Starman(0.0f, 0.0f);
                break;
            }
            case 19: {
                selected = new TanookiSuit(0.0f, 0.0f);
                break;
            }
            case 20: {
                selected = new ThreeUp(0.0f, 0.0f);
                break;
            }
            case 21: {
                selected = new TwoUp(0.0f, 0.0f);
                break;
            }
            default: {
                selected = null;
            }
        }
        return selected;
    }

    public static byte getIdByType(PowerUp powerUp) {
        if (powerUp instanceof BobOmb) {
            return 0;
        }
        if (powerUp instanceof Bomb) {
            return 1;
        }
        if (powerUp instanceof Boomerang) {
            return 2;
        }
        if (powerUp instanceof BulletBill) {
            return 3;
        }
        if (powerUp instanceof Feather) {
            return 4;
        }
        if (powerUp instanceof FireFlower) {
            return 5;
        }
        if (powerUp instanceof Hammer) {
            return 6;
        }
        if (powerUp instanceof IceWand) {
            return 7;
        }
        if (powerUp instanceof Leaf) {
            return 8;
        }
        if (powerUp instanceof ModBlock) {
            return 9;
        }
        if (powerUp instanceof MysteryMushroom) {
            return 10;
        }
        if (powerUp instanceof OneUp) {
            return 11;
        }
        if (powerUp instanceof Podobo) {
            return 12;
        }
        if (powerUp instanceof PoisonMushroom) {
            return 13;
        }
        if (powerUp instanceof PowBlock) {
            return 14;
        }
        if (powerUp instanceof PWing) {
            return 15;
        }
        if (powerUp instanceof SlowdownClock) {
            return 16;
        }
        if (powerUp instanceof SpeedupClock) {
            return 17;
        }
        if (powerUp instanceof Starman) {
            return 18;
        }
        if (powerUp instanceof TanookiSuit) {
            return 19;
        }
        if (powerUp instanceof ThreeUp) {
            return 20;
        }
        if (powerUp instanceof TwoUp) {
            return 21;
        }
        return -1;
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            this.currentImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/powerups/" + spriteFilename + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (this.ridingPlatform != null) {
            this.entityX = (float)((double)this.entityX + this.ridingPlatform.hspeed);
            this.entityY = (float)((double)this.entityY + this.ridingPlatform.vspeed);
            this.x = (int)this.entityX;
            this.y = (int)this.entityY;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
    }

    @Override
    public void spawn() {
        super.spawn();
        this.canReact = false;
        this.spawning = 0;
    }

    public boolean canBeUsed() {
        return this.canReact;
    }

    @Override
    public byte[] prepareNetworkUpdate() {
        byte[] baseData = super.prepareNetworkUpdate();
        byte[] updateData = new byte[23];
        System.arraycopy(baseData, 0, updateData, 0, baseData.length);
        updateData[22] = (byte)(this.canReact ? 0 : 255);
        return updateData;
    }

    @Override
    public void getNetworkUpdate(float x, float y, float h, float v, byte[] extra) {
        super.getNetworkUpdate(x, y, h, v, extra);
        this.canReact = extra[22] == 0;
    }

    @Override
    public abstract String toString();

    @Override
    public abstract Object clone();

    public void playItemGetSound() {
        if (this.itemSound != null) {
            SoundPlayer.playSound(this.itemSound);
        }
    }

    @Override
    public void iTileBumpTop() {
        if (this.canReact) {
            this.vspeed = -3.0f;
        }
    }

    public boolean canReact() {
        return this.canReact;
    }
}

