/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public strictfp class Starman
extends PowerUp {
    private static final long serialVersionUID = 325577101454647077L;
    private transient Animation spriteAnim;

    public Starman(float x, float y) {
        super("starman", x, y, Sound.COLLECT);
        this.vspeed = -2.0f;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    @Override
    protected void createSprites(String spriteFileName) {
        File spriteFile = new File("res/gfx/packs/Default/powerups/" + spriteFileName + ".png");
        try {
            BufferedImage allFrames = ImageIO.read(spriteFile);
            BufferedImage frameOne = allFrames.getSubimage(0, 0, 32, 32);
            BufferedImage frameTwo = allFrames.getSubimage(32, 0, 32, 32);
            BufferedImage frameThree = allFrames.getSubimage(64, 0, 32, 32);
            BufferedImage frameFour = allFrames.getSubimage(96, 0, 32, 32);
            this.spriteAnim = new Animation(100L, frameOne, frameTwo, frameThree, frameFour);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void updateMovement(long timePassed) {
        if (!this.canReact) {
            super.updateMovement(timePassed);
            return;
        }
        this.vspeed = !this.onGround ? (this.vspeed += 0.4f) : -10.0f;
        if (this.vspeed > 9.0f) {
            this.vspeed = 9.0f;
        } else if (this.vspeed < -9.0f) {
            this.vspeed = -9.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    public synchronized void updateImage(long timePassed) {
        this.spriteAnim.update(timePassed);
        this.currentImage = this.spriteAnim.getImage();
    }

    @Override
    public void playItemGetSound() {
    }

    @Override
    public String toString() {
        return "Starman";
    }

    @Override
    public Object clone() {
        return new Starman((float)this.x, (float)this.y);
    }
}

