/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.powerups;

import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.SpriteColorModel;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class TanookiSuit
extends PowerUp {
    private static final long serialVersionUID = -2645819549500093983L;
    private BufferedImage stoneSprite;
    public static final long MAX_STONE_TIME = 5000L;
    public boolean combo = false;
    private final Runnable STONE_TIMER;

    public TanookiSuit(float x, float y) {
        super("tanookisuit", x, y, Sound.COLLECT);
        this.setStoneGraphic();
        this.STONE_TIMER = new Runnable(){

            @Override
            public void run() {
                TanookiSuit.this.combo = false;
            }
        };
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    public void comboMovementRule(Entity user) {
        if (user.onGround) {
            return;
        }
        if (user.vspeed < 3.0f) {
            user.vspeed = 3.0f;
        }
        user.vspeed += 0.6f;
        if (user.vspeed > 18.0f) {
            user.vspeed = 18.0f;
        }
        user.entityY += user.vspeed;
        user.x = Math.round(user.entityX);
        user.y = Math.round(user.entityY);
        if (user.entityX < 0.0f) {
            user.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (user.entityX >= (float)GameLogic.currentMap.MAP_WIDTH) {
            user.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            user.entityY = -32.0f;
            if (user instanceof Player) {
                ((Player)user).fallTiles[0] = null;
                ((Player)user).fallTiles[1] = null;
            }
        }
        user.height = 58;
        user.width = 32;
    }

    private void setStoneGraphic() {
        try {
            this.stoneSprite = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/statue.png"));
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, this.stoneSprite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getStoneGraphic() {
        return this.stoneSprite;
    }

    public void startTimer() {
        GameLogic.startDelayedAction(5000L, this.STONE_TIMER);
    }

    public void forceStopTimer() {
        GameLogic.removeDelayedAction(this.STONE_TIMER);
    }

    @Override
    public String toString() {
        return "Tanooki Suit";
    }

    @Override
    public Object clone() {
        return new TanookiSuit((float)this.x, (float)this.y);
    }
}

