/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.projectiles;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.PathFollower;
import com.dmgame.SpriteColorModel;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.projectiles.Projectile;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class BoomerangProjectile
extends Projectile {
    private static final long serialVersionUID = 2971519486776848305L;
    public static final long LIFE_TIME = 5000L;
    public Runnable zelda;
    public Runnable life;
    public static BoomerangMotion motion = BoomerangMotion.ZELDA;
    private transient Animation leftAnim;
    private transient Animation rightAnim;
    private boolean returningToPlayer;
    public Ellipse2D.Float pathSMB3;
    public PathFollower helper;
    public static final long ZELDA_TIME = 1000L;

    public BoomerangProjectile(float x, float y, Entity owner) {
        super("boomerang", x, y, owner);
        this.vspeed = 0.0f;
        this.returningToPlayer = false;
        if (motion == BoomerangMotion.ZELDA) {
            this.zelda = new Runnable(){

                @Override
                public void run() {
                    BoomerangProjectile.this.vspeed = BoomerangProjectile.this.hspeed = Math.abs(BoomerangProjectile.this.hspeed);
                    BoomerangProjectile.this.returningToPlayer = true;
                }
            };
        }
        this.life = new Runnable(){

            @Override
            public void run() {
                BoomerangProjectile.this.die();
            }
        };
        GameLogic.startDelayedAction(5000L, this.life);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", "entities.get(", this.owner.entityID, "))");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/projectiles/" + spriteFilename + ".png"));
            BufferedImage[] sprites = new BufferedImage[]{spritesheet.getSubimage(0, 0, 32, 32), spritesheet.getSubimage(32, 0, 32, 32), spritesheet.getSubimage(64, 0, 32, 32), spritesheet.getSubimage(96, 0, 32, 32)};
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, sprites);
            this.rightAnim = new Animation(80L, sprites);
            BufferedImage[] spritesRev = new BufferedImage[4];
            for (int i = 0; i < spritesRev.length; ++i) {
                spritesRev[i] = Utility.getHorizontalFlippedCopy(sprites[i]);
            }
            this.teamColors.addSprites(spritesRev);
            this.leftAnim = new Animation(80L, spritesRev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity) {
            if (((Entity)i).teamColor != this.teamColor) {
                ((Entity)i).die();
            } else {
                if ((Entity)i != this.owner) {
                    return;
                }
                if (this.returningToPlayer) {
                    GameLogic.removeDelayedAction(this.life);
                    this.die();
                }
            }
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (motion == BoomerangMotion.SMB3) {
            this.helper.update(timePassed);
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        switch (motion) {
            case FLAT: {
                this.entityX += this.hspeed;
                this.x = (int)this.entityX;
                this.y = (int)this.entityY;
                if (this.entityX < 0.0f || this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
                    if (!this.returningToPlayer) {
                        this.hspeed = -this.hspeed;
                        this.returningToPlayer = true;
                    } else {
                        GameLogic.removeDelayedAction(this.life);
                        this.die();
                    }
                }
                if (!(this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT)) break;
                this.entityY = -32.0f;
                break;
            }
            case SMB3: {
                if (!this.returningToPlayer) {
                    if (this.helper.isDone()) {
                        this.returningToPlayer = true;
                        this.hspeed = -this.hspeed;
                        return;
                    }
                    this.setMapLocation(this.helper.getCurrentPoint());
                    break;
                }
                this.entityX += this.hspeed;
                this.x = (int)this.entityX;
                this.y = (int)this.entityY;
                if (this.entityX < 0.0f || this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
                    GameLogic.removeDelayedAction(this.life);
                    this.die();
                }
                if (!(this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT)) break;
                this.entityY = -32.0f;
                break;
            }
            case ZELDA: {
                if (!this.returningToPlayer) {
                    this.entityX += this.hspeed;
                } else {
                    float targetX = this.owner.entityX;
                    float targetY = this.owner.entityY;
                    this.vspeed = this.hspeed = Math.abs(this.hspeed);
                    if (targetX > this.entityX) {
                        this.entityX += this.hspeed;
                    } else if (targetX < this.entityX) {
                        this.entityX -= this.hspeed;
                    }
                    if (targetY > this.entityY) {
                        this.entityY += this.vspeed;
                    } else if (targetY < this.entityY) {
                        this.entityY -= this.vspeed;
                    }
                }
                this.x = (int)this.entityX;
                this.y = (int)this.entityY;
                if (this.entityX < 0.0f) {
                    this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
                } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
                    this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
                }
                if (!(this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT)) break;
                this.entityY = -32.0f;
            }
        }
    }

    private void setMapLocation(float entityX, float entityY) {
        this.entityX = entityX;
        this.entityY = entityY;
        this.x = (int)entityX;
        this.y = (int)entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
    }

    private void setMapLocation(Point2D.Float point) {
        this.setMapLocation(point.x - (float)(this.width / 2), point.y - (float)(this.height / 2));
    }

    @Override
    protected void updateImage(long timePassed) {
        this.leftAnim.update(timePassed);
        this.rightAnim.update(timePassed);
        this.currentImage = this.hspeed > 0.0f ? this.rightAnim.getImage() : this.leftAnim.getImage();
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    public void die() {
        super.die();
        SoundPlayer.stopSound(Sound.BOOMERANG);
    }

    public static enum BoomerangMotion {
        FLAT,
        SMB3,
        ZELDA;

    }
}

