/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.projectiles;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.SpriteColorModel;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.projectiles.Projectile;
import com.dmgame.particle.AnimatedParticle;
import com.dmgame.particle.ParticleLogic;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class FireballProjectile
extends Projectile {
    private static final long serialVersionUID = 1196514218670187148L;
    private transient Animation spriteAnim;
    public static final long MAX_LIFE_TIME = 3000L;

    public FireballProjectile(float x, float y, Team teamColor, Entity thrower, boolean horiz_die) {
        super("fireball", x, y, thrower);
        if (horiz_die) {
            this.ctypes.add(Entity.CollisionType.HORIZ_DIE);
        }
        this.setSize(18, 18);
        this.vspeed = 5.0f;
        GameLogic.startDelayedAction(3000L, new Runnable(){

            @Override
            public void run() {
                GameLogic.removeEntity(FireballProjectile.this);
                if (!FireballProjectile.this.spent) {
                    FireballProjectile.this.spent = true;
                    if (FireballProjectile.this.owner != null) {
                        --FireballProjectile.this.owner.ownedProjectiles;
                    }
                }
            }
        });
    }

    @Override
    public String getScriptCreateStatement() {
        boolean horiz_die = this.ctypes.contains((Object)Entity.CollisionType.HORIZ_DIE);
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",Team.", this.owner.teamColor.name(), ",", "entities.get(", this.owner.entityID, "),", horiz_die, ")");
    }

    public FireballProjectile(float x, float y, Entity thrower) {
        super("fireball", x, y, thrower);
        this.setSize(18, 18);
    }

    public FireballProjectile(float x, float y) {
        super("fireball", x, y, (Entity)null);
        this.setSize(18, 18);
        this.vspeed = 0.0f;
        this.hspeed = 0.0f;
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage sprite = ImageIO.read(new File("res/gfx/packs/Default/projectiles/" + spriteFilename + ".png"));
            BufferedImage[] sprites = new BufferedImage[]{sprite, Utility.rotateImage90(sprite, (byte)1), Utility.rotateImage90(sprite, (byte)2), Utility.rotateImage90(sprite, (byte)3)};
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, sprites);
            this.spriteAnim = new Animation(60L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.vspeed = !this.onGround ? (this.vspeed += 0.4f) : -6.0f;
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    public void updateImage(long timePassed) {
        this.spriteAnim.update(timePassed);
        this.currentImage = this.spriteAnim.getImage();
    }

    @Override
    public void die() {
        this.createParticles();
        super.die();
    }

    protected void createParticles() {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/particles/fireballexplosion.png"));
            BufferedImage[] particleAnim = new BufferedImage[]{spritesheet.getSubimage(0, 0, 32, 32), spritesheet.getSubimage(32, 0, 32, 32), spritesheet.getSubimage(64, 0, 32, 32)};
            Animation anim = new Animation(60L, particleAnim);
            AnimatedParticle particle = new AnimatedParticle(anim, new ParticleLogic(), this.entityX, this.entityY, 1);
            particle.addToMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

