/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.projectiles;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.SpriteColorModel;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.projectiles.Projectile;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class HammerProjectile
extends Projectile {
    private static final long serialVersionUID = -2282024472461077002L;
    private transient Animation movingAnim;
    private transient Animation movingAnimLeft;

    public HammerProjectile(float x, float y, Team teamColor, Entity thrower) {
        super("hammer", x, y, thrower);
        this.vspeed = -24.0f;
        this.setSize(28, 28);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",Team.", this.owner.teamColor.name(), ",", "entities.get(", this.owner.entityID, "))");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/Default/projectiles/" + spriteFilename + ".png"));
            BufferedImage spritesheetRev = Utility.getHorizontalFlippedCopy(spritesheet);
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, spritesheet, spritesheetRev);
            BufferedImage[] sprites = new BufferedImage[3];
            BufferedImage[] spritesRev = new BufferedImage[3];
            sprites[0] = spritesheet.getSubimage(0, 0, 28, 28);
            sprites[1] = spritesheet.getSubimage(28, 0, 28, 28);
            sprites[2] = spritesheet.getSubimage(56, 0, 28, 28);
            this.movingAnim = new Animation(60L, sprites);
            spritesRev[0] = spritesheetRev.getSubimage(56, 0, 28, 28);
            spritesRev[1] = spritesheetRev.getSubimage(28, 0, 28, 28);
            spritesRev[2] = spritesheetRev.getSubimage(0, 0, 28, 28);
            this.movingAnimLeft = new Animation(60L, spritesRev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.vspeed += 0.4f;
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        } else if (this.entityY < 0.0f) {
            this.die();
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.movingAnim.update(timePassed);
        this.movingAnimLeft.update(timePassed);
        this.currentImage = this.hspeed >= 0.0f ? this.movingAnim.getImage() : this.movingAnimLeft.getImage();
    }

    @Override
    public void collisionLogic() {
    }
}

