/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.projectiles;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SpriteColorModel;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import com.dmgame.entity.projectiles.Projectile;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class IceWandBlast
extends Projectile {
    private static final long serialVersionUID = -165973425212228459L;
    private Animation spriteAnim;

    public IceWandBlast(float x, float y, Team teamColor, Entity thrower) {
        super("icewandblast", x, y, thrower);
        this.vspeed = 0.0f;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",Team.", this.owner.teamColor.name(), ",", "entities.get(", this.owner.entityID, "))");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage spritesheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/projectiles/" + spriteFilename + ".png"));
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, spritesheet);
            BufferedImage[] sprites = new BufferedImage[]{spritesheet.getSubimage(0, 0, 32, 32), spritesheet.getSubimage(32, 0, 32, 32), spritesheet.getSubimage(64, 0, 32, 32), spritesheet.getSubimage(96, 0, 32, 32)};
            this.spriteAnim = new Animation(80L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Player && ((Player)i).teamColor != this.teamColor) {
            ((Player)i).freeze();
            this.die();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < -32.0f || this.entityX > (float)(GameLogic.currentMap.MAP_WIDTH + 32)) {
            this.die();
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.spriteAnim.update(timePassed);
        this.currentImage = this.spriteAnim.getImage();
    }

    @Override
    public void collisionLogic() {
    }
}

