/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity.projectiles;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.SMWException;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;

public abstract class Projectile
extends Entity {
    private static final long serialVersionUID = 1436317724105381493L;
    protected boolean spent;
    public Entity owner;

    public Projectile(String spriteFilename, float x, float y, Entity thrower) {
        super(spriteFilename, x, y, thrower != null ? thrower.teamColor : Team.UNALLIED);
        this.owner = thrower;
    }

    @Override
    protected void setTeamColor(Team teamColor) {
        try {
            float colorShift = 0.0f;
            switch (teamColor) {
                case GREEN: {
                    colorShift = 0.3f;
                    break;
                }
                case YELLOW: {
                    colorShift = 0.15f;
                    break;
                }
                case BLUE: {
                    colorShift = -0.3f;
                    break;
                }
                default: {
                    return;
                }
            }
            if (colorShift != 0.0f) {
                this.teamColors.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
            }
        }
        catch (SMWException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && ((Entity)i).teamColor != this.teamColor) {
            GameLogic.gamemode.reportKill(this, (Entity)i);
            ((Entity)i).die();
            this.die();
        }
    }

    @Override
    public void die() {
        GameLogic.removeEntity(this);
        if (!this.spent) {
            this.spent = true;
            if (this.owner != null) {
                --this.owner.ownedProjectiles;
            }
        }
    }

    @Override
    public void iTileBumpTop() {
    }
}

