/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.graphics;

import com.dmgame.Animation;
import com.dmgame.graphics.TileFX;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.ImageTile;
import com.dmgame.map.InteractiveTile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RecolorFX
extends TileFX
implements Serializable {
    private static final long serialVersionUID = -6756550959958970255L;
    public ArrayList<Color> baseColors;
    public ArrayList<Color> newColors;
    private transient GraphicTile[][] tiles;
    private transient JComponent drawComponent;
    private transient HashMap<BufferedImage, BufferedImage> newImages;
    private transient HashSet<BufferedImage> updatedImages;
    private static final int COLOR_SIZE = 8;

    @Override
    public BufferedImage alterImage(BufferedImage im, int frame, int modifier) {
        if (this.newImages == null) {
            this.newImages = new HashMap();
        }
        if (this.updatedImages == null) {
            this.updatedImages = new HashSet();
        }
        if (!this.updatedImages.contains(im) || !this.newImages.containsKey(im)) {
            BufferedImage newImage = new BufferedImage(32, 32, 2);
            for (int x = 0; x < im.getWidth(); ++x) {
                block1: for (int y = 0; y < im.getHeight(); ++y) {
                    for (int c = 0; c < this.baseColors.size(); ++c) {
                        Color currentColor;
                        Color oldColor = this.baseColors.get(c);
                        if (oldColor.equals(currentColor = new Color(im.getRGB(x, y), true))) {
                            newImage.setRGB(x, y, this.newColors.get(c).getRGB());
                            continue block1;
                        }
                        newImage.setRGB(x, y, new Color(0, 0, 0, 0).getRGB());
                    }
                }
            }
            this.newImages.put(im, newImage);
            this.updatedImages.add(im);
        }
        return this.newImages.get(im);
    }

    @Override
    public JComponent getDrawingComponent(GraphicTile[][] gTiles) {
        this.tiles = gTiles;
        this.drawComponent = new JPanel(){
            private static final long serialVersionUID = -3213292429215234699L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                for (int i = 0; i < RecolorFX.this.tiles.length; ++i) {
                    for (int j = 0; j < RecolorFX.this.tiles[0].length; ++j) {
                        if (RecolorFX.this.tiles[i][j] == null) continue;
                        g.drawImage(RecolorFX.this.tiles[i][j].getImage(), i * 32, j * 32, this);
                    }
                }
            }
        };
        this.drawComponent.setPreferredSize(new Dimension(this.tiles.length * 32, this.tiles[0].length * 32));
        this.drawComponent.repaint();
        return this.drawComponent;
    }

    @Override
    public JComponent getEditingComponent(GraphicTile[][] tiles) {
        this.baseColors = new ArrayList();
        this.newColors = new ArrayList();
        final JPanel comp = new JPanel(){
            private static final long serialVersionUID = 697030823654773456L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                for (int i = 0; i < RecolorFX.this.baseColors.size(); ++i) {
                    g.setColor(RecolorFX.this.baseColors.get(i));
                    g.fillRect(i * 8, 0, 8, 8);
                    g.setColor(RecolorFX.this.newColors.get(i));
                    g.fillRect(i * 8, 8, 8, 8);
                }
            }
        };
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int selectedColor = evt.getX() / 8;
                if (selectedColor >= RecolorFX.this.baseColors.size()) {
                    return;
                }
                Color c = JColorChooser.showDialog(comp, "Choose a color...", RecolorFX.this.baseColors.get(selectedColor));
                if (c == null) {
                    return;
                }
                if (c.getRed() == 255 && c.getGreen() == 0 && c.getBlue() == 255) {
                    c = new Color(255, 0, 0, 0);
                }
                RecolorFX.this.updatedImages = new HashSet();
                RecolorFX.this.newColors.set(selectedColor, c);
                comp.repaint();
                RecolorFX.this.drawComponent.repaint();
                LevelEditorScene.recalculateMapImages();
            }
        });
        GraphicTile[][] arr$ = tiles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GraphicTile[] array;
            for (GraphicTile tile : array = arr$[i$]) {
                if (tile == null) continue;
                if (tile instanceof ImageTile) {
                    this.addTileColors(tile.getImage());
                    continue;
                }
                Animation ani = tile instanceof AnimatedTile ? ((AnimatedTile)tile).tile : ((InteractiveTile)tile).tile;
                int frames = ani.size();
                for (int i = 0; i < frames; ++i) {
                    this.addTileColors(ani.getImageAt(i));
                }
            }
        }
        comp.setPreferredSize(new Dimension(this.baseColors.size() * 8, 16));
        return comp;
    }

    private void addTileColors(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Color c = new Color(image.getRGB(x, y), true);
                if (c.getAlpha() == 0 || this.baseColors.contains(c)) continue;
                this.baseColors.add(c);
                this.newColors.add(c);
            }
        }
    }
}

