/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.BitmapFont;
import com.dmgame.MapScene;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SMWBasicButton
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 8670011956713605642L;
    protected static BitmapFont fontPainter = SMWBasicButton.getBitmapFont();
    protected String text;
    protected Dimension textDim;
    protected BufferedImage button;
    protected BufferedImage buttonSelected;
    protected BufferedImage buttonPressed;
    protected boolean mouseOver;
    protected boolean pressed;
    protected ActionListener listener;
    protected String actionCommand;

    public SMWBasicButton(String text) {
        this.text = text;
        this.mouseOver = false;
        try {
            this.button = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button.png"));
            this.buttonSelected = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button_selected.png"));
            this.buttonPressed = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button_pressed.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textDim = fontPainter.getStringDimensions(text);
        this.setBounds(this.getX(), this.getY(), this.button.getWidth(), this.button.getHeight());
        Dimension dim = new Dimension(this.button.getWidth(), this.button.getHeight());
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.revalidate();
        this.addMouseListener(this);
    }

    private static BitmapFont getBitmapFont() {
        try {
            return new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.drawImage((Image)(this.pressed ? this.buttonPressed : (this.mouseOver ? this.buttonSelected : this.button)), 0, 0, null);
        if (this.text != null) {
            int xPos = 0 + (this.button.getWidth() - this.textDim.width) / 2;
            fontPainter.drawString(g2D, this.text, this.pressed ? xPos + 2 : xPos, 0 + (this.button.getHeight() - this.textDim.height) / 2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseOver = true;
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOver = false;
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = true;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        e.consume();
        if (this.listener != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.listener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMWBasicButton.this.listener.actionPerformed(new ActionEvent(this, 0, SMWBasicButton.this.actionCommand));
                    }
                });
            }
        }
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setActionCommand(String s) {
        this.actionCommand = s;
    }

    public void setText(String text) {
        this.text = text;
        this.textDim = fontPainter.getStringDimensions(text);
    }

    public String getText() {
        return this.text;
    }

    public Dimension getDimensions() {
        return new Dimension(this.button.getWidth(), this.button.getHeight());
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        JPanel contentPanel = new JPanel(new GridLayout(4, 0));
        SMWBasicButton button1 = new SMWBasicButton("Start Game");
        SMWBasicButton button2 = new SMWBasicButton("Network Mode");
        SMWBasicButton button3 = new SMWBasicButton("Options");
        SMWBasicButton button4 = new SMWBasicButton("Exit");
        button1.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Start!");
            }
        });
        button2.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Network!");
            }
        });
        button3.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Options!");
            }
        });
        button4.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Bye!");
                System.exit(0);
            }
        });
        contentPanel.add(button1);
        contentPanel.add(button2);
        contentPanel.add(button3);
        contentPanel.add(button4);
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.getContentPane().setPreferredSize(new Dimension(1024, 768));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        frame.getContentPane().add((Component)contentPanel, c);
        frame.pack();
        frame.setVisible(true);
        while (frame.isVisible()) {
            frame.repaint();
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

