/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.BitmapFont;
import com.dmgame.MapScene;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class SMWButton
extends JComponent
implements MouseListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final Color SPLIT_COLOR = new Color(255, 0, 255);
    private static final int PADDING = 8;
    public static final int DEFAULT_WIDTH = 512;
    public static final int DEFAULT_HEIGHT = 32;
    private static BufferedImage[][] defaultButton;
    private static BufferedImage[][] defaultHover;
    private static BufferedImage[][] defaultPressed;
    private boolean selected;
    protected static BitmapFont fontPainter;
    private State state;
    private BufferedImage[][] button;
    private BufferedImage[][] buttonHover;
    private BufferedImage[][] buttonPressed;
    private BufferedImage iconImage;
    private String text;
    protected Dimension textDim;
    private String actionCommand;
    private LinkedList<ActionListener> listeners = new LinkedList();

    public SMWButton(BufferedImage buttonImage, BufferedImage hoverImage, BufferedImage pressedImage, String text, int width, int height) {
        this.text = text;
        this.button = SMWButton.splitGraphic(buttonImage);
        this.buttonHover = SMWButton.splitGraphic(hoverImage);
        this.buttonPressed = SMWButton.splitGraphic(pressedImage);
        this.redetermineSize(width, height);
        this.state = State.NORMAL;
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public SMWButton(String text) {
        this.text = text;
        if (defaultButton == null) {
            SMWButton.loadDefaultGraphics();
        }
        this.button = defaultButton;
        this.buttonHover = defaultHover;
        this.buttonPressed = defaultPressed;
        this.redetermineSize(-1, -1);
        this.state = State.NORMAL;
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public SMWButton(String text, int width, int height) {
        this.text = text;
        if (defaultButton == null) {
            SMWButton.loadDefaultGraphics();
        }
        this.button = defaultButton;
        this.buttonHover = defaultHover;
        this.buttonPressed = defaultPressed;
        this.redetermineSize(width, height);
        this.state = State.NORMAL;
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public SMWButton(String s, BufferedImage icon) {
        this(s);
        this.iconImage = icon;
        this.redetermineSize(-1, -1);
    }

    public SMWButton(BufferedImage icon) {
        this("", icon);
    }

    public SMWButton(String s, int width, int height, BufferedImage icon) {
        this(s, width, height);
        this.iconImage = icon;
        this.redetermineSize(width, height);
    }

    public SMWButton(BufferedImage buttonImage, BufferedImage hoverImage, BufferedImage pressedImage, String text, int width, int height, BufferedImage icon) {
        this(buttonImage, hoverImage, pressedImage, text, width, height);
        this.iconImage = icon;
        this.redetermineSize(width, height);
    }

    public void redetermineSize(int width, int height) {
        int workingWidth = width;
        int workingHeight = height;
        int widthRemainder = (workingWidth -= this.button[0][0].getWidth() + this.button[2][0].getWidth()) % this.button[1][0].getWidth();
        int heightRemainder = (workingHeight -= this.button[0][0].getHeight() + this.button[0][2].getHeight()) % this.button[1][0].getHeight();
        height += heightRemainder;
        this.textDim = fontPainter.getStringDimensions(this.text);
        if (this.textDim.width > (width += widthRemainder)) {
            width = this.textDim.width + 8;
        }
        if (this.textDim.height > height) {
            height = this.textDim.height + 8;
        }
        if (this.iconImage != null && (width < 10 || height < 10)) {
            width = this.iconImage.getWidth() + 16;
            height = this.iconImage.getHeight() + 8;
        }
        Dimension dim = new Dimension(width, height);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
    }

    public static BufferedImage[][] splitGraphic(BufferedImage buttonImage) {
        BufferedImage[][] button = new BufferedImage[3][3];
        int topRow = -1;
        int bottomRow = -1;
        int leftColumn = -1;
        int rightColumn = -1;
        for (int i = 0; i < buttonImage.getWidth(); ++i) {
            if (buttonImage.getRGB(i, 0) != SPLIT_COLOR.getRGB()) continue;
            if (leftColumn < 0) {
                leftColumn = i;
                continue;
            }
            rightColumn = i;
            break;
        }
        for (int j = 0; j < buttonImage.getHeight(); ++j) {
            if (buttonImage.getRGB(0, j) != SPLIT_COLOR.getRGB()) continue;
            if (topRow < 0) {
                topRow = j;
                continue;
            }
            bottomRow = j;
            break;
        }
        button[0][0] = buttonImage.getSubimage(0, 0, leftColumn, topRow);
        button[1][0] = buttonImage.getSubimage(leftColumn + 1, 0, rightColumn - leftColumn - 1, topRow);
        button[2][0] = buttonImage.getSubimage(rightColumn + 1, 0, buttonImage.getWidth() - rightColumn - 1, topRow);
        button[0][1] = buttonImage.getSubimage(0, topRow + 1, leftColumn, bottomRow - topRow - 1);
        button[1][1] = buttonImage.getSubimage(leftColumn + 1, topRow + 1, rightColumn - leftColumn - 1, bottomRow - topRow - 1);
        button[2][1] = buttonImage.getSubimage(rightColumn + 1, topRow + 1, buttonImage.getWidth() - rightColumn - 1, bottomRow - topRow - 1);
        button[0][2] = buttonImage.getSubimage(0, bottomRow + 1, leftColumn, buttonImage.getHeight() - bottomRow - 1);
        button[1][2] = buttonImage.getSubimage(leftColumn + 1, bottomRow + 1, rightColumn - leftColumn, buttonImage.getHeight() - bottomRow - 1);
        button[2][2] = buttonImage.getSubimage(rightColumn + 1, bottomRow + 1, buttonImage.getWidth() - rightColumn - 1, buttonImage.getHeight() - bottomRow - 1);
        return button;
    }

    @Override
    public void paintComponent(Graphics g) {
        int xPos;
        int x;
        BufferedImage[][] buttonGraphic;
        Graphics2D g2D = (Graphics2D)g;
        switch (this.state) {
            case NORMAL: {
                buttonGraphic = this.button;
                break;
            }
            case HOVER: {
                buttonGraphic = this.buttonHover;
                break;
            }
            case PRESS: {
                buttonGraphic = this.buttonPressed;
                break;
            }
            default: {
                buttonGraphic = this.button;
            }
        }
        int repeatWidth = buttonGraphic[1][0].getWidth();
        int repeatHeight = buttonGraphic[0][1].getHeight();
        for (x = buttonGraphic[0][0].getWidth(); x < this.getWidth() - buttonGraphic[2][0].getWidth(); x += repeatWidth) {
            for (int y = buttonGraphic[0][0].getHeight(); y < this.getHeight() - buttonGraphic[0][2].getHeight(); y += repeatHeight) {
                g2D.drawImage((Image)buttonGraphic[1][1], x, y, null);
            }
        }
        for (x = buttonGraphic[0][0].getWidth(); x < this.getWidth() - buttonGraphic[2][0].getWidth(); x += repeatWidth) {
            g2D.drawImage((Image)buttonGraphic[1][0], x, 0, null);
            g2D.drawImage((Image)buttonGraphic[1][2], x, this.getHeight() - buttonGraphic[0][2].getHeight(), null);
        }
        for (int y = buttonGraphic[0][0].getHeight(); y < this.getHeight() - buttonGraphic[0][2].getHeight(); y += repeatHeight) {
            g2D.drawImage((Image)buttonGraphic[0][1], 0, y, null);
            g2D.drawImage((Image)buttonGraphic[2][1], this.getWidth() - buttonGraphic[2][0].getWidth(), y, null);
        }
        g2D.drawImage((Image)buttonGraphic[0][0], 0, 0, null);
        g2D.drawImage((Image)buttonGraphic[2][0], this.getWidth() - buttonGraphic[2][0].getWidth(), 0, null);
        g2D.drawImage((Image)buttonGraphic[0][2], 0, this.getHeight() - buttonGraphic[0][2].getHeight(), null);
        g2D.drawImage((Image)buttonGraphic[2][2], this.getWidth() - buttonGraphic[2][2].getWidth(), this.getHeight() - buttonGraphic[2][2].getHeight(), null);
        if (this.iconImage != null) {
            xPos = (this.getWidth() - this.textDim.width) / 2 - this.iconImage.getWidth();
            if (xPos < 0) {
                xPos = 8;
            }
            g2D.drawImage((Image)this.iconImage, xPos, (this.getHeight() - this.iconImage.getHeight()) / 2, this);
        }
        if (this.text != null) {
            xPos = (this.getWidth() - this.textDim.width) / 2;
            fontPainter.drawString(g2D, this.text, this.state == State.PRESS ? xPos + 2 : xPos, 0 + (this.getHeight() - this.textDim.height) / 2);
        }
    }

    public void setActionCommand(String s) {
        this.actionCommand = s;
    }

    public void addActionListener(ActionListener al) {
        if (!this.listeners.contains(al)) {
            this.listeners.add(al);
        }
    }

    private void fireActionPerformed(ActionEvent actionEvent) {
        for (ActionListener al : this.listeners) {
            al.actionPerformed(actionEvent);
        }
    }

    public void setText(String string) {
        this.text = string;
        this.textDim = fontPainter.getStringDimensions(this.text);
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.state = b ? State.HOVER : State.NORMAL;
        this.repaint();
    }

    public void setIcon(BufferedImage newThumb) {
        this.iconImage = newThumb;
        this.repaint();
    }

    private static BitmapFont getBitmapFont() {
        try {
            return new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void loadDefaultGraphics() {
        try {
            defaultButton = SMWButton.splitGraphic(ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button_9patch.png")));
            defaultHover = SMWButton.splitGraphic(ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button_hover_9patch.png")));
            defaultPressed = SMWButton.splitGraphic(ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/button_press_9patch.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.state = State.PRESS;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state == State.PRESS) {
            this.fireActionPerformed(new ActionEvent(this, 0, this.actionCommand));
        }
        if (!this.selected) {
            this.state = State.NORMAL;
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.state = State.HOVER;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != State.PRESS && !this.selected) {
            this.state = State.NORMAL;
            this.repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    static {
        fontPainter = SMWButton.getBitmapFont();
    }

    private static enum State {
        NORMAL,
        HOVER,
        PRESS;

    }
}

