/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.Utility;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SMWInternalFrame
extends JPanel {
    private static final long serialVersionUID = 6922894145425366966L;
    private static final int DEF_WIDTH = 192;
    private static final int DEF_HEIGHT = 128;
    Container container;
    private static final Rectangle BOUNDS = new Rectangle(416, 320, 192, 128);
    BufferedImage[][] bgImage;

    public static void showErrorDialog(Container container, String message) {
        SMWInternalFrame.showErrorDialog(container, message, 192, 128);
    }

    public static void showErrorDialog(Container container, String message, int dialogWidth, int dialogHeight) {
        final SMWInternalFrame frame = new SMWInternalFrame(container, dialogWidth, dialogHeight);
        frame.setLayout(null);
        SMWLabel label = new SMWLabel(message);
        int width = label.getPreferredSize().width;
        int height = label.getPreferredSize().height;
        label.setBounds(frame.getWidth() / 2 - width / 2, 16, width, height);
        frame.add(label);
        SMWButton acceptButton = new SMWButton(Utility.lang.getProperty("back"));
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.close();
            }
        });
        width = acceptButton.getPreferredSize().width;
        height = acceptButton.getPreferredSize().height;
        acceptButton.setBounds(frame.getWidth() / 2 - width / 2, (int)((double)frame.getHeight() * 0.75), width * 2, height);
        frame.add(acceptButton);
        frame.validate();
    }

    public SMWInternalFrame(Container container) {
        this(container, 192, 128);
    }

    public SMWInternalFrame(Container container, int width, int height) {
        this(width, height);
        this.container = container;
        container.add((Component)this, 0);
    }

    public SMWInternalFrame(int width, int height) {
        try {
            this.bgImage = SMWButton.splitGraphic(ImageIO.read(new File("res/gfx/packs/Default/menu/dialog_9patch.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(SMWInternalFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setBounds(512 - width / 2, 384 - height / 2, width, height);
    }

    public void close() {
        this.container.remove(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        Graphics2D g2D = (Graphics2D)g;
        int repeatWidth = this.bgImage[1][0].getWidth();
        int repeatHeight = this.bgImage[0][1].getHeight();
        for (x = this.bgImage[0][0].getWidth(); x < this.getWidth() - this.bgImage[2][0].getWidth(); x += repeatWidth) {
            for (int y = this.bgImage[0][0].getHeight(); y < this.getHeight() - this.bgImage[0][2].getHeight(); y += repeatHeight) {
                g2D.drawImage((Image)this.bgImage[1][1], x, y, null);
            }
        }
        for (x = this.bgImage[0][0].getWidth(); x < this.getWidth() - this.bgImage[2][0].getWidth(); x += repeatWidth) {
            g2D.drawImage((Image)this.bgImage[1][0], x, 0, null);
            g2D.drawImage((Image)this.bgImage[1][2], x, this.getHeight() - this.bgImage[0][2].getHeight(), null);
        }
        for (int y = this.bgImage[0][0].getHeight(); y < this.getHeight() - this.bgImage[0][2].getHeight(); y += repeatHeight) {
            g2D.drawImage((Image)this.bgImage[0][1], 0, y, null);
            g2D.drawImage((Image)this.bgImage[2][1], this.getWidth() - this.bgImage[2][0].getWidth(), y, null);
        }
        g2D.drawImage((Image)this.bgImage[0][0], 0, 0, null);
        g2D.drawImage((Image)this.bgImage[2][0], this.getWidth() - this.bgImage[2][0].getWidth(), 0, null);
        g2D.drawImage((Image)this.bgImage[0][2], 0, this.getHeight() - this.bgImage[0][2].getHeight(), null);
        g2D.drawImage((Image)this.bgImage[2][2], this.getWidth() - this.bgImage[2][2].getWidth(), this.getHeight() - this.bgImage[2][2].getHeight(), null);
    }

    public void setCenteredBounds(Container parent) {
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        int x = parent.getPreferredSize().width / 2 - width / 2;
        int y = parent.getPreferredSize().height / 2 - height / 2;
        this.setBounds(x, y, width, height);
    }
}

