/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.BitmapFont;
import com.dmgame.gui.SMWButton;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class SMWLabel
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected static final int PADDING = 8;
    BufferedImage iconImage;
    BufferedImage bgStaticImage;
    BufferedImage[][] bgDynamicImage;
    boolean bgIsDynamic;
    protected static BitmapFont fontPainter = SMWLabel.getBitmapFont();
    private String text;
    protected Dimension textDim;

    public SMWLabel() {
        this("");
    }

    public SMWLabel(int width, int height) {
        this("", width, height);
    }

    public SMWLabel(String text) {
        this(text, -1, -1);
    }

    public SMWLabel(String text, int width, int height) {
        this.text = text;
        this.textDim = fontPainter.getStringDimensions(text);
        this.bgIsDynamic = false;
        this.redetermineSize(width, height);
    }

    protected void redetermineSize(int width, int height) {
        this.textDim = fontPainter.getStringDimensions(this.text);
        if (this.textDim.width > width) {
            width = this.textDim.width + 8;
        }
        if (this.textDim.height > height) {
            height = this.textDim.height + 8;
        }
        if (this.iconImage != null && (width < 10 || height < 10)) {
            width = this.iconImage.getWidth() + 16;
            height = this.iconImage.getHeight() + 8;
        }
        Dimension dim = new Dimension(width, height);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
    }

    @Override
    public void paintComponent(Graphics g) {
        int xPos;
        Graphics2D g2D = (Graphics2D)g;
        if (this.bgIsDynamic && this.bgDynamicImage != null) {
            int x;
            int repeatWidth = this.bgDynamicImage[1][0].getWidth();
            int repeatHeight = this.bgDynamicImage[0][1].getHeight();
            for (x = this.bgDynamicImage[0][0].getWidth(); x < this.getWidth() - this.bgDynamicImage[2][0].getWidth(); x += repeatWidth) {
                for (int y = this.bgDynamicImage[0][0].getHeight(); y < this.getHeight() - this.bgDynamicImage[0][2].getHeight(); y += repeatHeight) {
                    g2D.drawImage((Image)this.bgDynamicImage[1][1], x, y, null);
                }
            }
            for (x = this.bgDynamicImage[0][0].getWidth(); x < this.getWidth() - this.bgDynamicImage[2][0].getWidth(); x += repeatWidth) {
                g2D.drawImage((Image)this.bgDynamicImage[1][0], x, 0, null);
                g2D.drawImage((Image)this.bgDynamicImage[1][2], x, this.getHeight() - this.bgDynamicImage[0][2].getHeight(), null);
            }
            for (int y = this.bgDynamicImage[0][0].getHeight(); y < this.getHeight() - this.bgDynamicImage[0][2].getHeight(); y += repeatHeight) {
                g2D.drawImage((Image)this.bgDynamicImage[0][1], 0, y, null);
                g2D.drawImage((Image)this.bgDynamicImage[2][1], this.getWidth() - this.bgDynamicImage[2][0].getWidth(), y, null);
            }
            g2D.drawImage((Image)this.bgDynamicImage[0][0], 0, 0, null);
            g2D.drawImage((Image)this.bgDynamicImage[2][0], this.getWidth() - this.bgDynamicImage[2][0].getWidth(), 0, null);
            g2D.drawImage((Image)this.bgDynamicImage[0][2], 0, this.getHeight() - this.bgDynamicImage[0][2].getHeight(), null);
            g2D.drawImage((Image)this.bgDynamicImage[2][2], this.getWidth() - this.bgDynamicImage[2][2].getWidth(), this.getHeight() - this.bgDynamicImage[2][2].getHeight(), null);
        } else if (this.bgStaticImage != null) {
            g2D.drawImage((Image)this.bgStaticImage, 0, 0, null);
        }
        if (this.iconImage != null) {
            xPos = (this.getWidth() - this.textDim.width) / 2 - this.iconImage.getWidth();
            if (xPos < 0) {
                xPos = 8;
            }
            g2D.drawImage((Image)this.iconImage, xPos, (this.getHeight() - this.iconImage.getHeight()) / 2, this);
        }
        if (this.text != null) {
            xPos = (this.getWidth() - this.textDim.width) / 2;
            fontPainter.drawString(g2D, this.text, xPos, 0 + (this.getHeight() - this.textDim.height) / 2);
        }
    }

    public void setText(String string) {
        this.text = string;
        this.textDim = fontPainter.getStringDimensions(this.text);
        this.repaint();
    }

    public void setDynamicBackground(BufferedImage[][] bg) {
        this.bgDynamicImage = bg;
        this.bgIsDynamic = true;
    }

    public void setDynamicBackground(BufferedImage bg) {
        this.bgDynamicImage = SMWButton.splitGraphic(bg);
        this.bgIsDynamic = true;
    }

    public void setStaticBackground(BufferedImage bg) {
        this.bgStaticImage = bg;
        this.bgIsDynamic = false;
    }

    public void setIcon(BufferedImage newThumb) {
        this.iconImage = newThumb;
        this.repaint();
    }

    private static BitmapFont getBitmapFont() {
        try {
            return new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

