/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.BitmapFont;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.SpriteColorModel;
import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SMWPlayerSelector
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = -6866888266685249321L;
    private static BitmapFont fontPainter = SMWPlayerSelector.getBitmapFont();
    private File[] skins = new File("res/gfx/skins/").listFiles();
    private PlayerChangeComponent playerOne;
    private PlayerChangeComponent playerTwo;
    private PlayerChangeComponent playerThree;
    private PlayerChangeComponent playerFour;
    private PlayerChangeComponent playerSelected;

    public SMWPlayerSelector() {
        this((PlayerOptions[])null);
    }

    private static BitmapFont getBitmapFont() {
        try {
            return new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SMWPlayerSelector(PlayerOptions[] options) {
        if (options == null) {
            options = new PlayerOptions[4];
        }
        try {
            this.playerOne = new PlayerChangeComponent(1, options[0]);
            this.playerTwo = new PlayerChangeComponent(2, options[1]);
            this.playerThree = new PlayerChangeComponent(3, options[2]);
            this.playerFour = new PlayerChangeComponent(4, options[3]);
        }
        catch (SMWException e) {
            e.printStackTrace();
        }
        this.playerSelected = this.playerOne;
        this.add(this.playerOne);
        this.add(this.playerTwo);
        this.add(this.playerThree);
        this.add(this.playerFour);
        this.playerOne.addKeyListener(this);
        this.playerTwo.addKeyListener(this);
        this.playerThree.addKeyListener(this);
        this.playerFour.addKeyListener(this);
        this.setFocusable(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.playerSelected.type.getText().equals("None")) {
            e.consume();
            return;
        }
        block0 : switch (keyCode) {
            case 38: {
                this.playerSelected.changer.shiftSkin(true);
                break;
            }
            case 40: {
                this.playerSelected.changer.shiftSkin(false);
                break;
            }
            case 37: {
                switch (this.playerSelected.changer.team) {
                    case RED: {
                        this.playerSelected.changer.shiftColor(Team.BLUE);
                        break block0;
                    }
                    case GREEN: {
                        this.playerSelected.changer.shiftColor(Team.RED);
                        break block0;
                    }
                    case YELLOW: {
                        this.playerSelected.changer.shiftColor(Team.GREEN);
                        break block0;
                    }
                    case BLUE: {
                        this.playerSelected.changer.shiftColor(Team.YELLOW);
                        break block0;
                    }
                }
                break;
            }
            case 39: {
                switch (this.playerSelected.changer.team) {
                    case RED: {
                        this.playerSelected.changer.shiftColor(Team.GREEN);
                        break block0;
                    }
                    case GREEN: {
                        this.playerSelected.changer.shiftColor(Team.YELLOW);
                        break block0;
                    }
                    case YELLOW: {
                        this.playerSelected.changer.shiftColor(Team.BLUE);
                        break block0;
                    }
                    case BLUE: {
                        this.playerSelected.changer.shiftColor(Team.RED);
                        break block0;
                    }
                }
                break;
            }
            default: {
                e.consume();
                return;
            }
        }
        if (this.playerSelected.listener != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.playerSelected.listener.stateChanged(new ChangeEvent(this.playerSelected));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMWPlayerSelector.this.playerSelected.listener.stateChanged(new ChangeEvent(SMWPlayerSelector.this.playerSelected));
                    }
                });
            }
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    public void setChangeListener(int id, ChangeListener listener) {
        switch (id) {
            case 1: {
                this.playerOne.listener = listener;
                break;
            }
            case 2: {
                this.playerTwo.listener = listener;
                break;
            }
            case 3: {
                this.playerThree.listener = listener;
                break;
            }
            case 4: {
                this.playerFour.listener = listener;
            }
        }
    }

    public PlayerOptions[] getSettings() {
        PlayerOptions[] options = new PlayerOptions[4];
        String s = this.skins[this.playerOne.changer.skinsIndex].getName();
        options[0] = new PlayerOptions(1, this.playerOne.type.getText(), s.substring(0, s.indexOf(".")), this.playerOne.changer.team, this.playerOne.changer.skinsIndex);
        s = this.skins[this.playerTwo.changer.skinsIndex].getName();
        options[1] = new PlayerOptions(2, this.playerTwo.type.getText(), s.substring(0, s.indexOf(".")), this.playerTwo.changer.team, this.playerTwo.changer.skinsIndex);
        s = this.skins[this.playerThree.changer.skinsIndex].getName();
        options[2] = new PlayerOptions(3, this.playerThree.type.getText(), s.substring(0, s.indexOf(".")), this.playerThree.changer.team, this.playerThree.changer.skinsIndex);
        s = this.skins[this.playerFour.changer.skinsIndex].getName();
        options[3] = new PlayerOptions(4, this.playerFour.type.getText(), s.substring(0, s.indexOf(".")), this.playerFour.changer.team, this.playerFour.changer.skinsIndex);
        return options;
    }

    public void exportPlayers() {
        String skinName;
        if (this.playerOne.hasPlayer()) {
            skinName = this.skins[this.playerOne.changer.skinsIndex].getName();
            skinName = skinName.substring(0, skinName.indexOf("."));
            System.out.println("Player one: " + skinName + ", " + (Object)((Object)this.playerOne.changer.team) + ", " + this.playerOne.type.getText().equals("Bot"));
        }
        if (this.playerTwo.hasPlayer()) {
            skinName = this.skins[this.playerTwo.changer.skinsIndex].getName();
            skinName = skinName.substring(0, skinName.indexOf("."));
            System.out.println("Player two: " + skinName + ", " + (Object)((Object)this.playerTwo.changer.team) + ", " + this.playerTwo.type.getText().equals("Bot"));
        }
        if (this.playerThree.hasPlayer()) {
            skinName = this.skins[this.playerThree.changer.skinsIndex].getName();
            skinName = skinName.substring(0, skinName.indexOf("."));
            System.out.println("Player three: " + skinName + ", " + (Object)((Object)this.playerThree.changer.team) + ", " + this.playerThree.type.getText().equals("Bot"));
        }
        if (this.playerFour.hasPlayer()) {
            skinName = this.skins[this.playerFour.changer.skinsIndex].getName();
            skinName = skinName.substring(0, skinName.indexOf("."));
            System.out.println("Player four: " + skinName + ", " + (Object)((Object)this.playerFour.changer.team) + ", " + this.playerFour.type.getText().equals("Bot"));
        }
        System.out.println("Exported player settings.");
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    private class PlayerChangeComponent
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = -2564831933756030148L;
        private PlayerChanger changer;
        private TypeButton type;
        private int id;
        private ChangeListener listener;

        private PlayerChangeComponent(int id) throws SMWException {
            this(id, null);
        }

        private PlayerChangeComponent(int id, PlayerOptions op) throws SMWException {
            if (id < 1 || id > 4) {
                throw new SMWException("ID must be between 1 and 4 (inclusive).");
            }
            this.id = id;
            this.type = new TypeButton();
            if (op != null) {
                this.changer = new PlayerChanger(op.SKIN_NUM, op.TEAM);
                this.type.setText(op.TYPE);
            } else {
                Team team;
                switch (id) {
                    case 1: {
                        team = Team.RED;
                        break;
                    }
                    case 2: {
                        team = Team.GREEN;
                        break;
                    }
                    case 3: {
                        team = Team.YELLOW;
                        break;
                    }
                    case 4: {
                        team = Team.BLUE;
                        break;
                    }
                    default: {
                        team = Team.RED;
                    }
                }
                this.changer = new PlayerChanger(0, team);
            }
            this.setLayout(new GridLayout(2, 1));
            this.add(this.changer);
            this.add(this.type);
            this.addMouseListener(this);
            if (this.type.getText().equals("None")) {
                this.changer.noneSkin();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SMWPlayerSelector.this.playerSelected = this;
            this.requestFocusInWindow();
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.consume();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlayerChangeComponent other = (PlayerChangeComponent)obj;
            return this.id == other.id;
        }

        private boolean hasPlayer() {
            return !this.type.getText().equals("None");
        }

        private class TypeButton
        extends SMWButton
        implements ActionListener {
            private static final long serialVersionUID = 6899736372762432078L;
            private static final String NONE = "None";
            private static final String HUMAN = "Human";
            private static final String AI = "Bot";

            private TypeButton() {
                super(NONE);
                this.revalidate();
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = this.getText();
                if (s.equals(NONE)) {
                    this.setText(HUMAN);
                    PlayerChangeComponent.this.changer.shiftSkin(true);
                    PlayerChangeComponent.this.changer.shiftSkin(false);
                } else if (s.equals(HUMAN)) {
                    this.setText(AI);
                } else if (s.equals(AI)) {
                    this.setText(NONE);
                    PlayerChangeComponent.this.changer.noneSkin();
                }
            }
        }

        private class PlayerChanger
        extends JComponent {
            private static final long serialVersionUID = -952949850040044162L;
            private int skinsIndex;
            private BufferedImage playerChooseBox;
            private BufferedImage playerChooseBoxFocused;
            private BufferedImage skin;
            private SpriteColorModel model;
            private Team team;

            private PlayerChanger(int i, Team team) {
                this.skinsIndex = i;
                try {
                    this.playerChooseBox = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/player_select_box.png"));
                    this.playerChooseBoxFocused = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/player_select_box_focus.png"));
                    this.skin = ImageIO.read(SMWPlayerSelector.this.skins[this.skinsIndex]).getSubimage(0, 0, 32, 32);
                    this.model = new SpriteColorModel(team.colors, Color.RED, this.skin);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (team != null) {
                    this.team = team;
                } else {
                    switch (PlayerChangeComponent.this.id) {
                        case 1: {
                            this.team = Team.RED;
                            break;
                        }
                        case 2: {
                            this.team = Team.GREEN;
                            break;
                        }
                        case 3: {
                            this.team = Team.YELLOW;
                            break;
                        }
                        case 4: {
                            this.team = Team.BLUE;
                            break;
                        }
                        default: {
                            this.team = Team.RED;
                        }
                    }
                }
                switch (this.team) {
                    case GREEN: {
                        this.shiftColor(Team.GREEN);
                        break;
                    }
                    case YELLOW: {
                        this.shiftColor(Team.YELLOW);
                        break;
                    }
                    case BLUE: {
                        this.shiftColor(Team.BLUE);
                        break;
                    }
                }
                this.setBounds(this.getX(), this.getY(), this.playerChooseBox.getWidth(), this.playerChooseBox.getHeight() + 32);
                Dimension dim = new Dimension(this.playerChooseBox.getWidth(), this.playerChooseBox.getHeight() + 32);
                this.setSize(dim);
                this.setPreferredSize(dim);
                this.setMinimumSize(dim);
                this.setMaximumSize(dim);
                this.revalidate();
            }

            private PlayerChanger() {
                this(0, null);
            }

            private void shiftSkin(boolean inc) {
                try {
                    float colorShift;
                    this.skinsIndex = inc ? (this.skinsIndex < SMWPlayerSelector.this.skins.length - 1 ? ++this.skinsIndex : 0) : (this.skinsIndex > 0 ? --this.skinsIndex : SMWPlayerSelector.this.skins.length - 1);
                    this.skin = ImageIO.read(SMWPlayerSelector.this.skins[this.skinsIndex]).getSubimage(0, 0, 32, 32);
                    this.model.clear();
                    this.model.addSprites(this.skin);
                    switch (this.team) {
                        case GREEN: {
                            colorShift = 0.3f;
                            break;
                        }
                        case YELLOW: {
                            colorShift = 0.15f;
                            break;
                        }
                        case BLUE: {
                            colorShift = -0.3f;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    if (colorShift != 0.0f) {
                        this.model.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            private void noneSkin() {
                try {
                    this.skin = ImageIO.read(SMWPlayerSelector.this.skins[this.skinsIndex]).getSubimage(0, 0, 32, 32);
                    this.model.clear();
                    this.model.addSprites(this.skin);
                    this.model.greyscale();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            private void shiftColor(Team team) {
                try {
                    float colorShift;
                    this.team = team;
                    switch (team) {
                        case RED: {
                            colorShift = 0.0f;
                            break;
                        }
                        case GREEN: {
                            colorShift = 0.3f;
                            break;
                        }
                        case YELLOW: {
                            colorShift = 0.15f;
                            break;
                        }
                        case BLUE: {
                            colorShift = -0.3f;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.model.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2D = (Graphics2D)g;
                if (PlayerChangeComponent.this.equals(SMWPlayerSelector.this.playerSelected)) {
                    g2D.drawImage((Image)this.playerChooseBoxFocused, this.getX(), this.getY(), null);
                } else {
                    g2D.drawImage((Image)this.playerChooseBox, this.getX(), this.getY(), null);
                }
                g2D.drawImage((Image)this.skin, this.getX() + (this.playerChooseBox.getWidth() - this.skin.getWidth()) / 2, this.getY() + (this.playerChooseBox.getHeight() - this.skin.getHeight()) / 2, null);
                String s = SMWPlayerSelector.this.skins[this.skinsIndex].getName();
                fontPainter.drawString(g2D, s.substring(0, s.indexOf(".")), this.getX(), this.getY() + this.playerChooseBox.getHeight() + 4);
            }
        }
    }
}

