/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.BitmapFont;
import com.dmgame.MapScene;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SMWSlider
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1892602452384988588L;
    private static BitmapFont counter = SMWSlider.getCounter();
    private BufferedImage barImage;
    private BufferedImage counterImage;
    private BufferedImage tickImage;
    private boolean post;
    private Slider slider;
    private Point2D.Float currentIndex;
    private Point2D.Float[] indices;
    private int indicesIndex;
    private ChangeListener listener;

    public SMWSlider(int numTicks, boolean counterOnRight) {
        this(numTicks, 0, counterOnRight);
    }

    public SMWSlider(int numTicks, int startIndex, boolean counterOnRight) {
        this.indices = new Point2D.Float[++numTicks];
        this.post = counterOnRight;
        try {
            this.barImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/slider_bar.png"));
            this.counterImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/slider_selection_box.png"));
            this.tickImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/slider_bar_tick.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float spacing = (float)this.barImage.getWidth() / (float)(numTicks - 1);
        for (int i = 0; i < numTicks; ++i) {
            this.indices[i] = new Point2D.Float((float)i * spacing, this.getY());
        }
        this.currentIndex = this.indices[startIndex];
        this.indicesIndex = startIndex;
        this.slider = new Slider(this.currentIndex);
        this.setBounds(this.getX(), this.getY(), this.barImage.getWidth() + 4 + this.counterImage.getWidth(), this.slider.sliderImage.getHeight());
        Dimension dim = new Dimension(this.barImage.getWidth() + 4 + this.counterImage.getWidth(), this.slider.sliderImage.getHeight());
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.revalidate();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private static BitmapFont getCounter() {
        try {
            return new BitmapFont(ImageIO.read(new File("res/gfx/fonts/score.png")), "0123456789");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        if (this.post) {
            g2D.drawImage((Image)this.barImage, 0, 0, null);
            for (int i = 0; i < this.indices.length - 1; ++i) {
                g2D.drawImage((Image)this.tickImage, Math.round(this.indices[i].x - (float)(this.tickImage.getWidth() / 2)), 0, null);
            }
            g2D.drawImage((Image)this.slider.sliderImage, Math.round(((Slider)this.slider).loc.x - (float)(this.slider.sliderImage.getWidth() / 2)), Math.round(((Slider)this.slider).loc.y), null);
            g2D.drawImage((Image)this.counterImage, this.barImage.getWidth() + 4, 0, null);
            counter.drawString(g2D, Integer.toString(this.indicesIndex), this.barImage.getWidth() + 4, 0.0f);
        } else {
            g2D.drawImage((Image)this.counterImage, 0, 0, null);
            g2D.drawImage((Image)this.barImage, this.counterImage.getWidth() + 4, 0, null);
            for (int i = 0; i < this.indices.length - 1; ++i) {
                g2D.drawImage((Image)this.tickImage, Math.round(this.indices[i].x - (float)(this.tickImage.getWidth() / 2)), 0, null);
            }
            g2D.drawImage((Image)this.slider.sliderImage, Math.round((float)(this.counterImage.getWidth() + 4) + ((Slider)this.slider).loc.x - (float)(this.slider.sliderImage.getWidth() / 2)), Math.round(((Slider)this.slider).loc.y), null);
            counter.drawString(g2D, Integer.toString(this.indicesIndex), 0.0f, 0.0f);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            e.consume();
            return;
        }
        if ((float)e.getX() > this.currentIndex.x && this.indicesIndex < this.indices.length - 1) {
            ++this.indicesIndex;
        } else if ((float)e.getX() < this.currentIndex.x && this.indicesIndex > 0) {
            --this.indicesIndex;
        }
        this.currentIndex = this.indices[this.indicesIndex];
        this.slider.setLocation(this.currentIndex);
        e.consume();
        if (this.listener != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.listener.stateChanged(new ChangeEvent(this));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMWSlider.this.listener.stateChanged(new ChangeEvent(this));
                    }
                });
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getButton() == 2 || e.getButton() == 3) {
            e.consume();
            return;
        }
        if ((float)e.getX() > this.currentIndex.x && this.indicesIndex < this.indices.length - 1) {
            ++this.indicesIndex;
        } else if ((float)e.getX() < this.currentIndex.x && this.indicesIndex > 0) {
            --this.indicesIndex;
        }
        this.currentIndex = this.indices[this.indicesIndex];
        this.slider.setLocation(this.currentIndex);
        e.consume();
        if (this.listener != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.listener.stateChanged(new ChangeEvent(this));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMWSlider.this.listener.stateChanged(new ChangeEvent(this));
                    }
                });
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        SMWSlider slider1 = new SMWSlider(10, 2, true);
        slider1.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        frame.getContentPane().add(slider1);
        frame.pack();
        frame.setVisible(true);
        while (frame.isVisible()) {
            frame.repaint();
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getCurrentIndex() {
        return this.indicesIndex;
    }

    private class Slider {
        private BufferedImage sliderImage;
        private Point2D.Float loc;

        private Slider(Point2D.Float loc) {
            this.loc = loc;
            try {
                this.sliderImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/slider.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void setLocation(Point2D.Float loc) {
            this.loc = loc;
        }
    }
}

