/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.gui;

import com.dmgame.Scene;
import com.dmgame.gui.SMWLabel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Timer;

public class SMWTextField
extends SMWLabel
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = -6681918506572823253L;
    private static final int BLINK_DELAY = 500;
    StringBuilder sb = new StringBuilder();
    Timer blinkTimer;
    boolean showBlink;

    public SMWTextField() {
        this("");
    }

    public SMWTextField(int width, int height) {
        this("", width, height);
    }

    public SMWTextField(String text) {
        this(text, -1, -1);
    }

    public SMWTextField(String text, int width, int height) {
        this.sb.append(text);
        this.showBlink = false;
        this.blinkTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMWTextField.this.showBlink = !SMWTextField.this.showBlink;
            }
        });
        this.blinkTimer.setRepeats(true);
        this.blinkTimer.start();
        try {
            this.setDynamicBackground(ImageIO.read(new File("res/gfx/packs/" + Scene.texturePackName + "/menu/input_9patch.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(SMWTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.redetermineSize(width, height);
        this.textDim = fontPainter.getStringDimensions(this.sb.toString());
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.bgIsDynamic && this.bgDynamicImage != null) {
            int x;
            int repeatWidth = this.bgDynamicImage[1][0].getWidth();
            int repeatHeight = this.bgDynamicImage[0][1].getHeight();
            for (x = this.bgDynamicImage[0][0].getWidth(); x < this.getWidth() - this.bgDynamicImage[2][0].getWidth(); x += repeatWidth) {
                for (int y = this.bgDynamicImage[0][0].getHeight(); y < this.getHeight() - this.bgDynamicImage[0][2].getHeight(); y += repeatHeight) {
                    g2D.drawImage((Image)this.bgDynamicImage[1][1], x, y, null);
                }
            }
            for (x = this.bgDynamicImage[0][0].getWidth(); x < this.getWidth() - this.bgDynamicImage[2][0].getWidth(); x += repeatWidth) {
                g2D.drawImage((Image)this.bgDynamicImage[1][0], x, 0, null);
                g2D.drawImage((Image)this.bgDynamicImage[1][2], x, this.getHeight() - this.bgDynamicImage[0][2].getHeight(), null);
            }
            for (int y = this.bgDynamicImage[0][0].getHeight(); y < this.getHeight() - this.bgDynamicImage[0][2].getHeight(); y += repeatHeight) {
                g2D.drawImage((Image)this.bgDynamicImage[0][1], 0, y, null);
                g2D.drawImage((Image)this.bgDynamicImage[2][1], this.getWidth() - this.bgDynamicImage[2][0].getWidth(), y, null);
            }
            g2D.drawImage((Image)this.bgDynamicImage[0][0], 0, 0, null);
            g2D.drawImage((Image)this.bgDynamicImage[2][0], this.getWidth() - this.bgDynamicImage[2][0].getWidth(), 0, null);
            g2D.drawImage((Image)this.bgDynamicImage[0][2], 0, this.getHeight() - this.bgDynamicImage[0][2].getHeight(), null);
            g2D.drawImage((Image)this.bgDynamicImage[2][2], this.getWidth() - this.bgDynamicImage[2][2].getWidth(), this.getHeight() - this.bgDynamicImage[2][2].getHeight(), null);
        } else if (this.bgStaticImage != null) {
            g2D.drawImage((Image)this.bgStaticImage, 0, 0, null);
        }
        if (this.iconImage != null) {
            int xPos = (this.getWidth() - this.textDim.width) / 2 - this.iconImage.getWidth();
            if (xPos < 0) {
                xPos = 8;
            }
            g2D.drawImage((Image)this.iconImage, xPos, (this.getHeight() - this.iconImage.getHeight()) / 2, this);
        }
        String blinkString = "";
        if (this.hasFocus() && this.showBlink) {
            blinkString = "_";
        }
        fontPainter.drawString(g2D, this.sb.toString() + blinkString, 8.0f, 0 + (this.getHeight() - this.textDim.height) / 2);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char input = e.getKeyChar();
        if (!Character.isIdentifierIgnorable(input)) {
            this.sb.append(input);
            this.textDim = fontPainter.getStringDimensions(this.sb.toString());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 8 && this.sb.length() != 0) {
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.textDim = fontPainter.getStringDimensions(this.sb.toString());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public String getText() {
        return this.sb.toString();
    }
}

