/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.io;

import com.dmgame.map.ImageTile;
import com.dmgame.map.Map;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.map.Tilesets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class LegacyFileIO {
    DataInputStream in;

    public LegacyFileIO(DataInputStream in) {
        this.in = in;
    }

    public int readInt() throws IOException {
        int value = this.in.readByte() + this.in.readByte() + this.in.readByte() + this.in.readByte();
        return value;
    }

    public int[] readVersionNum() throws IOException {
        int[] readVal = new int[4];
        for (int i = 0; i < 4; ++i) {
            readVal[i] = this.readInt();
        }
        return readVal;
    }

    public void skipBytes(int count) throws IOException {
        this.in.skipBytes(count);
    }

    public float readFloat() throws IOException {
        byte[] bytes = new byte[]{this.in.readByte(), this.in.readByte(), this.in.readByte(), this.in.readByte()};
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public String readString(int length) throws IOException {
        char[] chrs = new char[length];
        String end = "";
        try {
            for (int i = 0; i < length; ++i) {
                chrs[i] = (char)this.in.readByte();
            }
            end = new String(chrs);
            end = end.trim();
            return end;
        }
        catch (IOException e) {
            return end;
        }
    }

    public int readIntByte() throws IOException {
        return this.in.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public void readPlatforms(Map map, int[] version, HashMap<Integer, String> TilesetIDer) throws IOException {
        int numberOf = this.readInt();
        if (numberOf == 0) {
            return;
        }
        for (int i = 0; i < numberOf; ++i) {
            int pathType;
            int width = this.readInt();
            int height = this.readInt();
            Platform toEdit = new Platform(width, height);
            toEdit.setBounds(0, 0, width * 32, height * 32);
            map.platforms.add(toEdit);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (version[0] <= 1 && (version[0] != 1 || version[1] < 8)) continue;
                    int tilesetID = this.readIntByte();
                    int col = this.readIntByte();
                    int row = this.readIntByte();
                    toEdit.gTiles[x][y] = Tilesets.get(TilesetIDer.get(tilesetID)) == null ? null : new ImageTile(Tilesets.get(TilesetIDer.get(tilesetID)).getSubimage(col * 32, row * 32, 32, 32), TilesetIDer.get(tilesetID), col, row);
                    int type = this.readInt();
                    toEdit.pTiles[x][y] = new PhysicalTile(TileType.getByInt(type), (Rectangle)PhysicalTile.DEFAULT.clone());
                }
            }
            if (version[0] > 1 || version[0] == 1 && (version[1] > 8 || version[1] == 8 && version[3] >= 1)) {
                this.readInt();
            }
            if ((pathType = this.readInt()) == 0) {
                toEdit.setPath(new Line2D.Double(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat()));
                toEdit.speed = this.readFloat();
                continue;
            }
            if (pathType == 1) {
                this.readFloat();
                this.readFloat();
                this.readFloat();
                this.readFloat();
                continue;
            }
            if (pathType != 2) continue;
            float radx = this.readFloat();
            float rady = this.readFloat();
            float pathwidth = radx * 2.0f;
            float pathheight = rady * 2.0f;
            float x = this.readFloat() - radx;
            float y = this.readFloat() - rady;
            float start = this.readFloat() / 360.0f;
            toEdit.setPath(new Ellipse2D.Double(x, y, pathwidth, pathheight));
            toEdit.startTime = start;
            toEdit.speed = this.readFloat();
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

