/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.io;

import com.dmgame.Direction;
import com.dmgame.Utility;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Flamethrower;
import com.dmgame.entity.KuriboShoe;
import com.dmgame.entity.Rotodisc;
import com.dmgame.entity.Spike;
import com.dmgame.entity.Spring;
import com.dmgame.entity.ThrowBox;
import com.dmgame.io.LegacyFileIO;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.ImageTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.OrderedTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.TileType;
import com.dmgame.map.Tilesets;
import com.dmgame.map.Warp;
import com.dmgame.map.interactivetiles.BlueNoteBlock;
import com.dmgame.map.interactivetiles.BlueOnOffBlock;
import com.dmgame.map.interactivetiles.BlueOnOffSwitch;
import com.dmgame.map.interactivetiles.BlueThrowBlock;
import com.dmgame.map.interactivetiles.BombStoneBlock;
import com.dmgame.map.interactivetiles.BoomerangStoneBlock;
import com.dmgame.map.interactivetiles.BrickBlock;
import com.dmgame.map.interactivetiles.BumpBlock;
import com.dmgame.map.interactivetiles.CapeFeatherStoneBlock;
import com.dmgame.map.interactivetiles.ClearItemBlock;
import com.dmgame.map.interactivetiles.DonutBlock;
import com.dmgame.map.interactivetiles.FireFlowerStoneBlock;
import com.dmgame.map.interactivetiles.FlipBlock;
import com.dmgame.map.interactivetiles.GrayThrowBlock;
import com.dmgame.map.interactivetiles.GreenOnOffBlock;
import com.dmgame.map.interactivetiles.GreenOnOffSwitch;
import com.dmgame.map.interactivetiles.HammerStoneBlock;
import com.dmgame.map.interactivetiles.KuriboShoeStoneBlock;
import com.dmgame.map.interactivetiles.OrangeNoteBlock;
import com.dmgame.map.interactivetiles.PWingStoneBlock;
import com.dmgame.map.interactivetiles.QuestionBlock;
import com.dmgame.map.interactivetiles.RedOnOffBlock;
import com.dmgame.map.interactivetiles.RedOnOffSwitch;
import com.dmgame.map.interactivetiles.RedThrowBlock;
import com.dmgame.map.interactivetiles.ShellStoneBlock;
import com.dmgame.map.interactivetiles.StarmanStoneBlock;
import com.dmgame.map.interactivetiles.TanookiSuitStoneBlock;
import com.dmgame.map.interactivetiles.WhiteNoteBlock;
import com.dmgame.map.interactivetiles.YellowOnOffBlock;
import com.dmgame.map.interactivetiles.YellowOnOffSwitch;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class LegacyMapIO {
    static LegacyFileIO mapfile;
    static char[] chars;
    static HashMap<Integer, String> tilesetIDer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadMap(LegacyFileIO mapfile, String name) {
        Map map = new Map(20, 15);
        map.creatorName = name.contains("_") ? name.substring(0, name.indexOf("_")) : "Unknown";
        map.mapName = name.substring(0, name.indexOf("."));
        map.tilesBackground.add(new OrderedTile[map.REL_WIDTH][map.REL_HEIGHT]);
        map.tilesForeground.add(new OrderedTile[map.REL_WIDTH][map.REL_HEIGHT]);
        try {
            int i;
            int[] version = new int[4];
            version = mapfile.readVersionNum();
            if (version[0] == 1 && version[1] < 8) {
                System.out.println("Not a 1.8 map");
                Map map2 = map;
                return map2;
            }
            System.out.println("loading map: [version " + version[0] + '.' + version[1] + '.' + version[2] + '.' + version[3] + " map detected]");
            for (int i2 = 0; i2 < 13; ++i2) {
                mapfile.readInt();
            }
            int numberOfTilesets = mapfile.readInt();
            tilesetIDer = new HashMap();
            for (int i3 = 0; i3 < numberOfTilesets; ++i3) {
                int tilesetID = mapfile.readInt();
                int skip = mapfile.readInt();
                String tilesetName = mapfile.readString(skip);
                System.out.println("Tileset: " + tilesetName);
                tilesetIDer.put(tilesetID, tilesetName);
            }
            for (int therow = 0; therow < map.REL_HEIGHT; ++therow) {
                for (int column = 0; column < map.REL_WIDTH; ++column) {
                    for (int layer = 0; layer < 4; ++layer) {
                        int tilesetID = mapfile.readIntByte();
                        int col = mapfile.readIntByte();
                        int row = mapfile.readIntByte();
                        if (Tilesets.get(tilesetIDer.get(tilesetID)) == null) continue;
                        String tname = tilesetIDer.get(tilesetID);
                        if (layer < 2) {
                            map.tilesBackground.get((int)layer)[column][therow] = new OrderedTile(new ImageTile(Tilesets.get(tname).getSubimage(col * 32, row * 32, 32, 32), tname, col, row), null);
                            continue;
                        }
                        map.tilesForeground.get((int)(layer - 2))[column][therow] = new OrderedTile(new ImageTile(Tilesets.get(tname).getSubimage(col * 32, row * 32, 32, 32), tname, col, row), null);
                    }
                    int iType = mapfile.readIntByte();
                    if (iType < 0) {
                        mapfile.readBoolean();
                        continue;
                    }
                    map.iTiles[column][therow] = LegacyMapIO.getInteractive(iType, mapfile.readBoolean());
                    map.iTiles[column][therow].mapX = column * 32;
                    map.iTiles[column][therow].mapY = column * 32;
                    map.iTiles[column][therow].setMapRelCoords(column, therow);
                }
            }
            try {
                String bgString = mapfile.readString(mapfile.readInt());
                System.out.println("\nLoaded background: " + bgString + "\n");
                map.backgroundName = "Old/" + bgString;
                map.background = ImageIO.read(new File("res/gfx/backgrounds/Old/" + bgString));
            }
            catch (IOException e) {
                System.out.println("Error loading Background.");
                map.background = map.getBackground();
            }
            for (int i4 = 0; i4 < 4; ++i4) {
                mapfile.readInt();
            }
            mapfile.readPlatforms(map, version, tilesetIDer);
            int items = mapfile.readInt();
            for (int i5 = 0; i5 < items; ++i5) {
                int id = mapfile.readInt();
                int x = mapfile.readInt();
                int y = mapfile.readInt();
                map.mapEntities.add(LegacyMapIO.getEditableEntity(id, x, y));
            }
            int hazards = mapfile.readInt();
            for (int i6 = 0; i6 < hazards; ++i6) {
                int type = mapfile.readInt();
                int x = mapfile.readInt();
                int y = mapfile.readInt();
                int[] iParams = new int[5];
                for (int j = 0; j < 5; ++j) {
                    iParams[j] = mapfile.readInt();
                }
                float[] dParams = new float[5];
                for (int j = 0; j < 5; ++j) {
                    dParams[j] = mapfile.readFloat();
                }
                map.mapEntities.add(LegacyMapIO.getEditableEntity(type, x, y, iParams, dParams));
            }
            if (version[2] >= 1 || version[2] == 0 && version[3] >= 2) {
                map.setEyeCandy(mapfile.readInt(), 0);
                map.setEyeCandy(mapfile.readInt(), 1);
            }
            map.setEyeCandy(mapfile.readInt(), 2);
            map.musicCategory = LegacyMapIO.getMusicCategory(mapfile.readInt());
            for (int j = 0; j < map.REL_HEIGHT; ++j) {
                for (int i7 = 0; i7 < map.REL_WIDTH; ++i7) {
                    if (map.tilesForeground.get(1)[i7][j] == null) {
                        map.tilesForeground.get((int)1)[i7][j] = new OrderedTile();
                    }
                    map.tilesForeground.get(1)[i7][j].setPhysicalTile(new PhysicalTile(TileType.getByInt(mapfile.readInt()), (Rectangle)PhysicalTile.DEFAULT.clone()));
                    map.tilesForeground.get(1)[i7][j].getPhysicalTile().translate(i7 * 32, j * 32);
                    int dir = mapfile.readInt();
                    int connect = mapfile.readInt();
                    int id = mapfile.readInt();
                    if (dir >= 0 && connect >= 0) {
                        map.warps[id][i7][j] = new Warp(Direction.getWarpDirByInt(dir), Warp.COLOR_IDS[connect]);
                    }
                    for (int k = 0; k < 6; ++k) {
                        map.spawnLocs[i7][j] = mapfile.readBoolean();
                    }
                }
            }
            int stateNum = mapfile.readInt();
            for (i = 0; i < stateNum; ++i) {
                mapfile.readIntByte();
                mapfile.readIntByte();
                switch (mapfile.readIntByte()) {
                    default: 
                }
            }
            mapfile.skipBytes(mapfile.readInt() * 40);
            for (i = 0; i < 6; ++i) {
                int numspawnareas = mapfile.readInt();
                if (numspawnareas > 128) {
                    throw new IOException("Number of spawn areas: " + numspawnareas + "was greater than the maximum allowed: 128");
                }
                for (int j = 0; j < numspawnareas; ++j) {
                    mapfile.skipBytes(20);
                }
            }
            int rects = mapfile.readInt();
            mapfile.skipBytes(rects * 16);
            int IBExt = mapfile.readInt();
            for (int i8 = 0; i8 < IBExt; ++i8) {
                int x = mapfile.readIntByte();
                int y = mapfile.readIntByte();
                InteractiveTile block = map.iTiles[x][y];
                for (int j = 0; j < 27; ++j) {
                    if (block != null) {
                        block.setSetting(j, mapfile.readIntByte());
                        continue;
                    }
                    mapfile.readIntByte();
                }
            }
            int Rgoalnum = mapfile.readInt();
            for (int i9 = 0; i9 < Rgoalnum; ++i9) {
                mapfile.readInt();
                mapfile.readInt();
            }
            int Rflagnum = mapfile.readInt();
            for (int i10 = 0; i10 < Rflagnum; ++i10) {
                mapfile.readInt();
                mapfile.readInt();
            }
            Map map3 = map;
            return map3;
        }
        catch (Exception e) {
            System.out.println("An error occured loading the map.");
            e.printStackTrace();
            Map map4 = map;
            return map4;
        }
        finally {
            try {
                mapfile.close();
            }
            catch (Exception e) {
                System.out.println("lolwut?");
            }
        }
    }

    public static Map loadMap(String location) {
        try {
            mapfile = new LegacyFileIO(new DataInputStream(new FileInputStream(location)));
        }
        catch (Exception e) {
            System.out.println("Could not find map at location: " + location);
            return null;
        }
        return LegacyMapIO.loadMap(mapfile, location);
    }

    public static Map loadMapFromFile(File location) {
        try {
            mapfile = new LegacyFileIO(new DataInputStream(new FileInputStream(location)));
        }
        catch (Exception e) {
            System.out.println("Could not find map at location: " + location);
            return null;
        }
        return LegacyMapIO.loadMap(mapfile, location.getName());
    }

    private static InteractiveTile getInteractive(int iType, boolean readBoolean) {
        switch (iType) {
            case 0: {
                return new BrickBlock();
            }
            case 1: {
                return new QuestionBlock();
            }
            case 2: {
                return new DonutBlock();
            }
            case 3: {
                return new FlipBlock();
            }
            case 4: {
                return new BumpBlock();
            }
            case 5: {
                return new WhiteNoteBlock();
            }
            case 6: {
                return new BlueThrowBlock();
            }
            case 7: {
                return new RedOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 224, 0, 32, 32), 224, 0);
            }
            case 8: {
                return new GreenOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 256, 0, 32, 32), 256, 0);
            }
            case 9: {
                return new YellowOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 288, 0, 32, 32), 288, 0);
            }
            case 10: {
                return new BlueOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 320, 0, 32, 32), 320, 0);
            }
            case 11: {
                return new RedOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 352, 32, 32, 32), 352, 32);
            }
            case 12: {
                return new GreenOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 384, 0, 32, 32), 384, 0);
            }
            case 13: {
                return new YellowOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 416, 0, 32, 32), 416, 0);
            }
            case 14: {
                return new BlueOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 448, 0, 32, 32), 448, 0);
            }
            case 15: {
                return new ClearItemBlock();
            }
            case 16: {
                return new RedThrowBlock();
            }
            case 17: {
                return new OrangeNoteBlock();
            }
            case 18: {
                return new BlueNoteBlock();
            }
            case 19: {
                return new GrayThrowBlock();
            }
            case 20: {
                return new FireFlowerStoneBlock();
            }
            case 21: {
                return new CapeFeatherStoneBlock();
            }
            case 22: {
                return new ShellStoneBlock();
            }
            case 23: {
                return new BombStoneBlock();
            }
            case 24: {
                return new BoomerangStoneBlock();
            }
            case 25: {
                return new HammerStoneBlock();
            }
            case 26: {
                return new KuriboShoeStoneBlock();
            }
            case 27: {
                return new PWingStoneBlock();
            }
            case 28: {
                return new StarmanStoneBlock();
            }
            case 29: {
                return new TanookiSuitStoneBlock();
            }
        }
        return new ClearItemBlock();
    }

    private static EditableEntity getEditableEntity(int id, int x, int y) {
        switch (id) {
            case 0: {
                return new Spring((float)x, (float)y, LevelEditorScene.isRunning());
            }
            case 1: {
                return new Spike(x, y, LevelEditorScene.isRunning());
            }
            case 2: {
                return new KuriboShoe(x, y, LevelEditorScene.isRunning());
            }
            case 3: {
                return new Spring((float)x, (float)y, LevelEditorScene.isRunning()).setOrange();
            }
            case 4: {
                return new KuriboShoe(x, y, LevelEditorScene.isRunning()).setPurple();
            }
            case 5: {
                return new ThrowBox(x, y, LevelEditorScene.isRunning());
            }
        }
        return null;
    }

    private static EditableEntity getEditableEntity(int type, int x, int y, int[] iParams, float[] dParams) {
        switch (type) {
            case 0: {
                return new FireballBar(x, y, LevelEditorScene.isRunning(), iParams, dParams);
            }
            case 1: {
                return new Rotodisc(x, y, LevelEditorScene.isRunning(), iParams, dParams);
            }
            case 2: {
                return new Flamethrower(x, y, LevelEditorScene.isRunning(), iParams, dParams);
            }
        }
        return null;
    }

    private static String getMusicCategory(int readInt) {
        return Map.MUSIC_CATEGORIES[readInt];
    }
}

