/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.io;

import com.dmgame.SMWException;
import com.dmgame.Version;
import com.dmgame.entity.EditableEntity;
import com.dmgame.io.LegacyMapIO;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.Warp;
import java.awt.Color;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;

public class MapIO {
    private static Stack<File> tempFiles;

    public static void saveFile(Map map) throws FileNotFoundException, IOException {
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream("res/maps/" + map.mapName + ".map"));
        output.writeObject((byte)0);
        output.writeObject((byte)4);
        output.writeObject(Character.valueOf('D'));
        output.writeInt(map.REL_WIDTH);
        output.writeInt(map.REL_HEIGHT);
        output.writeObject(map.createMetadata());
        output.writeObject(map.mapName);
        output.writeObject(map.creatorName);
        output.writeObject(map.backgroundName);
        output.writeObject(map.musicCategory);
        output.writeObject(map.specificSong);
        output.writeObject(map.bgColor);
        output.writeObject(map.tilesBackground);
        output.writeObject(map.tilesForeground);
        output.writeObject(map.iTiles);
        output.writeObject(map.spawnLocs);
        output.writeObject(map.warps);
        output.writeObject(map.eyeCandyValues);
        output.writeObject(map.platforms);
        output.writeObject(map.mapEntities);
        output.close();
    }

    public static Map loadMap(File mapFile, boolean fromEditor) throws FileNotFoundException, IOException, ClassNotFoundException, SMWException {
        int height;
        int width;
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(mapFile.toString()));
        }
        catch (StreamCorruptedException e) {
            Map map = LegacyMapIO.loadMapFromFile(mapFile);
            System.out.println("loaded " + map);
            return map;
        }
        byte major = (Byte)input.readObject();
        byte minor = (Byte)input.readObject();
        char build = ((Character)input.readObject()).charValue();
        if (major > 0 && minor > 4) {
            input.close();
            throw new SMWException("Map version exceeds current build");
        }
        if (major == 0 && minor >= 4 && build == 'D') {
            width = input.readInt();
            height = input.readInt();
        } else {
            width = Map.DEF_REL_WIDTH;
            height = Map.DEF_REL_HEIGHT;
        }
        Map map = MapIO.loadMapBasics(input, fromEditor, width, height);
        input.close();
        if (Version.checkCompatibleBuild(major, minor, build)) {
            return map;
        }
        if (major == 0 && minor == 1 && build == 'D') {
            return MapIO.load01DMap(map);
        }
        if (major == 0 && minor == 2 && build == 'D') {
            return MapIO.load02DMap(map);
        }
        return new Map();
    }

    public static Map loadMapPreview(File mapFile, boolean fromEditor) throws FileNotFoundException, IOException, ClassNotFoundException, SMWException {
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(mapFile.toString()));
        byte major = (Byte)input.readObject();
        byte minor = (Byte)input.readObject();
        char build = ((Character)input.readObject()).charValue();
        if (major > 0 && minor > 4 || !Version.checkCompatibleBuild(major, minor, build)) {
            input.close();
            throw new SMWException("Map version exceeds current build");
        }
        Map map = new Map();
        input.readObject();
        map.mapName = (String)input.readObject();
        map.creatorName = (String)input.readObject();
        map.backgroundName = (String)input.readObject();
        input.readObject();
        input.readObject();
        map.bgColor = (Color)input.readObject();
        map.tilesBackground = (LinkedList)input.readObject();
        map.tilesForeground = (LinkedList)input.readObject();
        map.iTiles = (InteractiveTile[][])input.readObject();
        input.readObject();
        input.readObject();
        input.readObject();
        map.platforms = (LinkedList)input.readObject();
        map.mapEntities = (LinkedList)input.readObject();
        input.close();
        if (map.mapEntities != null) {
            for (int i = 0; i < map.mapEntities.size(); ++i) {
                map.mapEntities.get(i).setEditorMode(fromEditor);
                map.mapEntities.set(i, (EditableEntity)map.mapEntities.get(i).clone());
            }
        }
        map.background = map.getBackground();
        return map;
    }

    @Deprecated
    public static HashSet<String> loadMetadata(File mapFile) throws IOException, ClassNotFoundException, SMWException {
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(mapFile));
        }
        catch (StreamCorruptedException e) {
            return null;
        }
        byte major = (Byte)input.readObject();
        byte minor = (Byte)input.readObject();
        char build = ((Character)input.readObject()).charValue();
        if (major > 0 && minor > 4) {
            input.close();
            throw new SMWException("Map version " + major + "." + minor + build + " exceeds current build: " + Version.getBuildID());
        }
        HashSet toReturn = (HashSet)input.readObject();
        input.close();
        return toReturn;
    }

    public static void tempSave(Map map) throws FileNotFoundException, IOException {
        File tempDir = new File("res/maps/temp/");
        if (tempFiles == null) {
            if (tempDir != null && tempDir.listFiles() != null) {
                for (File f : tempDir.listFiles()) {
                    if (f == null) continue;
                    f.delete();
                }
            }
            tempFiles = new Stack();
        }
        tempDir.deleteOnExit();
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        File tempFile = File.createTempFile("map_", ".tmp", tempDir);
        tempFile.deleteOnExit();
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(tempFile));
        output.writeObject(map);
        output.close();
        tempFiles.push(tempFile);
    }

    public static Map tempLoad() throws FileNotFoundException, IOException, ClassNotFoundException, SMWException {
        if (tempFiles.size() == 0) {
            throw new SMWException("No undos left on undo stack.");
        }
        File tempFile = tempFiles.pop();
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(tempFile));
        Map map = (Map)input.readObject();
        input.close();
        if (map.mapEntities != null) {
            for (int i = 0; i < map.mapEntities.size(); ++i) {
                map.mapEntities.set(i, (EditableEntity)map.mapEntities.get(i).clone());
            }
        }
        map.background = map.getBackground();
        tempFile.delete();
        return map;
    }

    private static Map loadMapBasics(ObjectInputStream input, boolean fromEditor, int width, int height) throws IOException, ClassNotFoundException {
        Map map = new Map(width, height);
        map.metadata = (HashSet)input.readObject();
        map.mapName = (String)input.readObject();
        map.creatorName = (String)input.readObject();
        map.backgroundName = (String)input.readObject();
        map.musicCategory = (String)input.readObject();
        map.specificSong = (String)input.readObject();
        map.bgColor = (Color)input.readObject();
        map.tilesBackground = (LinkedList)input.readObject();
        map.tilesForeground = (LinkedList)input.readObject();
        map.iTiles = (InteractiveTile[][])input.readObject();
        map.spawnLocs = (boolean[][])input.readObject();
        map.warps = (Warp[][][])input.readObject();
        map.eyeCandyValues = (HashMap)input.readObject();
        try {
            map.platforms = (LinkedList)input.readObject();
            map.mapEntities = (LinkedList)input.readObject();
        }
        catch (EOFException e) {
            map.background = map.getBackground();
            return map;
        }
        if (map.mapEntities != null) {
            for (int i = 0; i < map.mapEntities.size(); ++i) {
                map.mapEntities.get(i).setEditorMode(fromEditor);
                map.mapEntities.set(i, (EditableEntity)map.mapEntities.get(i).clone());
            }
        }
        map.background = map.getBackground();
        return map;
    }

    private static Map load01DMap(Map map) throws IOException, ClassNotFoundException, SMWException {
        System.out.println("Loaded 0.1D map.");
        if (map.platforms != null) {
            for (int i = 0; i < map.platforms.size(); ++i) {
                map.platforms.get((int)i).speed *= 100.0;
            }
        }
        map = MapIO.load02DMap(map);
        return map;
    }

    private static Map load02DMap(Map map) throws IOException, ClassNotFoundException, SMWException {
        System.out.println("Loaded 0.2D map.");
        return map;
    }
}

