/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.io;

import com.dmgame.SMWException;
import com.dmgame.map.PhysicalTile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TilesetIO {
    public static String HEADER = "TILESET";

    public static void savePhysicalTiles(PhysicalTile[][] pTiles, String tileSet) throws FileNotFoundException, IOException {
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(tileSet));
        output.writeObject(HEADER);
        output.writeObject(pTiles);
        output.close();
    }

    public static PhysicalTile[][] loadPhysicalTiles(File tileData) throws FileNotFoundException, IOException, ClassNotFoundException, SMWException {
        PhysicalTile[][] pTiles = null;
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(tileData.toString()));
        Object o = input.readObject();
        if (o instanceof String) {
            String s = (String)o;
            if (!s.contains(HEADER)) {
                input.close();
                throw new SMWException("Could not load tile collision data.");
            }
            pTiles = (PhysicalTile[][])input.readObject();
        }
        input.close();
        return pTiles;
    }
}

