/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.io.AnimatedTilesetDirectoryFilter;
import com.dmgame.io.TilesetIO;
import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.TileType;
import com.dmgame.map.Tilesets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AnimatedTileViewer
extends EditorComponent
implements ActionListener {
    private static final long serialVersionUID = -3217774754891321521L;
    private BufferedImage tileTypeIcons;
    private PhysicalTile[][] pTiles;
    private PhysicalTile[][] currentpTiles;
    private AnimatedTile[][] selectedTiles;
    private AnimatedTile[][] availableTiles;
    private Rectangle selected = new Rectangle(0, 0, 32, 32);
    private String tileSetName;
    private boolean showMasks = false;
    private boolean multiSelect = false;
    private int topSelX;
    private int topSelY;
    private int bottomSelX;
    private int bottomSelY;
    private JMenuBar menuBar;
    private JMenu tileSetsMenu;
    private JMenuItem openItem;
    private JMenuItem saveItem;
    private JMenuItem changeToImage;
    private JMenuItem showMaskEditor;
    private JCheckBoxMenuItem maskItem;
    private ButtonGroup buttonGroup;
    private final String LOAD_COMMAND = "load";
    private final String SAVE_COMMAND = "save";
    private final String IMAGE_COMMAND = "image";
    private final String SHOW_MASKS_COMMAND = "show masks";
    private final String SHOW_MASK_EDITOR_COMMAND = "show mask editor";

    public AnimatedTileViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tileSetName = "anim/ClassicAnimated";
        try {
            this.tileTypeIcons = ImageIO.read(new File("res/gfx/leveleditor/tiletypeicons.png"));
            this.loadNewTileset(this.tileSetName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.selectedTiles = new AnimatedTile[1][1];
        this.currentpTiles = new PhysicalTile[1][1];
        this.selectedTiles[0][0] = this.availableTiles[0][0];
        this.currentpTiles[0][0] = this.pTiles[0][0];
        this.setPreferredSize(new Dimension(this.availableTiles.length * 32, this.availableTiles[0].length * 32));
        this.setupMenu();
    }

    public String getCurrentTilesetName() {
        return this.tileSetName;
    }

    public AnimatedTile[][] getUnclonedSelectedTiles() {
        return this.selectedTiles;
    }

    public PhysicalTile[][] getSelectedPhysicalTiles() {
        return this.currentpTiles;
    }

    private void setupMenu() {
        String[] list;
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        this.openItem = new JMenuItem("Open Tileset");
        this.openItem.setActionCommand("load");
        this.openItem.addActionListener(this);
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menu.add(this.openItem);
        this.saveItem = new JMenuItem("Save Tileset Data");
        this.saveItem.setActionCommand("save");
        this.saveItem.addActionListener(this);
        menu.add(this.saveItem);
        this.changeToImage = new JMenuItem("Switch to Image Tilesets...");
        this.changeToImage.setActionCommand("image");
        this.changeToImage.addActionListener(this);
        this.changeToImage.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        menu.add(this.changeToImage);
        this.menuBar.add(menu);
        this.tileSetsMenu = new JMenu("Animated Tilesets");
        this.maskItem = new JCheckBoxMenuItem("Show Masks");
        this.maskItem.setActionCommand("show masks");
        this.maskItem.addActionListener(this);
        this.maskItem.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        this.tileSetsMenu.add(this.maskItem);
        this.showMaskEditor = new JMenuItem("Show Mask Editor...");
        this.showMaskEditor.setActionCommand("show mask editor");
        this.showMaskEditor.addActionListener(this);
        this.showMaskEditor.setAccelerator(KeyStroke.getKeyStroke(69, 0));
        this.tileSetsMenu.add(this.showMaskEditor);
        this.tileSetsMenu.add(new JSeparator());
        this.buttonGroup = new ButtonGroup();
        File file = new File("res/gfx/tilesets/anim");
        for (String s : list = file.list(new AnimatedTilesetDirectoryFilter())) {
            if (s.equals(".svn")) continue;
            JRadioButtonMenuItem tilesetButton = new JRadioButtonMenuItem(s);
            if (s.equals(this.tileSetName)) {
                tilesetButton.setSelected(true);
            }
            tilesetButton.setActionCommand(s);
            this.buttonGroup.add(tilesetButton);
            tilesetButton.addActionListener(this);
            this.tileSetsMenu.add(tilesetButton);
        }
        this.menuBar.add(this.tileSetsMenu);
        this.menuBar.validate();
    }

    public void saveTileSetData() {
        try {
            File f = new File("res/gfx/tilesets/" + this.tileSetName + "/tileset.tls");
            if (!f.exists()) {
                f.createNewFile();
            }
            TilesetIO.savePhysicalTiles(this.pTiles, "res/gfx/tilesets/" + this.tileSetName + "/tileset.tls");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadNewTileset(String tileSetName) {
        try {
            this.tileSetName = tileSetName;
            AnimatedTile[][] tiles = Tilesets.getAnimated(tileSetName);
            if (tiles == null) {
                System.err.println("Could not load new tileset.");
                return;
            }
            this.availableTiles = tiles;
            File file = new File("res/gfx/tilesets/" + tileSetName + "/tileset.tls");
            if (!file.exists()) {
                this.pTiles = new PhysicalTile[this.availableTiles.length][this.availableTiles[0].length];
                for (int i = 0; i < this.pTiles.length; ++i) {
                    for (int j = 0; j < this.pTiles[i].length; ++j) {
                        this.pTiles[i][j] = new PhysicalTile(TileType.NONE, PhysicalTile.DEFAULT);
                    }
                }
                this.saveTileSetData();
            }
            this.pTiles = TilesetIO.loadPhysicalTiles(file);
            Dimension d = new Dimension(this.availableTiles.length * 32, this.availableTiles[0].length * 32);
            this.setPreferredSize(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        for (int i = 0; i < this.pTiles.length; ++i) {
            for (int j = 0; j < this.pTiles[i].length; ++j) {
                PhysicalTile pTile = this.pTiles[i][j];
                if (this.availableTiles[i][j] != null) {
                    g2D.drawImage((Image)this.availableTiles[i][j].tile.getImage(), i * 32, j * 32, null);
                }
                switch (pTile.type) {
                    case SOLID: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(0, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case FALLTHROUGH: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(8, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case SLIPPERY: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(16, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILL: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(24, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLTOP: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(32, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLBOTTOM: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(40, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLLEFT: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(48, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLRIGHT: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(56, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case FALLTHROUGH_SLIPPERY: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(64, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLBOTTOM_SLIPPERY: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(72, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLLEFT_SLIPPERY: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(80, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                    case KILLRIGHT_SLIPPERY: {
                        g2D.drawImage((Image)this.tileTypeIcons.getSubimage(88, 0, 8, 8), i * 32, j * 32, null);
                        break;
                    }
                }
                if (!this.showMasks) continue;
                g2D.setColor(new Color(255, 0, 0, 130));
                pTile.translate(i * 32, j * 32);
                g2D.fill(pTile.mask);
                pTile.translate(i * -32, j * -32);
            }
        }
        g2D.setColor(new Color(255, 0, 0, 130));
        g2D.fill(this.selected);
        if (this.mouseInWindow) {
            g2D.setColor(Color.GREEN);
            g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        for (int i = 0; i < this.availableTiles.length; ++i) {
            for (int j = 0; j < this.availableTiles[i].length; ++j) {
                if (this.availableTiles[i][j] == null) continue;
                this.availableTiles[i][j].tile.update(timePassed);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("save")) {
            this.saveTileSetData();
        } else if (s.equals("show masks")) {
            this.showMasks = !this.showMasks;
            this.repaint();
        } else {
            this.saveTileSetData();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)e.getSource();
            item.setSelected(true);
            this.loadNewTileset("anim/" + s);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LevelEditorScene.setImageTileMode(false);
                    LevelEditorScene.updateToolset();
                }
            });
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseButton = e.getButton();
        if (e.getX() > this.availableTiles.length * 32 || e.getY() > this.availableTiles[0].length * 32) {
            e.consume();
            return;
        }
        if (mouseButton == 1) {
            this.selectedTiles = new AnimatedTile[1][1];
            this.currentpTiles = new PhysicalTile[1][1];
            this.selectedTiles[0][0] = this.availableTiles[this.mouseRelX][this.mouseRelY];
            this.currentpTiles[0][0] = this.pTiles[this.mouseRelX][this.mouseRelY];
            LevelEditorScene.maskEditor.changeTile(this.currentpTiles[0][0], this.selectedTiles[0][0]);
            this.selected = new Rectangle(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
        }
        if (mouseButton == 3) {
            if (e.isControlDown()) {
                this.pTiles[this.mouseRelX][this.mouseRelY] = new PhysicalTile(TileType.NONE, PhysicalTile.DEFAULT);
            } else {
                PhysicalTile tile = this.pTiles[this.mouseRelX][this.mouseRelY];
                tile.type = TileType.getNext(tile.type);
            }
        }
        LevelEditorScene.maskEditor.changeTile(this.currentpTiles[0][0], this.selectedTiles[0][0]);
        this.repaint();
        this.multiSelect = false;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getX() > this.availableTiles.length * 32 || e.getY() > this.availableTiles[0].length * 32) {
            e.consume();
            return;
        }
        if (this.multiSelect) {
            this.selectedTiles = new AnimatedTile[this.bottomSelX - this.topSelX + 1][this.bottomSelY - this.topSelY + 1];
            this.currentpTiles = new PhysicalTile[this.bottomSelX - this.topSelX + 1][this.bottomSelY - this.topSelY + 1];
            this.selected = new Rectangle(this.topSelX * 32, this.topSelY * 32, (this.bottomSelX - this.topSelX) * 32 + 32, (this.bottomSelY - this.topSelY) * 32 + 32);
            for (int x = 0; x < this.bottomSelX - this.topSelX + 1; ++x) {
                for (int y = 0; y < this.bottomSelY - this.topSelY + 1; ++y) {
                    this.selectedTiles[x][y] = this.availableTiles[x + this.topSelX][y + this.topSelY];
                    this.currentpTiles[x][y] = this.pTiles[x + this.topSelX][y + this.topSelY];
                }
            }
            this.repaint();
        }
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.topSelX = this.mouseRelX > e.getX() / 32 ? e.getX() / 32 : this.mouseRelX;
        this.bottomSelX = this.mouseRelX < e.getX() / 32 ? e.getX() / 32 : this.mouseRelX;
        this.topSelY = this.mouseRelY > e.getY() / 32 ? e.getY() / 32 : this.mouseRelY;
        this.bottomSelY = this.mouseRelY < e.getY() / 32 ? e.getY() / 32 : this.mouseRelY;
        this.multiSelect = true;
        this.selected = new Rectangle(this.topSelX * 32, this.topSelY * 32, (this.bottomSelX - this.topSelX) * 32 + 32, (this.bottomSelY - this.topSelY) * 32 + 32);
        e.consume();
        this.repaint();
    }

    @Override
    public void run() {
        try {
            long startTime;
            long totalTime = startTime = System.currentTimeMillis();
            while (LevelEditorScene.isRunning()) {
                if (!(LevelEditorScene.layerManager.getCurrentBackgroundLayer() < 0 && LevelEditorScene.layerManager.getCurrentForegroundLayer() < 0 || LevelEditorScene.inImageTileMode())) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    this.update(timePassed);
                }
                Thread.sleep(16L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

