/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.Updatable;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public abstract class EditorComponent
extends JPanel
implements MouseListener,
MouseMotionListener,
Runnable,
Updatable {
    private static final long serialVersionUID = 7342459571483045672L;
    protected int mouseX;
    protected int mouseY;
    protected int mouseRelX;
    protected int mouseRelY;
    protected boolean mouseInWindow;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        e.consume();
        this.mouseRelX = (int)Math.floor(this.mouseX / 32);
        this.mouseRelY = (int)Math.floor(this.mouseY / 32);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseInWindow = true;
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInWindow = false;
        e.consume();
    }

    @Override
    public void update(long timePassed) {
        this.repaint();
    }
}

