/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.Animation;
import com.dmgame.Utility;
import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.interactivetiles.BlueNoteBlock;
import com.dmgame.map.interactivetiles.BlueOnOffBlock;
import com.dmgame.map.interactivetiles.BlueOnOffSwitch;
import com.dmgame.map.interactivetiles.BlueThrowBlock;
import com.dmgame.map.interactivetiles.BombStoneBlock;
import com.dmgame.map.interactivetiles.BoomerangStoneBlock;
import com.dmgame.map.interactivetiles.BrickBlock;
import com.dmgame.map.interactivetiles.BumpBlock;
import com.dmgame.map.interactivetiles.CapeFeatherStoneBlock;
import com.dmgame.map.interactivetiles.ClearItemBlock;
import com.dmgame.map.interactivetiles.DonutBlock;
import com.dmgame.map.interactivetiles.FireFlowerStoneBlock;
import com.dmgame.map.interactivetiles.FlipBlock;
import com.dmgame.map.interactivetiles.GrayThrowBlock;
import com.dmgame.map.interactivetiles.GreenOnOffBlock;
import com.dmgame.map.interactivetiles.GreenOnOffSwitch;
import com.dmgame.map.interactivetiles.HammerStoneBlock;
import com.dmgame.map.interactivetiles.KuriboShoeStoneBlock;
import com.dmgame.map.interactivetiles.OrangeNoteBlock;
import com.dmgame.map.interactivetiles.PWingStoneBlock;
import com.dmgame.map.interactivetiles.QuestionBlock;
import com.dmgame.map.interactivetiles.RedOnOffBlock;
import com.dmgame.map.interactivetiles.RedOnOffSwitch;
import com.dmgame.map.interactivetiles.RedThrowBlock;
import com.dmgame.map.interactivetiles.ShellStoneBlock;
import com.dmgame.map.interactivetiles.StarmanStoneBlock;
import com.dmgame.map.interactivetiles.TanookiSuitStoneBlock;
import com.dmgame.map.interactivetiles.WhiteNoteBlock;
import com.dmgame.map.interactivetiles.YellowOnOffBlock;
import com.dmgame.map.interactivetiles.YellowOnOffSwitch;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class InteractiveTileViewer
extends EditorComponent {
    private static final long serialVersionUID = 4220515467123701929L;
    public static final InteractiveTile BRICK_BLOCK = new BrickBlock();
    public static final InteractiveTile QUESTION_BLOCK = new QuestionBlock();
    public static final InteractiveTile DONUT_BLOCK = new DonutBlock();
    public static final InteractiveTile FLIP_BLOCK = new FlipBlock();
    public static final InteractiveTile BUMP_BLOCK = new BumpBlock();
    public static final InteractiveTile WHITE_NOTE_BLOCK = new WhiteNoteBlock();
    public static final InteractiveTile BLUE_THROW_BLOCK = new BlueThrowBlock();
    public static final InteractiveTile CLEAR_ITEM_BLOCK = new ClearItemBlock();
    public static final InteractiveTile RED_THROW_BLOCK = new RedThrowBlock();
    public static final InteractiveTile ORANGE_NOTE_BLOCK = new OrangeNoteBlock();
    public static final InteractiveTile BLUE_NOTE_BLOCK = new BlueNoteBlock();
    public static final InteractiveTile GRAY_THROW_BLOCK = new GrayThrowBlock();
    public static final InteractiveTile FIRE_FLOWER_STONE_BLOCK = new FireFlowerStoneBlock();
    public static final InteractiveTile CAPE_FEATHER_STONE_BLOCK = new CapeFeatherStoneBlock();
    public static final InteractiveTile SHELL_STONE_BLOCK = new ShellStoneBlock();
    public static final InteractiveTile BOMB_STONE_BLOCK = new BombStoneBlock();
    public static final InteractiveTile BOOMERANG_STONE_BLOCK = new BoomerangStoneBlock();
    public static final InteractiveTile HAMMER_STONE_BLOCK = new HammerStoneBlock();
    public static final InteractiveTile KURIBO_SHOE_STONE_BLOCK = new KuriboShoeStoneBlock();
    public static final InteractiveTile P_WING_STONE_BLOCK = new PWingStoneBlock();
    public static final InteractiveTile STAR_STONE_BLOCK = new StarmanStoneBlock();
    public static final InteractiveTile TANOOKI_SUIT_STONE_BLOCK = new TanookiSuitStoneBlock();
    public static final InteractiveTile RED_ON_SWITCH = new RedOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 224, 0, 32, 32), 224, 0);
    public static final InteractiveTile RED_OFF_SWITCH = new RedOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 224, 32, 32, 32), 224, 32);
    public static final InteractiveTile GREEN_ON_SWITCH = new GreenOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 256, 0, 32, 32), 256, 0);
    public static final InteractiveTile GREEN_OFF_SWITCH = new GreenOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 256, 32, 32, 32), 256, 32);
    public static final InteractiveTile YELLOW_ON_SWITCH = new YellowOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 288, 0, 32, 32), 288, 0);
    public static final InteractiveTile YELLOW_OFF_SWITCH = new YellowOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 288, 32, 32, 32), 288, 32);
    public static final InteractiveTile BLUE_ON_SWITCH = new BlueOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 320, 0, 32, 32), 320, 0);
    public static final InteractiveTile BLUE_OFF_SWITCH = new BlueOnOffSwitch(Utility.getSubanimation(InteractiveTile.tileset, 320, 32, 32, 32), 320, 32);
    public static final InteractiveTile RED_ON_BLOCK = new RedOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 352, 0, 32, 32), 352, 0);
    public static final InteractiveTile RED_OFF_BLOCK = new RedOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 352, 32, 32, 32), 352, 32);
    public static final InteractiveTile GREEN_ON_BLOCK = new GreenOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 384, 0, 32, 32), 384, 0);
    public static final InteractiveTile GREEN_OFF_BLOCK = new GreenOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 384, 32, 32, 32), 384, 32);
    public static final InteractiveTile YELLOW_ON_BLOCK = new YellowOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 416, 0, 32, 32), 416, 0);
    public static final InteractiveTile YELLOW_OFF_BLOCK = new YellowOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 416, 32, 32, 32), 416, 32);
    public static final InteractiveTile BLUE_ON_BLOCK = new BlueOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 448, 0, 32, 32), 448, 0);
    public static final InteractiveTile BLUE_OFF_BLOCK = new BlueOnOffBlock(Utility.getSubanimation(InteractiveTile.tileset, 448, 32, 32, 32), 448, 32);
    private final InteractiveTile[][] TILES_ARRAY = new InteractiveTile[][]{{BRICK_BLOCK, CLEAR_ITEM_BLOCK, FIRE_FLOWER_STONE_BLOCK}, {QUESTION_BLOCK, RED_THROW_BLOCK, CAPE_FEATHER_STONE_BLOCK}, {DONUT_BLOCK, ORANGE_NOTE_BLOCK, SHELL_STONE_BLOCK}, {FLIP_BLOCK, BLUE_NOTE_BLOCK, BOMB_STONE_BLOCK}, {BUMP_BLOCK, GRAY_THROW_BLOCK, BOOMERANG_STONE_BLOCK}, {WHITE_NOTE_BLOCK, null, HAMMER_STONE_BLOCK}, {BLUE_THROW_BLOCK, null, KURIBO_SHOE_STONE_BLOCK}, {RED_ON_SWITCH, RED_OFF_SWITCH, P_WING_STONE_BLOCK}, {GREEN_ON_SWITCH, GREEN_OFF_SWITCH, STAR_STONE_BLOCK}, {YELLOW_ON_SWITCH, YELLOW_OFF_SWITCH, TANOOKI_SUIT_STONE_BLOCK}, {BLUE_ON_SWITCH, BLUE_OFF_SWITCH, null}, {RED_ON_BLOCK, RED_OFF_BLOCK, null}, {GREEN_ON_BLOCK, GREEN_OFF_BLOCK, null}, {YELLOW_ON_BLOCK, YELLOW_OFF_BLOCK, null}, {BLUE_ON_BLOCK, BLUE_OFF_BLOCK, null}};
    private Animation tileset;
    private InteractiveTile selectedTile;
    private Rectangle selected = new Rectangle(0, 0, 32, 32);

    public InteractiveTileViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        try {
            BufferedImage[] tilesheets = new BufferedImage[4];
            for (int i = 0; i < tilesheets.length; ++i) {
                File ref = new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png");
                tilesheets[i] = ImageIO.read(ref);
            }
            this.setPreferredSize(new Dimension(tilesheets[0].getWidth(), tilesheets[0].getHeight()));
            this.tileset = new Animation(500L, tilesheets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InteractiveTile getUnclonedSelectedTile() {
        return this.selectedTile;
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        InteractiveTile[][] arr$ = this.TILES_ARRAY;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            InteractiveTile[] array;
            for (InteractiveTile i : array = arr$[i$]) {
                if (i == null) continue;
                i.update(timePassed);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        if (this.mouseInWindow) {
            g2D.setColor(Color.GREEN);
            g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
        }
        for (int i = 0; i < this.TILES_ARRAY.length; ++i) {
            for (int j = 0; j < this.TILES_ARRAY[i].length; ++j) {
                if (this.TILES_ARRAY[i][j] == null) continue;
                g2D.drawImage((Image)this.TILES_ARRAY[i][j].tile.getImage(), i * 32, j * 32, null);
            }
        }
        g2D.setColor(new Color(255, 0, 0, 130));
        g2D.fill(this.selected);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseButton = e.getButton();
        if (e.getX() > this.tileset.getWidth() || e.getY() > this.tileset.getHeight()) {
            e.consume();
            return;
        }
        if (mouseButton == 1) {
            this.selectedTile = this.TILES_ARRAY[this.mouseRelX][this.mouseRelY];
            this.selected = new Rectangle(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
    }

    @Override
    public void run() {
        try {
            long startTime;
            long totalTime = startTime = System.currentTimeMillis();
            while (LevelEditorScene.isRunning()) {
                if (LevelEditorScene.layerManager.getCurrentBackgroundLayer() == -1) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    this.update(timePassed);
                }
                Thread.sleep(16L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

