/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.gui.SMWButton;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.OrderedTile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayerManager
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 4375093145619474233L;
    private final Dimension BUTTON_DIMENSIONS = new Dimension(192, 48);
    public LinkedList<SMWButton> tileBackgroundButtons;
    public LinkedList<SMWButton> tileForegroundButtons;
    private SMWButton iTileButton;
    private SMWButton tileTypeButton;
    private SMWButton spawnButton;
    private SMWButton warpButton;
    private byte currentLayer;
    private byte layerCount;
    public static final byte I_TILE = -1;
    public static final byte TILE_TYPE = -2;
    public static final byte SPAWN_ZONE = -3;
    public static final byte WARP = -4;
    private final Color SELECTED_COLOR = new Color(163, 184, 204);
    private byte currentForegroundLayer;
    private byte previousTileLayer;
    private byte foregroundLayerCount;
    private boolean onBackgroundLayers;

    public LayerManager() {
        SMWButton toAdd;
        int i;
        this.setLayout(new GridLayout(0, 1));
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.onBackgroundLayers = true;
        this.currentLayer = 0;
        this.layerCount = 0;
        this.currentForegroundLayer = 0;
        this.foregroundLayerCount = 0;
        this.warpButton = new SMWButton("Warp Layer");
        this.warpButton.addActionListener(this);
        this.warpButton.setActionCommand(Byte.toString((byte)-4));
        this.warpButton.setPreferredSize(this.BUTTON_DIMENSIONS);
        this.add(this.warpButton);
        this.spawnButton = new SMWButton("Spawn Zone Layer");
        this.spawnButton.addActionListener(this);
        this.spawnButton.setActionCommand(Byte.toString((byte)-3));
        this.spawnButton.setPreferredSize(this.BUTTON_DIMENSIONS);
        this.add(this.spawnButton);
        this.tileTypeButton = new SMWButton("Tile Type Layer");
        this.tileTypeButton.addActionListener(this);
        this.tileTypeButton.setActionCommand(Byte.toString((byte)-2));
        this.tileTypeButton.setPreferredSize(this.BUTTON_DIMENSIONS);
        this.add(this.tileTypeButton);
        this.iTileButton = new SMWButton("Interactive Layer");
        this.iTileButton.addActionListener(this);
        this.iTileButton.setActionCommand(Byte.toString((byte)-1));
        this.iTileButton.setPreferredSize(this.BUTTON_DIMENSIONS);
        this.add(this.iTileButton);
        this.tileBackgroundButtons = new LinkedList();
        for (i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
            toAdd = new SMWButton("Tile Layer " + this.layerCount);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Byte.toString((byte)this.tileBackgroundButtons.size()));
            toAdd.setPreferredSize(this.BUTTON_DIMENSIONS);
            this.add(toAdd);
            this.tileBackgroundButtons.add(toAdd);
            this.layerCount = (byte)(this.layerCount + 1);
        }
        this.tileBackgroundButtons.get(0).setSelected(true);
        this.tileForegroundButtons = new LinkedList();
        toAdd = null;
        for (i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
            toAdd = new SMWButton("Tile Layer " + this.foregroundLayerCount);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Byte.toString((byte)this.tileForegroundButtons.size()));
            toAdd.setPreferredSize(this.BUTTON_DIMENSIONS);
            this.tileForegroundButtons.add(toAdd);
            this.foregroundLayerCount = (byte)(this.foregroundLayerCount + 1);
        }
        this.tileForegroundButtons.get(0).setBackground(this.SELECTED_COLOR);
        this.validate();
    }

    public byte getCurrentBackgroundLayer() {
        return this.currentLayer;
    }

    public void setCurrentBackgroundLayer(byte layer) {
        this.currentLayer = layer;
    }

    public byte getCurrentForegroundLayer() {
        return this.currentForegroundLayer;
    }

    public void setCurrentForegroundLayer(byte layer) {
        this.currentForegroundLayer = layer;
    }

    public void reloadTileLayerButtons() {
        SMWButton toAdd;
        this.currentLayer = 0;
        this.layerCount = 0;
        for (SMWButton b : this.tileBackgroundButtons) {
            this.remove(b);
        }
        this.tileBackgroundButtons = new LinkedList();
        for (int i = LevelEditorScene.map.tilesBackground.size() - 1; i >= 0; --i) {
            toAdd = new SMWButton("Tile Layer " + i);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Integer.toString(i));
            toAdd.setPreferredSize(this.BUTTON_DIMENSIONS);
            this.add(toAdd);
            this.tileBackgroundButtons.add(toAdd);
            this.layerCount = (byte)(this.layerCount + 1);
        }
        this.currentForegroundLayer = 0;
        this.foregroundLayerCount = 0;
        for (SMWButton b : this.tileForegroundButtons) {
            this.remove(b);
        }
        this.tileForegroundButtons = new LinkedList();
        for (int i = LevelEditorScene.map.tilesForeground.size() - 1; i >= 0; --i) {
            toAdd = new SMWButton("Tile Layer " + i);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Integer.toString(i));
            toAdd.setPreferredSize(this.BUTTON_DIMENSIONS);
            this.tileForegroundButtons.add(toAdd);
            this.foregroundLayerCount = (byte)(this.foregroundLayerCount + 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                for (i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
                    LevelEditorScene.updateLayerManagerThumbnail(i);
                }
                for (i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
                    LevelEditorScene.updateLayerManagerThumbnail(i);
                }
            }
        });
        this.setButtonSelected(this.tileBackgroundButtons.get(0));
        this.currentLayer = (byte)(LevelEditorScene.map.tilesBackground.size() - 1);
        this.currentForegroundLayer = (byte)(LevelEditorScene.map.tilesForeground.size() - 1);
        this.validate();
    }

    public synchronized void addLayer() {
        if (this.onBackgroundLayers) {
            if (this.tileBackgroundButtons.size() > 9) {
                return;
            }
            SMWButton toAdd = new SMWButton("Tile Layer " + this.layerCount);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Byte.toString((byte)this.tileBackgroundButtons.size()));
            this.add(toAdd);
            this.tileBackgroundButtons.addLast(toAdd);
            LevelEditorScene.map.tilesBackground.add(new OrderedTile[LevelEditorScene.map.REL_WIDTH][LevelEditorScene.map.REL_HEIGHT]);
            this.currentLayer = (byte)(this.tileBackgroundButtons.size() - 1);
            this.layerCount = (byte)(this.layerCount + 1);
            for (int b = 0; b < this.tileBackgroundButtons.size(); b = (int)((byte)(b + 1))) {
                this.tileBackgroundButtons.get(b).setActionCommand(Integer.toString(this.tileBackgroundButtons.size() - 1 - b));
                this.tileBackgroundButtons.get(b).setPreferredSize(this.BUTTON_DIMENSIONS);
                this.tileBackgroundButtons.get(b).setText("Tile Layer " + (this.tileBackgroundButtons.size() - 1 - b));
            }
            this.setButtonSelected(this.tileBackgroundButtons.get(0));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        } else {
            if (this.tileForegroundButtons.size() > 9) {
                return;
            }
            SMWButton toAdd = new SMWButton("Tile Layer " + this.foregroundLayerCount);
            toAdd.addActionListener(this);
            toAdd.setActionCommand(Byte.toString((byte)this.tileForegroundButtons.size()));
            this.add(toAdd);
            this.tileForegroundButtons.addLast(toAdd);
            LevelEditorScene.map.tilesForeground.add(new OrderedTile[LevelEditorScene.map.REL_WIDTH][LevelEditorScene.map.REL_HEIGHT]);
            this.currentForegroundLayer = (byte)(this.tileForegroundButtons.size() - 1);
            this.foregroundLayerCount = (byte)(this.foregroundLayerCount + 1);
            for (int b = 0; b < this.tileForegroundButtons.size(); b = (int)((byte)(b + 1))) {
                this.tileForegroundButtons.get(b).setActionCommand(Integer.toString(this.tileForegroundButtons.size() - 1 - b));
                this.tileForegroundButtons.get(b).setPreferredSize(this.BUTTON_DIMENSIONS);
                this.tileForegroundButtons.get(b).setText("Tile Layer " + (this.tileForegroundButtons.size() - 1 - b));
            }
            this.setButtonSelected(this.tileForegroundButtons.get(0));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        }
        LevelEditorScene.recalculateMapImages();
        this.validate();
    }

    public synchronized void deleteLayer() {
        if (this.onBackgroundLayers) {
            if (this.currentLayer < 0 || this.tileBackgroundButtons.size() <= 1) {
                return;
            }
            this.remove(this.tileBackgroundButtons.remove(this.currentLayer));
            LevelEditorScene.map.tilesBackground.remove(this.currentLayer);
            if (this.currentLayer > 0) {
                this.currentLayer = (byte)(this.currentLayer - 1);
            }
            for (int b = 0; b < this.tileBackgroundButtons.size(); b = (int)((byte)(b + 1))) {
                this.tileBackgroundButtons.get(b).setActionCommand(Integer.toString(this.tileBackgroundButtons.size() - 1 - b));
                this.tileBackgroundButtons.get(b).setPreferredSize(this.BUTTON_DIMENSIONS);
                this.tileBackgroundButtons.get(b).setText("Tile Layer " + (this.tileBackgroundButtons.size() - 1 - b));
            }
            this.setButtonSelected(this.tileBackgroundButtons.get(this.currentLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        } else {
            if (this.currentForegroundLayer < 0 || this.tileForegroundButtons.size() <= 1) {
                return;
            }
            this.remove(this.tileForegroundButtons.remove(this.currentLayer));
            LevelEditorScene.map.tilesForeground.remove(this.currentLayer);
            if (this.currentForegroundLayer > 0) {
                this.currentForegroundLayer = (byte)(this.currentForegroundLayer - 1);
            }
            for (int b = 0; b < this.tileForegroundButtons.size(); b = (int)((byte)(b + 1))) {
                this.tileForegroundButtons.get(b).setActionCommand(Integer.toString(this.tileForegroundButtons.size() - 1 - b));
                this.tileForegroundButtons.get(b).setPreferredSize(this.BUTTON_DIMENSIONS);
                this.tileForegroundButtons.get(b).setText("Tile Layer " + (this.tileForegroundButtons.size() - 1 - b));
            }
            this.setButtonSelected(this.tileForegroundButtons.get(this.currentLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        }
        this.validate();
    }

    public synchronized void moveLayerUp() {
        if (this.onBackgroundLayers) {
            if (this.currentLayer == LevelEditorScene.map.tilesBackground.size() - 1) {
                return;
            }
            OrderedTile[][] toMove = LevelEditorScene.map.tilesBackground.get(this.currentLayer);
            LevelEditorScene.map.tilesBackground.add(this.currentLayer + 2, toMove);
            LevelEditorScene.map.tilesBackground.remove(this.currentLayer);
            this.currentLayer = (byte)(this.currentLayer + 1);
            this.setButtonSelected(this.tileBackgroundButtons.get(this.tileBackgroundButtons.size() - 1 - this.currentLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        } else {
            if (this.currentForegroundLayer == LevelEditorScene.map.tilesForeground.size() - 1) {
                return;
            }
            OrderedTile[][] toMove = LevelEditorScene.map.tilesForeground.get(this.currentForegroundLayer);
            LevelEditorScene.map.tilesForeground.add(this.currentForegroundLayer + 2, toMove);
            LevelEditorScene.map.tilesForeground.remove(this.currentForegroundLayer);
            this.currentForegroundLayer = (byte)(this.currentForegroundLayer + 1);
            this.setButtonSelected(this.tileForegroundButtons.get(this.tileForegroundButtons.size() - 1 - this.currentForegroundLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        }
        this.validate();
    }

    public synchronized void moveLayerDown() {
        if (this.onBackgroundLayers) {
            if (this.currentLayer == 0) {
                return;
            }
            OrderedTile[][] toMove = LevelEditorScene.map.tilesBackground.get(this.currentLayer);
            LevelEditorScene.map.tilesBackground.add(this.currentLayer - 1, toMove);
            LevelEditorScene.map.tilesBackground.remove(this.currentLayer + 1);
            this.currentLayer = (byte)(this.currentLayer - 1);
            this.setButtonSelected(this.tileBackgroundButtons.get(this.tileBackgroundButtons.size() - 1 - this.currentLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        } else {
            if (this.currentForegroundLayer == 0) {
                return;
            }
            OrderedTile[][] toMove = LevelEditorScene.map.tilesForeground.get(this.currentForegroundLayer);
            LevelEditorScene.map.tilesForeground.add(this.currentForegroundLayer - 1, toMove);
            LevelEditorScene.map.tilesForeground.remove(this.currentForegroundLayer + 1);
            this.currentForegroundLayer = (byte)(this.currentForegroundLayer - 1);
            this.setButtonSelected(this.tileForegroundButtons.get(this.tileForegroundButtons.size() - 1 - this.currentLayer));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
                        LevelEditorScene.updateLayerManagerThumbnail(i);
                    }
                }
            });
        }
        this.validate();
    }

    private void setButtonSelected(SMWButton button) {
        if (this.onBackgroundLayers) {
            for (SMWButton b : this.tileBackgroundButtons) {
                b.setSelected(false);
            }
            this.iTileButton.setSelected(false);
            this.tileTypeButton.setSelected(false);
            this.spawnButton.setSelected(false);
            this.warpButton.setSelected(false);
        } else {
            this.tileTypeButton.setSelected(false);
            for (SMWButton b : this.tileForegroundButtons) {
                b.setSelected(false);
            }
        }
        button.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.onBackgroundLayers) {
            byte b = Byte.parseByte(e.getActionCommand());
            if (b == -2) {
                this.previousTileLayer = this.currentLayer;
                if (this.previousTileLayer < 0) {
                    this.previousTileLayer = 0;
                }
            }
            this.currentLayer = b;
            this.setButtonSelected((SMWButton)e.getSource());
            this.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LayerManager.this.currentLayer != -3) {
                        LevelEditorScene.updateToolset();
                    }
                }
            });
        } else {
            byte b = Byte.parseByte(e.getActionCommand());
            if (b == -2) {
                this.previousTileLayer = this.currentForegroundLayer;
                if (this.previousTileLayer < 0) {
                    this.previousTileLayer = 0;
                }
            }
            this.currentLayer = this.currentForegroundLayer = b;
            this.setButtonSelected((SMWButton)e.getSource());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LevelEditorScene.updateToolset();
                }
            });
            this.requestFocus();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 127: {
                this.deleteLayer();
                break;
            }
            case 155: {
                this.addLayer();
                break;
            }
            case 33: {
                this.moveLayerUp();
                break;
            }
            case 34: {
                this.moveLayerDown();
                break;
            }
            case 36: {
                this.switchToForeground();
                break;
            }
            case 35: {
                this.switchToBackground();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void switchToForeground() {
        if (!this.onBackgroundLayers) {
            return;
        }
        for (SMWButton button : this.tileBackgroundButtons) {
            this.remove(button);
        }
        this.remove(this.iTileButton);
        this.remove(this.tileTypeButton);
        this.remove(this.spawnButton);
        this.remove(this.warpButton);
        for (SMWButton button : this.tileForegroundButtons) {
            this.add(button);
        }
        this.onBackgroundLayers = false;
        this.repaint();
        this.validate();
        this.currentLayer = 0;
    }

    public void switchToBackground() {
        if (this.onBackgroundLayers) {
            return;
        }
        for (SMWButton button : this.tileForegroundButtons) {
            this.remove(button);
        }
        this.add(this.warpButton);
        this.add(this.spawnButton);
        this.add(this.tileTypeButton);
        this.add(this.iTileButton);
        for (SMWButton button : this.tileBackgroundButtons) {
            this.add(button);
        }
        this.onBackgroundLayers = true;
        this.repaint();
        this.validate();
        this.currentForegroundLayer = 0;
    }

    public boolean isOnBackgroundLayers() {
        return this.onBackgroundLayers;
    }

    @Override
    public String toString() {
        if (this.onBackgroundLayers) {
            return "Current Background Layer: " + Byte.toString(this.currentLayer);
        }
        return "Current Foreground Layer: " + Byte.toString(this.currentForegroundLayer);
    }
}

