/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.BitmapFont;
import com.dmgame.DevConsole;
import com.dmgame.MapScene;
import com.dmgame.PathFollower;
import com.dmgame.Scene;
import com.dmgame.Utility;
import com.dmgame.Version;
import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Rotodisc;
import com.dmgame.gui.SMWButton;
import com.dmgame.io.AnimatedTilesetDirectoryFilter;
import com.dmgame.io.ImageTilesetDirectoryFilter;
import com.dmgame.io.MapIO;
import com.dmgame.leveleditor.AnimatedTileViewer;
import com.dmgame.leveleditor.ImageTileViewer;
import com.dmgame.leveleditor.InteractiveTileViewer;
import com.dmgame.leveleditor.LayerManager;
import com.dmgame.leveleditor.MapEntityEditor;
import com.dmgame.leveleditor.MapOptionDialog;
import com.dmgame.leveleditor.MapViewAccessory;
import com.dmgame.leveleditor.MaskEditor;
import com.dmgame.leveleditor.PlatformEditor;
import com.dmgame.leveleditor.TileFXDialog;
import com.dmgame.leveleditor.TileTypeViewer;
import com.dmgame.leveleditor.WarpViewer;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.ImageTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.OrderedTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.map.Warp;
import com.dmgame.map.interactivetiles.AbstractOnOffBlock;
import com.dmgame.map.interactivetiles.AbstractOnOffSwitch;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.StateEdit;
import javax.swing.undo.UndoManager;

public class LevelEditorScene
extends Scene
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = -6744131343091770540L;
    public static final String LOGGER_NAME = "LE Logger";
    private static boolean isRunning = false;
    private int mouseX;
    private int mouseY;
    private int mouseRelX;
    private int mouseRelY;
    private int topSelX;
    private int topSelY;
    private int bottomSelX;
    private int bottomSelY;
    private int brushSize;
    private int eraserBrushSize;
    private int platformFreeformIndex;
    private UndoManager undoManager;
    private StateEdit edit;
    private float scale;
    private static boolean imageTileMode;
    private boolean dragging;
    private boolean rightClick;
    private boolean mouseInFrame;
    private boolean selectionMode;
    private boolean selectionMade;
    private boolean pasted;
    private boolean debug;
    private boolean selectiveLayerViewMode;
    public static Map map;
    public static List<String> userTags;
    private OrderedTile[][] tilesSelected;
    private PhysicalTile[][] pTilesSelected;
    private InteractiveTile[][] iTilesSelected;
    public static JTabbedPane tabs;
    public static JFrame extraComponentFrame;
    private static JScrollPane pane;
    private JPanel centeringPanel;
    private JFrame mainFrame;
    private JMenuBar menuBar;
    private JLabel statusLabel = new JLabel("Running");
    private JPopupMenu popupMenu;
    public static PlatformListener platformListener;
    public static MapEntityListener mapEntityListener;
    private OptionListener optionListener;
    private TileFXListener tileFXListener;
    public static LayerManager layerManager;
    public static ImageTileViewer tileViewer;
    public static AnimatedTileViewer animatedTileViewer;
    public static InteractiveTileViewer interactiveTileViewer;
    public static TileTypeViewer tileTypeViewer;
    public static WarpViewer warpViewer;
    public static MaskEditor maskEditor;
    public static MapEntityEditor mapEntityEditor;
    private volatile Thread animatedTileViewerThread;
    private volatile Thread interactiveTileViewerThread;
    private volatile Thread maskEditorThread;
    private volatile Thread mapUpdateThread;
    public static BufferedImage pathNodeImage;
    public static BufferedImage redNodeImage;
    public static BufferedImage greenNodeImage;
    public static BufferedImage blueNodeImage;
    public static BufferedImage brightNodeImage;
    private BufferedImage noSpawnZone;
    private BufferedImage windowIcon;
    private static List<BufferedImage> bgTileImages;
    private static List<BufferedImage> fgTileImages;
    private static BufferedImage warpsImage;
    private static BufferedImage pTilesImage;
    private static List<List<Point>> bgAnimTiles;
    private static List<List<Point>> fgAnimTiles;
    private DevConsole d;
    private BitmapFont font;
    private final SMWButton normalModeButton;
    private final SMWButton selectModeButton;
    private final SMWButton pathModeButton;
    private final SMWButton entityModeButton;

    public LevelEditorScene() {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(10);
        try {
            pathNodeImage = ImageIO.read(new File("res/gfx/leveleditor/pathpoint.png"));
            redNodeImage = ImageIO.read(new File("res/gfx/leveleditor/redpathpoint.png"));
            greenNodeImage = ImageIO.read(new File("res/gfx/leveleditor/greenpathpoint.png"));
            blueNodeImage = ImageIO.read(new File("res/gfx/leveleditor/bluepathpoint.png"));
            brightNodeImage = ImageIO.read(new File("res/gfx/leveleditor/brightpathpoint.png"));
            this.noSpawnZone = ImageIO.read(new File("res/gfx/leveleditor/nospawnzone.png"));
            this.windowIcon = ImageIO.read(new File("lib/res/leveleditor.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(LOGGER_NAME).log(Level.WARNING, "Error loading editor images", ex);
            this.statusLabel.setText("Missing images in res/gfx/leveleditor. Check error log for details.");
            ex.printStackTrace();
        }
        bgAnimTiles = new ArrayList<List<Point>>();
        bgAnimTiles.add(new ArrayList());
        fgAnimTiles = new ArrayList<List<Point>>();
        fgAnimTiles.add(new ArrayList());
        this.dragging = false;
        this.rightClick = false;
        this.debug = false;
        imageTileMode = true;
        this.eraserBrushSize = 1;
        this.brushSize = 1;
        map = new Map();
        LevelEditorScene.map.background = map.getBackground();
        userTags = new ArrayList<String>();
        LevelEditorScene.recalculateMapImages();
        tileViewer = new ImageTileViewer();
        animatedTileViewer = new AnimatedTileViewer();
        interactiveTileViewer = new InteractiveTileViewer();
        tileTypeViewer = new TileTypeViewer();
        warpViewer = new WarpViewer();
        maskEditor = new MaskEditor();
        maskEditor.setMaximumSize(maskEditor.getPreferredSize());
        maskEditor.setMinimumSize(maskEditor.getPreferredSize());
        mapEntityEditor = new MapEntityEditor();
        layerManager = new LayerManager();
        this.mainFrame = new JFrame("Level Editor - " + map.toString());
        this.mainFrame.setIconImage(this.windowIcon);
        tabs = new JTabbedPane();
        this.reCalculateSize(0.5f);
        pane = new JScrollPane();
        pane.setPreferredSize(new Dimension(LevelEditorScene.map.MAP_WIDTH / 2, 192));
        pane.setMinimumSize(pane.getPreferredSize());
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        pane.getVerticalScrollBar().setUnitIncrement(32);
        pane.getHorizontalScrollBar().setUnitIncrement(32);
        BufferedImage button = null;
        BufferedImage hover = null;
        BufferedImage press = null;
        try {
            button = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/pipe_button_9patch.png"));
            hover = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/pipe_hover_9patch.png"));
            press = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/pipe_press_9patch.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JPanel modePanel = new JPanel(new GridLayout(4, 0));
        this.normalModeButton = new SMWButton(button, hover, press, "Tile Mode", -1, -1);
        this.normalModeButton.setFocusable(false);
        this.normalModeButton.setActionCommand("normal");
        ModeListener ml = new ModeListener();
        this.normalModeButton.addActionListener(ml);
        modePanel.add(this.normalModeButton);
        this.selectModeButton = new SMWButton(button, hover, press, "Selection Mode", -1, -1);
        this.selectModeButton.setFocusable(false);
        this.selectModeButton.setActionCommand("select");
        this.selectModeButton.addActionListener(ml);
        modePanel.add(this.selectModeButton);
        this.pathModeButton = new SMWButton(button, hover, press, "Platform Mode", -1, -1);
        this.pathModeButton.setFocusable(false);
        this.pathModeButton.setActionCommand("platform");
        this.pathModeButton.addActionListener(ml);
        modePanel.add(this.pathModeButton);
        this.entityModeButton = new SMWButton(button, hover, press, "Entity Mode", -1, -1);
        this.entityModeButton.setFocusable(false);
        this.entityModeButton.setActionCommand("entity");
        this.entityModeButton.addActionListener(ml);
        modePanel.add(this.entityModeButton);
        this.normalModeButton.setSelected(true);
        this.centeringPanel = new JPanel(new GridBagLayout());
        this.centeringPanel.setPreferredSize(this.getPreferredSize());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        this.centeringPanel.add((Component)this, c);
        pane.addComponentListener(new ResizeListener(this));
        JScrollPane LEPane = new JScrollPane();
        LEPane.getVerticalScrollBar().setUnitIncrement(32);
        LEPane.getHorizontalScrollBar().setUnitIncrement(32);
        LEPane.setViewportView(this.centeringPanel);
        tabs.addTab("Map", LEPane);
        JSplitPane controlPane = new JSplitPane(0, modePanel, layerManager);
        controlPane.setDividerSize(4);
        JSplitPane leftPane = new JSplitPane(0, controlPane, maskEditor);
        leftPane.setDividerLocation((int)((float)LevelEditorScene.map.MAP_HEIGHT * this.scale));
        JSplitPane RightPane = new JSplitPane(0, tabs, pane);
        RightPane.setResizeWeight(1.0);
        JSplitPane mainSplitPane = new JSplitPane(1, leftPane, RightPane);
        leftPane.setDividerSize(4);
        RightPane.setDividerSize(4);
        mainSplitPane.setDividerSize(4);
        mainSplitPane.setDividerLocation(LevelEditorScene.layerManager.getMinimumSize().width + 6);
        this.setupMenu();
        LevelEditorScene.updateToolset();
        JSplitPane topPanel = new JSplitPane(0, mainSplitPane, this.statusLabel);
        this.statusLabel.setMinimumSize(this.statusLabel.getPreferredSize());
        mainSplitPane.setMinimumSize(mainSplitPane.getPreferredSize());
        topPanel.setResizeWeight(1.0);
        topPanel.setDividerSize(4);
        this.mainFrame.getContentPane().add(topPanel);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.setupTertiaryWindow();
        tabs.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void init() {
        try {
            this.animatedTileViewerThread = new Thread(animatedTileViewer);
            this.interactiveTileViewerThread = new Thread(interactiveTileViewer);
            this.maskEditorThread = new Thread(maskEditor);
            this.mapUpdateThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long startTime;
                        long totalTime = startTime = System.currentTimeMillis();
                        while (LevelEditorScene.isRunning()) {
                            long timePassed = System.currentTimeMillis() - totalTime;
                            totalTime += timePassed;
                            this.update(timePassed);
                            Thread.sleep(16L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                private void update(long timePassed) {
                    OrderedTile[] arrayTwo;
                    int i$;
                    int len$;
                    OrderedTile[][] arr$;
                    OrderedTile[][] arrayOne;
                    Iterator i$2 = LevelEditorScene.map.tilesForeground.iterator();
                    while (i$2.hasNext()) {
                        arr$ = arrayOne = (OrderedTile[][])i$2.next();
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            for (OrderedTile tile : arrayTwo = arr$[i$]) {
                                if (tile == null) continue;
                                tile.update(timePassed);
                            }
                        }
                    }
                    i$2 = LevelEditorScene.map.tilesBackground.iterator();
                    while (i$2.hasNext()) {
                        arr$ = arrayOne = (OrderedTile[][])i$2.next();
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            for (OrderedTile tile : arrayTwo = arr$[i$]) {
                                if (tile == null) continue;
                                tile.update(timePassed);
                            }
                        }
                    }
                    InteractiveTile[][] arr$2 = LevelEditorScene.map.iTiles;
                    int len$2 = arr$2.length;
                    for (int i$3 = 0; i$3 < len$2; ++i$3) {
                        InteractiveTile[] array;
                        for (InteractiveTile i : array = arr$2[i$3]) {
                            if (i == null) continue;
                            i.update(timePassed);
                        }
                    }
                }
            });
            if (!DATA.exists()) {
                Utility.saveDefaultConfig();
            }
            if (Version.isInReleaseMode()) {
                this.d = new DevConsole();
                this.d.setIconImage(this.windowIcon);
                this.d.start();
            }
            this.font = new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
            this.running = true;
            isRunning = true;
            this.animatedTileViewerThread.start();
            this.interactiveTileViewerThread.start();
            this.maskEditorThread.start();
            this.mapUpdateThread.start();
        }
        catch (Exception e) {
            Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "Error initializing LevelEditorScene", e);
            this.statusLabel.setText("Unknown error. Check log for details.");
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        super.stop();
        LevelEditorScene.stopIsRunning();
    }

    private static void stopIsRunning() {
        isRunning = false;
    }

    private void showOpenMapDialog() {
        File f = null;
        try {
            JFileChooser chooser = new JFileChooser("res/maps/");
            chooser.setAccessory(new MapViewAccessory(chooser, false, map));
            if (chooser.showOpenDialog(this) == 0) {
                f = chooser.getSelectedFile();
                Map map = MapIO.loadMap(f, false);
                while (tabs.getTabCount() > 1) {
                    tabs.removeTabAt(1);
                }
                platformListener.counter = -1;
                LevelEditorScene.map = map;
                tabs.validate();
                layerManager.reloadTileLayerButtons();
                platformListener.resetPlatformMenu();
                mapEntityListener.resetEntityMenu();
                for (int i = 0; i < map.platforms.size(); ++i) {
                    map.platforms.get(i).setPathIterator();
                    platformListener.addPlatformMenuItem();
                }
                for (int i = 0; i < map.mapEntities.size(); ++i) {
                    EditableEntity e = map.mapEntities.get(i);
                    e.setSwingComponents();
                    e.setEditorMode(true);
                    map.mapEntities.set(i, (EditableEntity)map.mapEntities.get(i).clone());
                    mapEntityListener.addEntityMenuItem();
                }
                this.statusLabel.setText("Loaded " + map.mapName + ".map.");
                HashSet<String> strings = map.metadata;
                if (strings != null) {
                    userTags = new ArrayList<String>(strings);
                }
                MapOptionDialog.updateToCurrentMap();
                this.mainFrame.setTitle("Level Editor - " + map.toString());
                LevelEditorScene.recalculateMapImages();
                this.scale = 0.5f;
                this.setPreferredSize(new Dimension(map.MAP_WIDTH / 2, map.MAP_HEIGHT / 2));
                this.setSize(this.getPreferredSize());
                this.centeringPanel.setPreferredSize(this.getPreferredSize());
                this.validate();
                this.centeringPanel.validate();
                this.mainFrame.validate();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LOGGER_NAME).log(Level.WARNING, "Error loading map " + f, ex);
            this.statusLabel.setText("Error loading map " + f + ". Please check error file for details.");
            ex.printStackTrace();
        }
    }

    private void showSaveMapAsDialog() {
        File f = null;
        try {
            JFileChooser chooser = new JFileChooser("res/maps/");
            MapViewAccessory mva = new MapViewAccessory(chooser, true, map);
            chooser.setAccessory(mva);
            if (chooser.showDialog(this, "Save As...") == 0) {
                f = chooser.getSelectedFile();
                String name = f.getName();
                if (name.contains(".")) {
                    name = name.substring(0, name.indexOf("."));
                }
                LevelEditorScene.map.mapName = name;
                String credit = mva.getAuthor();
                if (credit == null || credit.equals("")) {
                    credit = "Anonymous";
                }
                LevelEditorScene.map.creatorName = credit;
                if (LevelEditorScene.map.mapName != null && !LevelEditorScene.map.mapName.equals("")) {
                    MapIO.saveFile(map);
                    this.statusLabel.setText("Saved map as " + LevelEditorScene.map.mapName + ".map.");
                    this.mainFrame.setTitle("Level Editor - " + map.toString());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LOGGER_NAME).log(Level.WARNING, "Error saving map " + f, ex);
            this.statusLabel.setText("Error saving map " + f + ". Please check error file for details.");
            ex.printStackTrace();
        }
    }

    private void showNewMapDialog() {
        NewMapDialog d = new NewMapDialog(this);
        d.setVisible(true);
    }

    private void setupMenu() {
        JRadioButtonMenuItem tilesetButton;
        String[] list;
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Open Map");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.showOpenMapDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menu.add(item);
        item = new JMenuItem("New Map");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int save = JOptionPane.showConfirmDialog(null, "Save map first?");
                if (save == 0) {
                    LevelEditorScene.this.showSaveMapAsDialog();
                } else if (save == 2) {
                    return;
                }
                LevelEditorScene.this.showNewMapDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        menu.add(item);
        item = new JMenuItem("Save Map");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LevelEditorScene.map.mapName == null || LevelEditorScene.map.mapName.equals("")) {
                    LevelEditorScene.this.showSaveMapAsDialog();
                } else {
                    try {
                        if (LevelEditorScene.map.mapName != null && !LevelEditorScene.map.mapName.equals("")) {
                            MapIO.saveFile(map);
                            LevelEditorScene.this.statusLabel.setText("Saved map as " + LevelEditorScene.map.mapName + ".map.");
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LevelEditorScene.LOGGER_NAME).log(Level.WARNING, "Error saving map", ex);
                        LevelEditorScene.this.statusLabel.setText("Error saving map. Check log for details");
                        ex.printStackTrace();
                    }
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        menu.add(item);
        item = new JMenuItem("Save Map As...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.showSaveMapAsDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 64));
        menu.add(item);
        this.menuBar.add(menu);
        this.optionListener = new OptionListener();
        menu = new JMenu("Edit");
        this.popupMenu = new JPopupMenu();
        item = new JMenuItem("Cut");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LevelEditorScene.this.checkSelectionNull()) {
                    LevelEditorScene.this.cutSelection();
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        menu.add(item);
        JMenuItem popupItem = new JMenuItem("Cut");
        popupItem.addActionListener(item.getActionListeners()[0]);
        this.popupMenu.add(popupItem);
        item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LevelEditorScene.this.checkSelectionNull()) {
                    LevelEditorScene.this.copySelection();
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        menu.add(item);
        popupItem = new JMenuItem("Copy");
        popupItem.addActionListener(item.getActionListeners()[0]);
        this.popupMenu.add(popupItem);
        item = new JMenuItem("Paste");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LevelEditorScene.this.selectionMode && !LevelEditorScene.this.checkSelectionMismatch()) {
                    LevelEditorScene.this.pasteSelection();
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        menu.add(item);
        popupItem = new JMenuItem("Paste");
        popupItem.addActionListener(item.getActionListeners()[0]);
        this.popupMenu.add(popupItem);
        item = new JMenuItem("Undo");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LevelEditorScene.this.undoManager.canUndo()) {
                    LevelEditorScene.this.undoManager.undo();
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem("Add TileFX to Selection");
        this.tileFXListener = new TileFXListener();
        item.addActionListener(this.tileFXListener);
        item.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        menu.add(item);
        popupItem = new JMenuItem("Add TileFX");
        popupItem.addActionListener(item.getActionListeners()[0]);
        this.popupMenu.add(popupItem);
        item = new JMenuItem("Take Screenshot");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.takeScreenshot();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        menu.add(item);
        menu.add(new JSeparator());
        final JCheckBoxMenuItem hideLayersButton = new JCheckBoxMenuItem("Hide Inactive Tile Layers");
        hideLayersButton.setSelected(false);
        hideLayersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.selectiveLayerViewMode = !LevelEditorScene.this.selectiveLayerViewMode;
                hideLayersButton.setSelected(LevelEditorScene.this.selectiveLayerViewMode);
            }
        });
        hideLayersButton.setAccelerator(KeyStroke.getKeyStroke(85, 0));
        menu.add(hideLayersButton);
        item = new JMenu("Tile Type/Spawn Zone Brush Size");
        ButtonGroup brushGroup = new ButtonGroup();
        JRadioButtonMenuItem brush1x = new JRadioButtonMenuItem("1x");
        brush1x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.brushSize = 1;
            }
        });
        brush1x.setSelected(true);
        JRadioButtonMenuItem brush2x = new JRadioButtonMenuItem("2x");
        brush2x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.brushSize = 2;
            }
        });
        JRadioButtonMenuItem brush3x = new JRadioButtonMenuItem("3x");
        brush3x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.brushSize = 3;
            }
        });
        JRadioButtonMenuItem brush4x = new JRadioButtonMenuItem("4x");
        brush4x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.brushSize = 4;
            }
        });
        brushGroup.add(brush1x);
        brushGroup.add(brush2x);
        brushGroup.add(brush3x);
        brushGroup.add(brush4x);
        item.add(brush1x);
        item.add(brush2x);
        item.add(brush3x);
        item.add(brush4x);
        menu.add(item);
        item = new JMenu("Eraser Brush Size");
        ButtonGroup eraserBrushGroup = new ButtonGroup();
        JRadioButtonMenuItem eraserBrush1x = new JRadioButtonMenuItem("1x");
        eraserBrush1x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.eraserBrushSize = 1;
            }
        });
        eraserBrush1x.setSelected(true);
        JRadioButtonMenuItem eraserBrush2x = new JRadioButtonMenuItem("2x");
        eraserBrush2x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.eraserBrushSize = 2;
            }
        });
        JRadioButtonMenuItem eraserBrush3x = new JRadioButtonMenuItem("3x");
        eraserBrush3x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.eraserBrushSize = 3;
            }
        });
        JRadioButtonMenuItem eraserBrush4x = new JRadioButtonMenuItem("4x");
        eraserBrush4x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelEditorScene.this.eraserBrushSize = 4;
            }
        });
        eraserBrushGroup.add(eraserBrush1x);
        eraserBrushGroup.add(eraserBrush2x);
        eraserBrushGroup.add(eraserBrush3x);
        eraserBrushGroup.add(eraserBrush4x);
        item.add(eraserBrush1x);
        item.add(eraserBrush2x);
        item.add(eraserBrush3x);
        item.add(eraserBrush4x);
        menu.add(item);
        this.menuBar.add(menu);
        menu = new JMenu("Map Options");
        item = new JMenuItem("Background...");
        item.setActionCommand("background");
        item.addActionListener(this.optionListener);
        item.setAccelerator(KeyStroke.getKeyStroke(66, 0));
        menu.add(item);
        item = new JMenuItem("Background Color...");
        item.setActionCommand("backgroundcolor");
        item.addActionListener(this.optionListener);
        item.setAccelerator(KeyStroke.getKeyStroke(71, 0));
        menu.add(item);
        item = new JMenuItem("Music...");
        item.setActionCommand("backgroundmusic");
        item.addActionListener(this.optionListener);
        item.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        menu.add(item);
        item = new JMenuItem("Eye Candy...");
        item.setActionCommand("eyecandy");
        item.addActionListener(this.optionListener);
        item.setAccelerator(KeyStroke.getKeyStroke(89, 0));
        menu.add(item);
        item = new JMenuItem("Tags...");
        item.setActionCommand("tags");
        item.addActionListener(this.optionListener);
        item.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        menu.add(item);
        this.menuBar.add(menu);
        JMenu tileSetsMenu = new JMenu("Tilesets");
        JCheckBoxMenuItem maskItem = new JCheckBoxMenuItem("Show Masks");
        maskItem.setActionCommand("show masks");
        maskItem.addActionListener(tileViewer);
        maskItem.addActionListener(animatedTileViewer);
        maskItem.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        tileSetsMenu.add(maskItem);
        tileSetsMenu.add(new JSeparator());
        ButtonGroup buttonGroup = new ButtonGroup();
        File file = new File("res/gfx/tilesets/");
        for (String s : list = file.list(new ImageTilesetDirectoryFilter())) {
            if (".svn".equals(s) || "anim".equals(s) || "interactive".equals(s)) continue;
            tilesetButton = new JRadioButtonMenuItem(s);
            if (s.equals(tileViewer.getCurrentTilesetName())) {
                tilesetButton.setSelected(true);
            }
            tilesetButton.setActionCommand(s);
            buttonGroup.add(tilesetButton);
            tilesetButton.addActionListener(tileViewer);
            tileSetsMenu.add(tilesetButton);
        }
        tileSetsMenu.add(new JSeparator());
        file = new File("res/gfx/tilesets/anim");
        for (String s : list = file.list(new AnimatedTilesetDirectoryFilter())) {
            if (s.equals(".svn")) continue;
            tilesetButton = new JRadioButtonMenuItem(s);
            if (s.equals(animatedTileViewer.getCurrentTilesetName())) {
                tilesetButton.setSelected(true);
            }
            tilesetButton.setActionCommand(s);
            buttonGroup.add(tilesetButton);
            tilesetButton.addActionListener(animatedTileViewer);
            tileSetsMenu.add(tilesetButton);
        }
        this.menuBar.add(tileSetsMenu);
        platformListener = new PlatformListener();
        platformListener.platformMenu = new JMenu("Platforms");
        platformListener.platformGroup = new ButtonGroup();
        item = new JMenuItem("Create New Platform...");
        item.setActionCommand("addplatform");
        item.addActionListener(platformListener);
        item.setAccelerator(KeyStroke.getKeyStroke(80, 0));
        platformListener.platformMenu.add(item);
        item = new JMenuItem("Delete Platform...");
        item.setActionCommand("deleteplatform");
        item.addActionListener(platformListener);
        item.setAccelerator(KeyStroke.getKeyStroke(59, 0));
        platformListener.platformMenu.add(item);
        platformListener.platformMenu.add(new JSeparator());
        this.menuBar.add(platformListener.platformMenu);
        mapEntityListener = new MapEntityListener();
        mapEntityListener.mapEntityMenu = new JMenu("Map Entities");
        mapEntityListener.mapEntityGroup = new ButtonGroup();
        item = new JMenuItem("Add New Map Entity...");
        item.setActionCommand("addentity");
        item.addActionListener(mapEntityListener);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 0));
        mapEntityListener.mapEntityMenu.add(item);
        item = new JMenuItem("Delete Map Entity...");
        item.setActionCommand("deleteentity");
        item.addActionListener(mapEntityListener);
        item.setAccelerator(KeyStroke.getKeyStroke(68, 0));
        mapEntityListener.mapEntityMenu.add(item);
        mapEntityListener.mapEntityMenu.add(new JSeparator());
        this.menuBar.add(mapEntityListener.mapEntityMenu);
        this.menuBar.validate();
        this.mainFrame.setJMenuBar(this.menuBar);
    }

    private void setupTertiaryWindow() {
        extraComponentFrame = new JFrame();
        extraComponentFrame.setIconImage(this.windowIcon);
    }

    private void reCalculateSize(float scale) {
        this.scale = scale;
        this.setPreferredSize(new Dimension((int)((float)LevelEditorScene.map.MAP_WIDTH * scale), (int)((float)LevelEditorScene.map.MAP_HEIGHT * scale)));
        this.setSize(new Dimension((int)((float)LevelEditorScene.map.MAP_WIDTH * scale), (int)((float)LevelEditorScene.map.MAP_HEIGHT * scale)));
    }

    @Override
    public void update(long timePassed) {
        for (EditableEntity e : LevelEditorScene.map.mapEntities) {
            e.update(timePassed);
        }
    }

    public static void recalculateMapImages() {
        int y;
        int x;
        int l;
        int y2;
        int x2;
        int l2;
        int i;
        bgTileImages = new ArrayList<BufferedImage>();
        bgAnimTiles = new ArrayList<List<Point>>();
        fgTileImages = new ArrayList<BufferedImage>();
        fgAnimTiles = new ArrayList<List<Point>>();
        warpsImage = new BufferedImage(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT, 2);
        pTilesImage = new BufferedImage(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT, 2);
        for (i = 0; i < LevelEditorScene.map.tilesBackground.size(); ++i) {
            bgTileImages.add(new BufferedImage(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT, 2));
            bgAnimTiles.add(new ArrayList());
        }
        for (i = 0; i < LevelEditorScene.map.tilesForeground.size(); ++i) {
            fgTileImages.add(new BufferedImage(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT, 2));
            fgAnimTiles.add(new ArrayList());
        }
        for (l2 = 0; l2 < LevelEditorScene.map.tilesBackground.size(); ++l2) {
            Graphics2D g2D = bgTileImages.get(l2).createGraphics();
            for (x2 = 0; x2 < LevelEditorScene.map.tilesBackground.get(l2).length; ++x2) {
                for (y2 = 0; y2 < LevelEditorScene.map.tilesBackground.get(l2)[x2].length; ++y2) {
                    if (LevelEditorScene.map.tilesBackground.get(l2)[x2][y2] == null) continue;
                    if (LevelEditorScene.map.tilesBackground.get(l2)[x2][y2].getUnclonedGraphicTile() instanceof ImageTile) {
                        g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l2)[x2][y2].getUnclonedGraphicTile().getImage(), x2 * 32, y2 * 32, null);
                        continue;
                    }
                    if (LevelEditorScene.map.tilesBackground.get(l2)[x2][y2].getUnclonedGraphicTile() == null) continue;
                    bgAnimTiles.get(l2).add(new Point(x2, y2));
                }
            }
            g2D.dispose();
        }
        for (l2 = 0; l2 < LevelEditorScene.map.tilesForeground.size(); ++l2) {
            Graphics2D g2D = fgTileImages.get(l2).createGraphics();
            for (x2 = 0; x2 < LevelEditorScene.map.tilesForeground.get(l2).length; ++x2) {
                for (y2 = 0; y2 < LevelEditorScene.map.tilesForeground.get(l2)[x2].length; ++y2) {
                    if (LevelEditorScene.map.tilesForeground.get(l2)[x2][y2] == null) continue;
                    if (LevelEditorScene.map.tilesForeground.get(l2)[x2][y2].getUnclonedGraphicTile() instanceof ImageTile) {
                        g2D.drawImage((Image)LevelEditorScene.map.tilesForeground.get(l2)[x2][y2].getUnclonedGraphicTile().getImage(), x2 * 32, y2 * 32, null);
                        continue;
                    }
                    if (LevelEditorScene.map.tilesForeground.get(l2)[x2][y2].getUnclonedGraphicTile() == null) continue;
                    fgAnimTiles.get(l2).add(new Point(x2, y2));
                }
            }
            g2D.dispose();
        }
        Graphics2D g2D = warpsImage.createGraphics();
        for (int id = 0; id < LevelEditorScene.map.warps.length; ++id) {
            for (int i2 = 0; i2 < LevelEditorScene.map.warps[id].length; ++i2) {
                for (int j = 0; j < LevelEditorScene.map.warps[id][i2].length; ++j) {
                    if (LevelEditorScene.map.warps[id][i2][j] == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.warps[id][i2][j].sprite, i2 * 32, j * 32, null);
                }
            }
        }
        g2D = pTilesImage.createGraphics();
        boolean[][] drewSpots = new boolean[LevelEditorScene.map.REL_WIDTH][LevelEditorScene.map.REL_HEIGHT];
        for (l = LevelEditorScene.map.tilesForeground.size() - 1; l >= 0; --l) {
            for (x = 0; x < LevelEditorScene.map.tilesForeground.get(l).length; ++x) {
                for (y = 0; y < LevelEditorScene.map.tilesForeground.get(l)[x].length; ++y) {
                    if (drewSpots[x][y] || LevelEditorScene.map.tilesForeground.get(l)[x][y] == null || LevelEditorScene.map.tilesForeground.get(l)[x][y].getPhysicalTile() == null || LevelEditorScene.map.tilesForeground.get((int)l)[x][y].getPhysicalTile().type == TileType.NONE) continue;
                    g2D.drawImage((Image)tileTypeViewer.getTileTypeSubimage(LevelEditorScene.map.tilesForeground.get((int)l)[x][y].getPhysicalTile().type), x * 32, y * 32, null);
                    drewSpots[x][y] = true;
                }
            }
        }
        for (l = LevelEditorScene.map.tilesBackground.size() - 1; l >= 0; --l) {
            for (x = 0; x < LevelEditorScene.map.tilesBackground.get(l).length; ++x) {
                for (y = 0; y < LevelEditorScene.map.tilesBackground.get(l)[x].length; ++y) {
                    if (drewSpots[x][y] || LevelEditorScene.map.tilesBackground.get(l)[x][y] == null || LevelEditorScene.map.tilesBackground.get(l)[x][y].getPhysicalTile() == null || LevelEditorScene.map.tilesBackground.get((int)l)[x][y].getPhysicalTile().type == TileType.NONE) continue;
                    g2D.drawImage((Image)tileTypeViewer.getTileTypeSubimage(LevelEditorScene.map.tilesBackground.get((int)l)[x][y].getPhysicalTile().type), x * 32, y * 32, null);
                    drewSpots[x][y] = true;
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.scale(this.scale, this.scale);
        this.drawMap(g2D);
        if (platformListener.pathMode) {
            this.drawPlatformPaths(g2D);
        }
        if (mapEntityListener.locationsMode) {
            this.drawEntityLocations(g2D);
        }
        if (Version.isInReleaseMode() && this.d != null && this.d.hasErrors()) {
            this.font.drawString(g2D, "Check debug console!", 4.0f, 32.0f);
        }
        g2D.dispose();
    }

    private void drawMap(Graphics2D g2D) {
        int i;
        int x;
        List<Point> al;
        int l;
        g2D.setColor(LevelEditorScene.map.bgColor);
        g2D.fillRect(0, 0, LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT);
        g2D.setColor(Color.RED);
        if (LevelEditorScene.map.background != null) {
            Rectangle r = new Rectangle(0, 0, LevelEditorScene.map.background.getWidth(), LevelEditorScene.map.background.getHeight());
            Paint p = g2D.getPaint();
            g2D.setPaint(new TexturePaint(LevelEditorScene.map.background, r));
            g2D.fill(new Rectangle(0, 0, LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT));
            g2D.setPaint(p);
        }
        if (this.selectiveLayerViewMode) {
            if (layerManager.isOnBackgroundLayers()) {
                int n = l = layerManager.getCurrentBackgroundLayer() >= 0 ? (int)layerManager.getCurrentBackgroundLayer() : -1;
                if (l != -1) {
                    g2D.drawImage(bgTileImages.get(l), null, null);
                    al = bgAnimTiles.get(l);
                    for (Point pt : al) {
                        g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[pt.x][pt.y].getUnclonedGraphicTile().getImage(), pt.x * 32, pt.y * 32, null);
                    }
                    if (this.pasted) {
                        for (int x2 = 0; x2 < this.tilesSelected.length; ++x2) {
                            for (int y = 0; y < this.tilesSelected[x2].length; ++y) {
                                if (this.tilesSelected[x2][y] == null || this.tilesSelected[x2][y].getUnclonedGraphicTile() == null) continue;
                                g2D.drawImage((Image)this.tilesSelected[x2][y].getUnclonedGraphicTile().getImage(), (this.topSelX + x2) * 32, (this.topSelY + y) * 32, null);
                            }
                        }
                    }
                }
            } else {
                int n = l = layerManager.getCurrentForegroundLayer() >= 0 ? (int)layerManager.getCurrentForegroundLayer() : -1;
                if (l != -1) {
                    g2D.drawImage(fgTileImages.get(l), null, null);
                    al = fgAnimTiles.get(l);
                    for (Point pt : al) {
                        g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[pt.x][pt.y].getUnclonedGraphicTile().getImage(), pt.x * 32, pt.y * 32, null);
                    }
                    if (this.pasted) {
                        for (int x3 = 0; x3 < this.tilesSelected.length; ++x3) {
                            for (int y = 0; y < this.tilesSelected[x3].length; ++y) {
                                if (this.tilesSelected[x3][y] == null || this.tilesSelected[x3][y].getUnclonedGraphicTile() == null) continue;
                                g2D.drawImage((Image)this.tilesSelected[x3][y].getUnclonedGraphicTile().getImage(), (this.topSelX + x3) * 32, (this.topSelY + y) * 32, null);
                            }
                        }
                    }
                }
            }
        } else {
            for (l = 0; l < LevelEditorScene.map.tilesBackground.size(); ++l) {
                g2D.drawImage(bgTileImages.get(l), null, null);
                al = bgAnimTiles.get(l);
                for (Point pt : al) {
                    g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[pt.x][pt.y].getUnclonedGraphicTile().getImage(), pt.x * 32, pt.y * 32, null);
                }
            }
            if (this.pasted && layerManager.isOnBackgroundLayers()) {
                for (x = 0; x < this.tilesSelected.length; ++x) {
                    for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                        if (this.tilesSelected[x][y] == null || this.tilesSelected[x][y].getUnclonedGraphicTile() == null) continue;
                        g2D.drawImage((Image)this.tilesSelected[x][y].getUnclonedGraphicTile().getImage(), (this.topSelX + x) * 32, (this.topSelY + y) * 32, null);
                    }
                }
            }
            for (l = 0; l < LevelEditorScene.map.tilesForeground.size(); ++l) {
                g2D.drawImage(fgTileImages.get(l), null, null);
                al = fgAnimTiles.get(l);
                for (Point pt : al) {
                    g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[pt.x][pt.y].getUnclonedGraphicTile().getImage(), pt.x * 32, pt.y * 32, null);
                }
            }
            if (this.pasted && !layerManager.isOnBackgroundLayers()) {
                for (x = 0; x < this.tilesSelected.length; ++x) {
                    for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                        if (this.tilesSelected[x][y] == null || this.tilesSelected[x][y].getUnclonedGraphicTile() == null) continue;
                        g2D.drawImage((Image)this.tilesSelected[x][y].getUnclonedGraphicTile().getImage(), (this.topSelX + x) * 32, (this.topSelY + y) * 32, null);
                    }
                }
            }
        }
        if (!this.selectiveLayerViewMode || layerManager.getCurrentBackgroundLayer() == -1) {
            for (i = 0; i < LevelEditorScene.map.iTiles.length; ++i) {
                for (int j = 0; j < LevelEditorScene.map.iTiles[i].length; ++j) {
                    if (LevelEditorScene.map.iTiles[i][j] == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.iTiles[i][j].tile.getImage(), i * 32, j * 32, this);
                }
            }
        }
        if (this.pasted && layerManager.getCurrentBackgroundLayer() == -1) {
            for (x = 0; x < this.iTilesSelected.length; ++x) {
                for (int y = 0; y < this.iTilesSelected[x].length; ++y) {
                    if (this.iTilesSelected[x][y] == null) continue;
                    g2D.drawImage((Image)this.iTilesSelected[x][y].getImage(), (this.topSelX + x) * 32, (this.topSelY + y) * 32, null);
                }
            }
        }
        if (this.debug) {
            for (i = 0; i < LevelEditorScene.map.tilesBackground.get(0).length; ++i) {
                for (int j = 0; j < LevelEditorScene.map.tilesBackground.get(0)[i].length; ++j) {
                    if (LevelEditorScene.map.tilesForeground.get(0)[i][j].getPhysicalTile() != null) {
                        g2D.draw(LevelEditorScene.map.tilesForeground.get((int)0)[i][j].getPhysicalTile().mask);
                        continue;
                    }
                    g2D.draw(LevelEditorScene.map.tilesBackground.get((int)0)[i][j].getPhysicalTile().mask);
                }
            }
        }
        g2D.setColor(Color.GREEN);
        if (imageTileMode && !this.rightClick && this.dragging && platformListener.currentPlatformLayer >= -1 && layerManager.getCurrentBackgroundLayer() >= 0) {
            if (tileViewer.getUnclonedSelectedTiles() != null && tileViewer.getUnclonedSelectedTiles().length == 3 && tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][2].tile, this.bottomSelX * 32, this.bottomSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][2].tile, this.topSelX * 32, this.bottomSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][0].tile, this.bottomSelX * 32, this.topSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][0].tile, this.topSelX * 32, this.topSelY * 32, null);
                for (x = this.topSelX + 1; x < this.bottomSelX; ++x) {
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][0].tile, x * 32, this.topSelY * 32, null);
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][2].tile, x * 32, this.bottomSelY * 32, null);
                }
                for (int y = this.topSelY + 1; y < this.bottomSelY; ++y) {
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][1].tile, this.topSelX * 32, y * 32, null);
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][1].tile, this.bottomSelX * 32, y * 32, null);
                }
                for (x = this.topSelX + 1; x < this.bottomSelX; ++x) {
                    for (int y = this.topSelY + 1; y < this.bottomSelY; ++y) {
                        g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][1].tile, x * 32, y * 32, null);
                    }
                }
            } else if (tileViewer.getUnclonedSelectedTiles() != null) {
                for (x = 0; x < tileViewer.getUnclonedSelectedTiles().length; ++x) {
                    for (int y = 0; y < tileViewer.getUnclonedSelectedTiles()[0].length; ++y) {
                        g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[x][y].tile, (this.mouseRelX + x) * 32, (this.mouseRelY + y) * 32, null);
                    }
                }
            } else if (layerManager.getCurrentBackgroundLayer() == -2) {
                g2D.drawImage((Image)tileTypeViewer.getTileTypeSubimage(tileTypeViewer.getCurrentTileType()), this.mouseRelX * 32, this.mouseRelY * 32, null);
            }
        } else if (!this.rightClick && this.dragging && platformListener.currentPlatformLayer >= -1 && layerManager.getCurrentBackgroundLayer() >= 0 && animatedTileViewer.getUnclonedSelectedTiles() != null) {
            for (x = 0; x < animatedTileViewer.getUnclonedSelectedTiles().length; ++x) {
                for (int y = 0; y < animatedTileViewer.getUnclonedSelectedTiles()[0].length; ++y) {
                    g2D.drawImage((Image)animatedTileViewer.getUnclonedSelectedTiles()[x][y].getImage(), (this.mouseRelX + x) * 32, (this.mouseRelY + y) * 32, null);
                }
            }
        }
        if (layerManager.getCurrentBackgroundLayer() == -4) {
            g2D.drawImage(warpsImage, null, null);
        }
        Composite defaultComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
        if (layerManager.getCurrentBackgroundLayer() == -2) {
            g2D.drawImage(pTilesImage, null, null);
        }
        if (this.pasted && layerManager.getCurrentBackgroundLayer() == -2) {
            for (int x4 = 0; x4 < this.pTilesSelected.length; ++x4) {
                for (int y = 0; y < this.pTilesSelected[x4].length; ++y) {
                    if (this.pTilesSelected[x4][y] == null) continue;
                    g2D.drawImage((Image)tileTypeViewer.getTileTypeSubimage(this.pTilesSelected[x4][y].type), (this.topSelX + x4) * 32, (this.topSelY + y) * 32, null);
                }
            }
        }
        if (layerManager.getCurrentBackgroundLayer() == -3) {
            for (int i2 = 0; i2 < LevelEditorScene.map.spawnLocs.length; ++i2) {
                for (int j = 0; j < LevelEditorScene.map.spawnLocs[i2].length; ++j) {
                    if (!LevelEditorScene.map.spawnLocs[i2][j]) continue;
                    g2D.drawImage((Image)this.noSpawnZone, i2 * 32, j * 32, null);
                }
            }
        }
        if (this.selectionMode || this.selectionMade) {
            g2D.setColor(Color.RED);
            g2D.fillRect(this.topSelX * 32, this.topSelY * 32, (this.bottomSelX - this.topSelX) * 32, (this.bottomSelY - this.topSelY) * 32);
            if (this.mouseInFrame) {
                g2D.setColor(Color.GREEN);
                g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
            }
        } else if (this.mouseInFrame) {
            if (this.rightClick) {
                g2D.setColor(Color.RED);
                g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32 * this.eraserBrushSize, 32 * this.eraserBrushSize);
            } else {
                g2D.setColor(Color.GREEN);
                if (layerManager.isOnBackgroundLayers() && (layerManager.getCurrentBackgroundLayer() == -2 || layerManager.getCurrentBackgroundLayer() == -3)) {
                    g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32 * this.brushSize, 32 * this.brushSize);
                } else {
                    g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
                }
            }
        }
        g2D.setComposite(defaultComposite);
    }

    private void drawPlatformPaths(Graphics2D g2D) {
        int y;
        int x;
        if (LevelEditorScene.map.platforms.size() == 0) {
            platformListener.pathMode = false;
        }
        g2D.setComposite(AlphaComposite.getInstance(3));
        int i = platformListener.selectedPlatform;
        Platform p = LevelEditorScene.map.platforms.get(i);
        Point2D.Float startPoint = p.helper.getStartPoint();
        for (x = 0; x < p.gTiles.length; ++x) {
            for (y = 0; y < p.gTiles[x].length; ++y) {
                if (p.gTiles[x][y] == null) continue;
                g2D.drawImage((Image)p.gTiles[x][y].getImage(), (int)((double)startPoint.x - p.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - p.getWidth() / 2.0) + y * 32, null);
            }
        }
        for (x = 0; x < p.iTiles.length; ++x) {
            for (y = 0; y < p.iTiles[x].length; ++y) {
                if (p.iTiles[x][y] == null) continue;
                g2D.drawImage((Image)p.iTiles[x][y].tile.getImage(), (int)((double)startPoint.x - p.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - p.getWidth() / 2.0) + y * 32, null);
            }
        }
        this.drawPathPoints(g2D, p);
        if (p.getPath() instanceof Polygon) {
            Polygon poly = (Polygon)p.getPath();
            for (int count = 0; count < poly.npoints; ++count) {
                if (count == 0) {
                    g2D.drawImage((Image)brightNodeImage, poly.xpoints[count] - brightNodeImage.getWidth() / 2, poly.ypoints[count] - brightNodeImage.getHeight() / 2, null);
                    continue;
                }
                if (count == poly.npoints - 1) {
                    g2D.drawImage((Image)blueNodeImage, poly.xpoints[count] - blueNodeImage.getWidth() / 2, poly.ypoints[count] - blueNodeImage.getHeight() / 2, null);
                    continue;
                }
                g2D.drawImage((Image)greenNodeImage, poly.xpoints[count] - greenNodeImage.getWidth() / 2, poly.ypoints[count] - greenNodeImage.getHeight() / 2, null);
            }
        } else if (p.getPath() instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)p.getPath();
            g2D.drawImage((Image)greenNodeImage, (int)(rr.getX() + rr.getArcWidth() - (double)(greenNodeImage.getWidth() / 2)), (int)(rr.getY() + rr.getArcHeight() - (double)(greenNodeImage.getHeight() / 2)), null);
        }
        if (!(p.getPath() instanceof Polygon)) {
            Rectangle bounds = p.getPath().getBounds();
            g2D.drawImage((Image)redNodeImage, bounds.x - redNodeImage.getWidth() / 2, bounds.y - redNodeImage.getHeight() / 2, null);
            g2D.drawImage((Image)blueNodeImage, bounds.x + bounds.width - blueNodeImage.getWidth() / 2, bounds.y + bounds.height - blueNodeImage.getHeight() / 2, null);
        }
    }

    private void drawPathPoints(Graphics2D g2D, Platform plat) {
        PathIterator it = plat.helper.getPathIterator();
        double t = 0.0;
        double totalTime = 0.0;
        Point2D.Float startPoint = null;
        Point2D.Float platformPoint = null;
        boolean placedPlatformPoint = false;
        while (!it.isDone()) {
            double[] points = new double[6];
            int pathType = it.currentSegment(points);
            if (pathType == 0) {
                startPoint = new Point2D.Float((float)points[0], (float)points[1]);
                it.next();
                pathType = it.currentSegment(points);
                continue;
            }
            if (pathType == 4) {
                it.next();
                continue;
            }
            Point2D.Float drawPoint = PathFollower.getPointOnPath(pathType, points, t, startPoint);
            g2D.drawImage((Image)pathNodeImage, (int)(drawPoint.x - (float)(pathNodeImage.getWidth() / 2)), (int)(drawPoint.y - (float)(pathNodeImage.getHeight() / 2)), null);
            t += plat.speed / 1000.0 * 50.0;
            totalTime += plat.speed / 1000.0 * 50.0;
            if (totalTime >= plat.startTime && !placedPlatformPoint) {
                platformPoint = PathFollower.getPointOnPath(pathType, points, totalTime - (double)((int)totalTime), startPoint);
                placedPlatformPoint = true;
            }
            if (!(t >= 1.0)) continue;
            t -= 1.0;
            switch (pathType) {
                case 1: {
                    startPoint = new Point2D.Float((float)points[0], (float)points[1]);
                    break;
                }
                case 2: {
                    startPoint = new Point2D.Float((float)points[2], (float)points[3]);
                    break;
                }
                case 3: {
                    startPoint = new Point2D.Float((float)points[4], (float)points[5]);
                }
            }
            it.next();
        }
        if (plat.getPath() instanceof Polygon) {
            Polygon poly = (Polygon)plat.getPath();
            Point2D.Float sp = new Point2D.Float(poly.xpoints[0], poly.ypoints[0]);
            double[] endPoint = new double[]{poly.xpoints[poly.npoints - 1], poly.ypoints[poly.npoints - 1], 0.0, 0.0, 0.0, 0.0};
            for (double count = t; count <= 1.0; count += plat.speed / 1000.0 * 50.0) {
                Point2D.Float drawPoint = PathFollower.getPointOnPath(1, endPoint, count, sp);
                g2D.drawImage((Image)redNodeImage, (int)(drawPoint.x - (float)(redNodeImage.getWidth() / 2)), (int)(drawPoint.y - (float)(redNodeImage.getHeight() / 2)), null);
            }
        }
        platformPoint = plat.helper.getStartPoint();
        g2D.drawImage((Image)brightNodeImage, (int)(platformPoint.x - (float)(brightNodeImage.getWidth() / 2)), (int)(platformPoint.y - (float)(brightNodeImage.getHeight() / 2)), null);
    }

    private void drawEntityLocations(Graphics2D g2D) {
        g2D.setComposite(AlphaComposite.getInstance(3));
        for (EditableEntity e : LevelEditorScene.map.mapEntities) {
            e.drawToScreen(g2D, e.entityX, e.entityY);
            if (e instanceof BulletBillEntity) {
                ((BulletBillEntity)e).drawPath(g2D, map);
            }
            if (e instanceof Rotodisc) {
                for (Rotodisc.Disc d : ((Rotodisc)e).discs) {
                    d.drawToScreen(g2D, d.entityX, d.entityY);
                }
            }
            if (!(e instanceof FireballBar)) continue;
            for (FireballBar.BarFireball b : ((FireballBar)e).fireballs) {
                b.drawToScreen(g2D, b.entityX, b.entityY);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.selectionMode && this.selectionMade && !this.pasted) {
            this.selectionMade = false;
            this.bottomSelY = 0;
            this.bottomSelX = 0;
            this.topSelY = 0;
            this.topSelX = 0;
        }
        if (this.selectionMode && e.isPopupTrigger()) {
            this.popupMenu.show(this, e.getX(), e.getY());
        }
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseInFrame = true;
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInFrame = false;
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        tabs.requestFocus();
        this.edit = new StateEdit(map);
        if (this.selectionMode) {
            if (!this.selectionMade) {
                this.topSelX = this.mouseRelX;
                this.topSelY = this.mouseRelY;
                this.bottomSelX = this.topSelX;
                this.bottomSelY = this.topSelY;
            }
            if (e.isPopupTrigger()) {
                this.popupMenu.show(this, e.getX(), e.getY());
            }
        } else if (platformListener.pathMode) {
            this.handlePlatformPress(e);
        } else if (mapEntityListener.locationsMode) {
            this.handleMapEntityPress(e);
        } else {
            this.rightClick = e.getButton() == 3;
        }
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseButton = e.getButton();
        this.rightClick = false;
        if (this.selectionMode) {
            if (!this.selectionMade) {
                this.selectionMade = true;
            }
            if (e.isPopupTrigger()) {
                this.popupMenu.show(this, e.getX(), e.getY());
            }
            return;
        }
        if (platformListener.pathMode) {
            this.handlePlatformRelease(e);
            return;
        }
        if (mapEntityListener.locationsMode) {
            this.handleMapEntityRelease(e);
            return;
        }
        this.dragging = false;
        switch (layerManager.getCurrentBackgroundLayer()) {
            case -1: {
                this.handleInteractiveTilePlacement(mouseButton);
                break;
            }
            case -2: {
                this.handleTileTypePlacement(mouseButton);
                break;
            }
            case -3: {
                this.handleSpawnZonePlacement(mouseButton);
                break;
            }
            case -4: {
                this.handleWarpPlacement(mouseButton);
                break;
            }
            default: {
                if (imageTileMode) {
                    this.handleImageTilePlacement(mouseButton);
                    break;
                }
                this.handleAnimatedTilePlacement(mouseButton);
            }
        }
        LevelEditorScene.recalculateMapImages();
        this.edit.end();
        this.undoManager.addEdit(this.edit);
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectionMode) {
            this.dragSelection(e);
            return;
        }
        if (platformListener.pathMode) {
            this.handlePlatformDrag(e);
            return;
        }
        if (mapEntityListener.locationsMode) {
            this.handleMapEntityDrag(e);
            return;
        }
        this.dragging = true;
        if (this.rightClick) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
            this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
            switch (layerManager.getCurrentBackgroundLayer()) {
                case -1: {
                    this.handleInteractiveTilePlacement(3);
                    break;
                }
                case -2: {
                    this.handleTileTypePlacement(3);
                    break;
                }
                case -3: {
                    this.handleSpawnZonePlacement(3);
                    break;
                }
                case -4: {
                    this.handleWarpPlacement(3);
                    break;
                }
                default: {
                    if (imageTileMode) {
                        this.handleImageTilePlacement(3);
                        break;
                    }
                    this.handleAnimatedTilePlacement(3);
                    break;
                }
            }
        } else if (layerManager.getCurrentBackgroundLayer() >= 0 && imageTileMode && tileViewer.getUnclonedSelectedTiles().length == 3 && tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
            this.topSelX = (int)((float)this.mouseRelX > (float)e.getX() / (32.0f * this.scale) ? (float)e.getX() / (32.0f * this.scale) : (float)this.mouseRelX);
            this.topSelY = (int)((float)this.mouseRelY > (float)e.getY() / (32.0f * this.scale) ? (float)e.getY() / (32.0f * this.scale) : (float)this.mouseRelY);
            this.bottomSelX = (int)((float)this.mouseRelX < (float)e.getX() / (32.0f * this.scale) ? (float)e.getX() / (32.0f * this.scale) : (float)this.mouseRelX);
            this.bottomSelY = (int)((float)this.mouseRelY < (float)e.getY() / (32.0f * this.scale) ? (float)e.getY() / (32.0f * this.scale) : (float)this.mouseRelY);
            if (this.bottomSelX > LevelEditorScene.map.REL_WIDTH - 1) {
                this.bottomSelX = LevelEditorScene.map.REL_WIDTH - 1;
            }
            if (this.bottomSelY > LevelEditorScene.map.REL_HEIGHT - 1) {
                this.bottomSelY = LevelEditorScene.map.REL_HEIGHT - 1;
            }
        } else if (e.isShiftDown()) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
            this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
            switch (layerManager.getCurrentBackgroundLayer()) {
                case -1: {
                    this.handleInteractiveTilePlacement(1);
                    break;
                }
                case -2: {
                    this.handleTileTypePlacement(1);
                    break;
                }
                case -3: {
                    this.handleSpawnZonePlacement(1);
                    break;
                }
                case -4: {
                    this.handleWarpPlacement(1);
                    break;
                }
                default: {
                    if (imageTileMode) {
                        this.handleImageTilePlacement(1);
                        break;
                    }
                    this.handleAnimatedTilePlacement(1);
                    break;
                }
            }
        } else {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
            this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
        }
        LevelEditorScene.recalculateMapImages();
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseInFrame) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
            this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
        }
        e.consume();
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.selectionMade) {
            switch (keyCode) {
                case 127: {
                    this.deleteSelection();
                    break;
                }
                case 10: {
                    this.finalizeSelection();
                    break;
                }
                case 27: {
                    this.cancelSelection();
                }
            }
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void copySelection() {
        block10: {
            block8: {
                block11: {
                    block9: {
                        if (!layerManager.isOnBackgroundLayers()) break block8;
                        if (layerManager.getCurrentBackgroundLayer() < 0) break block9;
                        this.tilesSelected = new OrderedTile[this.bottomSelX - this.topSelX][this.bottomSelY - this.topSelY];
                        for (int x = 0; x < this.tilesSelected.length; ++x) {
                            for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                                if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                                this.tilesSelected[x][y] = (OrderedTile)LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].clone();
                            }
                        }
                        break block10;
                    }
                    if (layerManager.getCurrentBackgroundLayer() != -1) break block11;
                    this.iTilesSelected = new InteractiveTile[this.bottomSelX - this.topSelX][this.bottomSelY - this.topSelY];
                    for (int x = 0; x < this.tilesSelected.length; ++x) {
                        for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                            if (this.checkOutOfBounds(x, y)) continue;
                            this.iTilesSelected[x][y] = (InteractiveTile)LevelEditorScene.map.iTiles[this.topSelX + x][this.topSelY + y].clone();
                        }
                    }
                    break block10;
                }
                if (layerManager.getCurrentBackgroundLayer() != -2) break block10;
                this.pTilesSelected = new PhysicalTile[this.bottomSelX - this.topSelX][this.bottomSelY - this.topSelY];
                for (int x = 0; x < this.tilesSelected.length; ++x) {
                    for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                        if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                        this.pTilesSelected[x][y] = (PhysicalTile)LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].getPhysicalTile().clone();
                    }
                }
                break block10;
            }
            this.tilesSelected = new OrderedTile[this.bottomSelX - this.topSelX][this.bottomSelY - this.topSelY];
            for (int x = 0; x < this.tilesSelected.length; ++x) {
                for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                    if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                    this.tilesSelected[x][y] = (OrderedTile)LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[this.topSelX + x][this.topSelY + y].clone();
                }
            }
        }
    }

    private void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    private void pasteSelection() {
        if (this.pasted) {
            this.finalizeSelection();
        }
        this.topSelX = this.mouseRelX;
        this.topSelY = this.mouseRelY;
        if (layerManager.isOnBackgroundLayers()) {
            if (layerManager.getCurrentBackgroundLayer() >= 0) {
                this.bottomSelX = this.topSelX + this.tilesSelected.length;
                this.bottomSelY = this.topSelY + this.tilesSelected[0].length;
            } else if (layerManager.getCurrentBackgroundLayer() == -1) {
                this.bottomSelX = this.topSelX + this.iTilesSelected.length;
                this.bottomSelY = this.topSelY + this.iTilesSelected[0].length;
            } else if (layerManager.getCurrentBackgroundLayer() == -2) {
                this.bottomSelX = this.topSelX + this.pTilesSelected.length;
                this.bottomSelY = this.topSelY + this.pTilesSelected[0].length;
            }
        } else {
            this.bottomSelX = this.topSelX + this.tilesSelected.length;
            this.bottomSelY = this.topSelY + this.tilesSelected[0].length;
        }
        this.pasted = true;
    }

    private void deleteSelection() {
        if (this.pasted) {
            this.pasted = false;
        } else if (layerManager.isOnBackgroundLayers()) {
            if (layerManager.getCurrentBackgroundLayer() >= 0) {
                for (int x = 0; x < this.bottomSelX - this.topSelX; ++x) {
                    for (int y = 0; y < this.bottomSelY - this.topSelY; ++y) {
                        if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                        LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].nullify();
                    }
                }
            } else if (layerManager.getCurrentBackgroundLayer() == -1) {
                for (int x = 0; x < this.bottomSelX - this.topSelX; ++x) {
                    for (int y = 0; y < this.bottomSelY - this.topSelY; ++y) {
                        if (this.checkOutOfBounds(x, y)) continue;
                        LevelEditorScene.map.iTiles[this.topSelX + x][this.topSelY + y] = null;
                    }
                }
            } else if (layerManager.getCurrentBackgroundLayer() == -2) {
                for (int x = 0; x < this.bottomSelX - this.topSelX; ++x) {
                    for (int y = 0; y < this.bottomSelY - this.topSelY; ++y) {
                        if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                        LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].setPhysicalTile(null);
                    }
                }
            }
        } else {
            for (int x = 0; x < this.bottomSelX - this.topSelX; ++x) {
                for (int y = 0; y < this.bottomSelY - this.topSelY; ++y) {
                    if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[this.topSelX + x][this.topSelY + y] == null) continue;
                    LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[this.topSelX + x][this.topSelY + y].nullify();
                }
            }
        }
        this.selectionMade = false;
        this.bottomSelY = 0;
        this.bottomSelX = 0;
        this.topSelY = 0;
        this.topSelX = 0;
    }

    private void dragSelection(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.pasted) {
            this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
            this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
            this.topSelX = this.mouseRelX;
            this.topSelY = this.mouseRelY;
            if (layerManager.isOnBackgroundLayers()) {
                if (layerManager.getCurrentBackgroundLayer() >= 0) {
                    this.bottomSelX = this.topSelX + this.tilesSelected.length;
                    this.bottomSelY = this.topSelY + this.tilesSelected[0].length;
                } else if (layerManager.getCurrentBackgroundLayer() == -1) {
                    this.bottomSelX = this.topSelX + this.iTilesSelected.length;
                    this.bottomSelY = this.topSelY + this.iTilesSelected[0].length;
                } else if (layerManager.getCurrentBackgroundLayer() == -2) {
                    this.bottomSelX = this.topSelX + this.pTilesSelected.length;
                    this.bottomSelY = this.topSelY + this.pTilesSelected[0].length;
                }
            } else {
                this.bottomSelX = this.topSelX + this.tilesSelected.length;
                this.bottomSelY = this.topSelY + this.tilesSelected[0].length;
            }
        } else {
            this.topSelX = (int)((float)this.mouseRelX > (float)e.getX() / (32.0f * this.scale) ? (float)e.getX() / (32.0f * this.scale) : (float)this.mouseRelX);
            this.topSelY = (int)((float)this.mouseRelY > (float)e.getY() / (32.0f * this.scale) ? (float)e.getY() / (32.0f * this.scale) : (float)this.mouseRelY);
            this.bottomSelX = (int)((float)this.mouseRelX < (float)e.getX() / (32.0f * this.scale) ? (float)e.getX() / (32.0f * this.scale) : (float)this.mouseRelX);
            this.bottomSelY = (int)((float)this.mouseRelY < (float)e.getY() / (32.0f * this.scale) ? (float)e.getY() / (32.0f * this.scale) : (float)this.mouseRelY);
        }
        if (this.bottomSelX >= LevelEditorScene.map.REL_WIDTH) {
            this.bottomSelX = LevelEditorScene.map.REL_WIDTH;
        }
        if (this.bottomSelY >= LevelEditorScene.map.REL_HEIGHT) {
            this.bottomSelY = LevelEditorScene.map.REL_HEIGHT;
        }
    }

    private void finalizeSelection() {
        if (layerManager.isOnBackgroundLayers()) {
            if (layerManager.getCurrentBackgroundLayer() >= 0) {
                for (int x = 0; x < this.tilesSelected.length; ++x) {
                    for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                        if (this.checkOutOfBounds(x, y) || this.tilesSelected[x][y] == null) continue;
                        LevelEditorScene.map.tilesBackground.get((int)LevelEditorScene.layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y] = (OrderedTile)this.tilesSelected[x][y].clone();
                    }
                }
            } else if (layerManager.getCurrentBackgroundLayer() == -1) {
                for (int x = 0; x < this.iTilesSelected.length; ++x) {
                    for (int y = 0; y < this.iTilesSelected[x].length; ++y) {
                        if (this.checkOutOfBounds(x, y) || this.tilesSelected[x][y] == null) continue;
                        LevelEditorScene.map.iTiles[this.topSelX + x][this.topSelY + y] = (InteractiveTile)this.iTilesSelected[x][y].clone();
                    }
                }
            } else if (layerManager.getCurrentBackgroundLayer() == -2) {
                for (int x = 0; x < this.pTilesSelected.length; ++x) {
                    for (int y = 0; y < this.pTilesSelected[x].length; ++y) {
                        if (this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[x][y].getPhysicalTile() == null) continue;
                        if (this.pTilesSelected[x][y] != null) {
                            LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].setPhysicalTile((PhysicalTile)this.pTilesSelected[x][y].clone());
                        } else {
                            LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].setPhysicalTile(new PhysicalTile(TileType.NONE, PhysicalTile.DEFAULT));
                        }
                        LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[this.topSelX + x][this.topSelY + y].getPhysicalTile().translate((this.topSelX + x) * 32, (this.topSelY + y) * 32);
                    }
                }
            }
        } else {
            for (int x = 0; x < this.tilesSelected.length; ++x) {
                for (int y = 0; y < this.tilesSelected[x].length; ++y) {
                    if (this.checkOutOfBounds(x, y) || this.tilesSelected[x][y] == null) continue;
                    LevelEditorScene.map.tilesForeground.get((int)LevelEditorScene.layerManager.getCurrentForegroundLayer())[this.topSelX + x][this.topSelY + y] = (OrderedTile)this.tilesSelected[x][y].clone();
                }
            }
        }
        this.pasted = false;
        this.selectionMade = false;
        this.bottomSelY = 0;
        this.bottomSelX = 0;
        this.topSelY = 0;
        this.topSelX = 0;
    }

    private void cancelSelection() {
        this.pasted = false;
        this.selectionMade = false;
        this.bottomSelY = 0;
        this.bottomSelX = 0;
        this.topSelY = 0;
        this.topSelX = 0;
    }

    private void handlePlatformPress(MouseEvent e) {
        int clickWidth = 8;
        this.mouseX = (int)((float)e.getX() / this.scale);
        this.mouseY = (int)((float)e.getY() / this.scale);
        platformListener.pointSelected = false;
        this.platformFreeformIndex = -1;
        Shape s = LevelEditorScene.map.platforms.get(platformListener.selectedPlatform).getPath();
        if (s instanceof Polygon) {
            platformListener.pointSelected = true;
            return;
        }
        double pathX = s.getBounds().x;
        double pathY = s.getBounds().y;
        double pathWidth = s.getBounds().width;
        double pathHeight = s.getBounds().height;
        Ellipse2D.Double area1 = new Ellipse2D.Double(pathX - (double)clickWidth, pathY - (double)clickWidth, clickWidth * 2, clickWidth * 2);
        Ellipse2D.Double area2 = new Ellipse2D.Double(pathX + pathWidth - (double)clickWidth, pathY + pathHeight - (double)clickWidth, clickWidth * 2, clickWidth * 2);
        platformListener.pointSelected = area1.contains(this.mouseX, this.mouseY) || area2.contains(this.mouseX, this.mouseY);
        if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            double arcX = rr.getX() + rr.getArcWidth();
            double arcY = rr.getY() + rr.getArcHeight();
            Ellipse2D.Double area3 = new Ellipse2D.Double(arcX - (double)clickWidth, arcY - (double)clickWidth, clickWidth * 2, clickWidth * 2);
            platformListener.pointSelected = platformListener.pointSelected || area3.contains(this.mouseX, this.mouseY);
        }
    }

    private void handlePlatformDrag(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
        this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
        Platform p = LevelEditorScene.map.platforms.get(platformListener.selectedPlatform);
        if (!platformListener.pointSelected) {
            if (p.getPath() instanceof RectangularShape) {
                RectangularShape s = (RectangularShape)p.getPath();
                if (e.isShiftDown()) {
                    s.setFrame(this.mouseRelX * 32, this.mouseRelY * 32, s.getWidth(), s.getHeight());
                } else {
                    s.setFrame((float)this.mouseX / this.scale, (float)this.mouseY / this.scale, s.getWidth(), s.getHeight());
                }
            } else if (p.getPath() instanceof Line2D) {
                double ySpot;
                double xSpot;
                Line2D l = (Line2D)p.getPath();
                double rise = l.getY2() - l.getY1();
                double run = l.getX2() - l.getX1();
                if (e.isShiftDown()) {
                    xSpot = this.mouseRelX * 32;
                    ySpot = this.mouseRelY * 32;
                } else {
                    xSpot = (float)this.mouseX / this.scale;
                    ySpot = (float)this.mouseY / this.scale;
                }
                l.setLine(xSpot, ySpot, xSpot + run, ySpot + rise);
            }
        } else {
            Shape rPath;
            Point2D.Double arcPoint;
            double mouseX = (float)this.mouseX / this.scale;
            double mouseY = (float)this.mouseY / this.scale;
            Rectangle pathBounds = p.getPath().getBounds();
            double changeWidth = 0.0;
            double changeHeight = 0.0;
            double changeX = 0.0;
            double changeY = 0.0;
            Shape path = p.getPath();
            Point2D.Double clickArea1 = new Point2D.Double(pathBounds.x, pathBounds.y);
            Point2D.Double clickArea2 = new Point2D.Double(pathBounds.x + pathBounds.width, pathBounds.y + pathBounds.height);
            Point2D.Double mouse = new Point2D.Double(mouseX, mouseY);
            if (p.getPath() instanceof Polygon) {
                int i;
                Polygon poly = (Polygon)p.getPath();
                double smallest = 8.0;
                LinkedList<Point> points = new LinkedList<Point>();
                for (i = 0; i < poly.npoints; ++i) {
                    points.add(new Point(poly.xpoints[i], poly.ypoints[i]));
                }
                if (this.platformFreeformIndex == -1) {
                    for (i = 0; i < points.size(); ++i) {
                        if (!(((Point)points.get(i)).distance(mouseX, mouseY) < smallest)) continue;
                        smallest = ((Point)points.get(i)).distance(mouseX, mouseY);
                        this.platformFreeformIndex = i;
                    }
                }
                if (this.platformFreeformIndex != -1) {
                    poly.xpoints[this.platformFreeformIndex] = (int)Math.round(mouseX);
                    poly.ypoints[this.platformFreeformIndex] = (int)Math.round(mouseY);
                    if (e.isShiftDown()) {
                        poly.xpoints[this.platformFreeformIndex] = (int)Math.round(mouseX / 16.0) * 16;
                        poly.ypoints[this.platformFreeformIndex] = (int)Math.round(mouseY / 16.0) * 16;
                    }
                } else {
                    smallest = 2.147483647E9;
                    int closeIndex = -1;
                    Point mousePoint = new Point((int)mouseX, (int)mouseY);
                    if (e.isShiftDown()) {
                        mousePoint = new Point((int)Math.round(mouseX / 16.0) * 16, (int)Math.round(mouseY / 16.0) * 16);
                    }
                    for (int i2 = 0; i2 < points.size() - 1; ++i2) {
                        Line2D.Double l = new Line2D.Double((Point2D)points.get(i2), (Point2D)points.get(i2 + 1));
                        if (!(l.ptLineDist(mousePoint) < smallest)) continue;
                        smallest = l.ptSegDist(mousePoint);
                        closeIndex = i2 + 1;
                    }
                    Line2D.Double l = new Line2D.Double((Point2D)points.get(points.size() - 1), (Point2D)points.get(0));
                    if (l.ptLineDist(mousePoint) < smallest) {
                        smallest = l.ptSegDist(mousePoint);
                        closeIndex = points.size();
                    }
                    this.platformFreeformIndex = closeIndex;
                    points.add(closeIndex, mousePoint);
                    int[] xpoints = new int[points.size()];
                    int[] ypoints = new int[points.size()];
                    for (int i3 = 0; i3 < points.size(); ++i3) {
                        xpoints[i3] = ((Point)points.get((int)i3)).x;
                        ypoints[i3] = ((Point)points.get((int)i3)).y;
                    }
                    p.setPath(new Polygon(xpoints, ypoints, points.size()));
                }
            }
            if (p.getPath() instanceof RoundRectangle2D && (arcPoint = new Point2D.Double(((RectangularShape)(rPath = (RoundRectangle2D)path)).getX() + ((RoundRectangle2D)rPath).getArcWidth(), ((RectangularShape)rPath).getY() + ((RoundRectangle2D)rPath).getArcHeight())).distance(mouse) < clickArea1.distance(mouse) && arcPoint.distance(mouse) < clickArea2.distance(mouse)) {
                double arcWidth = mouseX - ((RectangularShape)rPath).getX();
                double arcHeight = mouseY - ((RectangularShape)rPath).getY();
                if (e.isControlDown()) {
                    arcWidth = Math.round((mouseX - ((RectangularShape)rPath).getX()) / 16.0) * 16L;
                    arcHeight = Math.round((mouseY - ((RectangularShape)rPath).getY()) / 16.0) * 16L;
                }
                arcWidth = arcWidth > 0.0 ? arcWidth : 0.0;
                arcHeight = arcHeight > 0.0 ? arcHeight : 0.0;
                ((RoundRectangle2D)rPath).setRoundRect(((RectangularShape)rPath).getX(), ((RectangularShape)rPath).getY(), ((RectangularShape)rPath).getWidth(), ((RectangularShape)rPath).getHeight(), arcWidth, arcHeight);
                return;
            }
            if (clickArea1.distance(mouse) < clickArea2.distance(mouse)) {
                changeX = mouseX;
                changeY = mouseY;
                changeWidth = mouseX - (double)pathBounds.x;
                changeHeight = mouseY - (double)pathBounds.y;
                if (e.isShiftDown()) {
                    changeX = Math.round(mouseX / 16.0) * 16L;
                    changeY = Math.round(mouseY / 16.0) * 16L;
                    changeWidth = Math.round((changeX - (double)pathBounds.x) / 16.0) * 16L;
                    changeHeight = Math.round((changeY - (double)pathBounds.y) / 16.0) * 16L;
                }
                if (path instanceof Line2D) {
                    rPath = (Line2D)path;
                    ((Line2D)rPath).setLine(changeX, changeY, ((Line2D)rPath).getX2(), ((Line2D)rPath).getY2());
                    if (((Line2D)rPath).getX1() > ((Line2D)rPath).getX2()) {
                        ((Line2D)rPath).setLine(((Line2D)rPath).getX1(), ((Line2D)rPath).getY1(), ((Line2D)rPath).getX1(), ((Line2D)rPath).getY2());
                    }
                    if (((Line2D)rPath).getY1() > ((Line2D)rPath).getY2()) {
                        ((Line2D)rPath).setLine(((Line2D)rPath).getX1(), ((Line2D)rPath).getY1(), ((Line2D)rPath).getX2(), ((Line2D)rPath).getY1());
                    }
                }
                if (path instanceof RectangularShape) {
                    rPath = (RectangularShape)path;
                    if (((RectangularShape)rPath).getWidth() - changeWidth < 0.0) {
                        changeWidth = ((RectangularShape)rPath).getWidth() == 0.0 ? 0.0 : (changeWidth -= ((RectangularShape)rPath).getWidth());
                    }
                    if (((RectangularShape)rPath).getHeight() - changeHeight < 0.0) {
                        changeHeight = ((RectangularShape)rPath).getHeight() == 0.0 ? 0.0 : (changeHeight -= ((RectangularShape)rPath).getHeight());
                    }
                    ((RectangularShape)rPath).setFrame(changeX, changeY, ((RectangularShape)rPath).getWidth() - changeWidth, ((RectangularShape)rPath).getHeight() - changeHeight);
                }
            } else {
                changeX = mouseX;
                changeY = mouseY;
                if (e.isShiftDown()) {
                    changeX = Math.round(mouseX / 16.0) * 16L;
                    changeY = Math.round(mouseY / 16.0) * 16L;
                }
                changeWidth = changeX - (double)pathBounds.x;
                changeHeight = changeY - (double)pathBounds.y;
                if (path instanceof Line2D) {
                    rPath = (Line2D)path;
                    ((Line2D)rPath).setLine(((Line2D)rPath).getX1(), ((Line2D)rPath).getY1(), changeX, changeY);
                    if (((Line2D)rPath).getX1() > ((Line2D)rPath).getX2()) {
                        ((Line2D)rPath).setLine(((Line2D)rPath).getX1(), ((Line2D)rPath).getY1(), ((Line2D)rPath).getX1(), ((Line2D)rPath).getY2());
                    }
                    if (((Line2D)rPath).getY1() > ((Line2D)rPath).getY2()) {
                        ((Line2D)rPath).setLine(((Line2D)rPath).getX1(), ((Line2D)rPath).getY1(), ((Line2D)rPath).getX2(), ((Line2D)rPath).getY1());
                    }
                }
                if (path instanceof RectangularShape) {
                    rPath = (RectangularShape)path;
                    ((RectangularShape)rPath).setFrame(((RectangularShape)rPath).getX(), ((RectangularShape)rPath).getY(), changeWidth, changeHeight);
                    if (((RectangularShape)rPath).getWidth() < 0.0) {
                        ((RectangularShape)rPath).setFrame(((RectangularShape)rPath).getX(), ((RectangularShape)rPath).getY(), 0.0, ((RectangularShape)rPath).getHeight());
                    }
                    if (((RectangularShape)rPath).getHeight() < 0.0) {
                        ((RectangularShape)rPath).setFrame(((RectangularShape)rPath).getX(), ((RectangularShape)rPath).getY(), ((RectangularShape)rPath).getWidth(), 0.0);
                    }
                }
            }
        }
        p.setPathIterator();
    }

    private void handlePlatformRelease(MouseEvent e) {
        Platform p = LevelEditorScene.map.platforms.get(platformListener.selectedPlatform);
        if (p.getPath() instanceof Polygon && e.getButton() == 3) {
            int i;
            Polygon poly = (Polygon)p.getPath();
            if (poly.npoints == 2) {
                return;
            }
            double smallest = 8.0;
            LinkedList<Point> points = new LinkedList<Point>();
            for (i = 0; i < poly.npoints; ++i) {
                points.add(new Point(poly.xpoints[i], poly.ypoints[i]));
            }
            if (this.platformFreeformIndex == -1) {
                for (i = 0; i < points.size(); ++i) {
                    if (!(((Point)points.get(i)).distance(this.mouseX, this.mouseY) < smallest)) continue;
                    smallest = ((Point)points.get(i)).distance(this.mouseX, this.mouseY);
                    this.platformFreeformIndex = i;
                }
            }
            if (this.platformFreeformIndex != -1) {
                points.remove(this.platformFreeformIndex);
            }
            int[] xpoints = new int[points.size()];
            int[] ypoints = new int[points.size()];
            for (int i2 = 0; i2 < points.size(); ++i2) {
                xpoints[i2] = ((Point)points.get((int)i2)).x;
                ypoints[i2] = ((Point)points.get((int)i2)).y;
            }
            p.setPath(new Polygon(xpoints, ypoints, points.size()));
        }
    }

    private void handleMapEntityPress(MouseEvent e) {
        this.mouseX = (int)((float)e.getX() / this.scale);
        this.mouseY = (int)((float)e.getY() / this.scale);
    }

    private void handleMapEntityDrag(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mouseRelX = (int)Math.floor((float)this.mouseX / (32.0f * this.scale));
        this.mouseRelY = (int)Math.floor((float)this.mouseY / (32.0f * this.scale));
        if (mapEntityListener.currentEntity < 0) {
            return;
        }
        if (e.isShiftDown()) {
            LevelEditorScene.map.mapEntities.get(mapEntityListener.currentEntity).setRelLocation((int)Math.floor((float)this.mouseX / (16.0f * this.scale)), (int)Math.floor((float)this.mouseY / (16.0f * this.scale)));
        } else {
            LevelEditorScene.map.mapEntities.get(mapEntityListener.currentEntity).setLocation((float)this.mouseX / this.scale, (float)this.mouseY / this.scale);
        }
    }

    private void handleMapEntityRelease(MouseEvent e) {
    }

    private void handleImageTilePlacement(int mouseButton) {
        int y;
        int x;
        OrderedTile[][] tiles = layerManager.isOnBackgroundLayers() ? LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer()) : LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer());
        if (mouseButton == 1) {
            if (this.bottomSelX - this.topSelX > 0 && this.bottomSelY - this.topSelY > 0 && tileViewer.getUnclonedSelectedTiles().length == 3 && tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
                tiles[this.bottomSelX][this.bottomSelY] = new OrderedTile();
                tiles[this.bottomSelX][this.bottomSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][2].mask));
                tiles[this.bottomSelX][this.bottomSelY].getPhysicalTile().translate(this.bottomSelX * 32, this.bottomSelY * 32);
                tiles[this.bottomSelX][this.bottomSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[2][2]);
                tiles[this.topSelX][this.bottomSelY] = new OrderedTile();
                tiles[this.topSelX][this.bottomSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][2].mask));
                tiles[this.topSelX][this.bottomSelY].getPhysicalTile().translate(this.topSelX * 32, this.bottomSelY * 32);
                tiles[this.topSelX][this.bottomSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[0][2]);
                tiles[this.bottomSelX][this.topSelY] = new OrderedTile();
                tiles[this.bottomSelX][this.topSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][0].mask));
                tiles[this.bottomSelX][this.topSelY].getPhysicalTile().translate(this.bottomSelX * 32, this.topSelY * 32);
                tiles[this.bottomSelX][this.topSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[2][0]);
                tiles[this.topSelX][this.topSelY] = new OrderedTile();
                tiles[this.topSelX][this.topSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][0].mask));
                tiles[this.topSelX][this.topSelY].getPhysicalTile().translate(this.topSelX * 32, this.topSelY * 32);
                tiles[this.topSelX][this.topSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[0][0]);
                for (x = this.topSelX + 1; x < this.bottomSelX; ++x) {
                    tiles[x][this.bottomSelY] = new OrderedTile();
                    tiles[x][this.bottomSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][2].mask));
                    tiles[x][this.bottomSelY].getPhysicalTile().translate(x * 32, this.bottomSelY * 32);
                    tiles[x][this.bottomSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[1][2]);
                    tiles[x][this.topSelY] = new OrderedTile();
                    tiles[x][this.topSelY].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][0].mask));
                    tiles[x][this.topSelY].getPhysicalTile().translate(x * 32, this.topSelY * 32);
                    tiles[x][this.topSelY].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[1][0]);
                }
                for (int y2 = this.topSelY + 1; y2 < this.bottomSelY; ++y2) {
                    tiles[this.bottomSelX][y2] = new OrderedTile();
                    tiles[this.bottomSelX][y2].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][1].mask));
                    tiles[this.bottomSelX][y2].getPhysicalTile().translate(this.bottomSelX * 32, y2 * 32);
                    tiles[this.bottomSelX][y2].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[2][1]);
                    tiles[this.topSelX][y2] = new OrderedTile();
                    tiles[this.topSelX][y2].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][1].mask));
                    tiles[this.topSelX][y2].getPhysicalTile().translate(this.topSelX * 32, y2 * 32);
                    tiles[this.topSelX][y2].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[0][1]);
                }
                for (x = this.topSelX + 1; x < this.bottomSelX; ++x) {
                    for (y = this.topSelY + 1; y < this.bottomSelY; ++y) {
                        tiles[x][y] = new OrderedTile();
                        tiles[x][y].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][1].mask));
                        tiles[x][y].getPhysicalTile().translate(x * 32, y * 32);
                        tiles[x][y].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[1][1]);
                    }
                }
                this.topSelX = 0;
                this.bottomSelX = 0;
                this.topSelY = 0;
                this.bottomSelY = 0;
            } else {
                int xlen = this.mouseRelX + tileViewer.getUnclonedSelectedTiles().length > tiles.length ? tiles.length - this.mouseRelX : tileViewer.getUnclonedSelectedTiles().length;
                int ylen = this.mouseRelY + tileViewer.getUnclonedSelectedTiles()[0].length > tiles[0].length ? tiles[0].length - this.mouseRelY : tileViewer.getUnclonedSelectedTiles()[0].length;
                for (int x2 = 0; x2 < xlen; ++x2) {
                    for (int y3 = 0; y3 < ylen; ++y3) {
                        if (this.mouseRelX + x2 < 0 || this.mouseRelY + y3 < 0) continue;
                        tiles[this.mouseRelX + x2][this.mouseRelY + y3] = new OrderedTile();
                        tiles[this.mouseRelX + x2][this.mouseRelY + y3].setPhysicalTile(new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[x2][y3].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[x2][y3].mask));
                        tiles[this.mouseRelX + x2][this.mouseRelY + y3].getPhysicalTile().translate((this.mouseRelX + x2) * 32, (this.mouseRelY + y3) * 32);
                        tiles[this.mouseRelX + x2][this.mouseRelY + y3].setGraphicTile(tileViewer.getUnclonedSelectedTiles()[x2][y3]);
                    }
                }
            }
        }
        if (mouseButton == 3) {
            if (this.checkOutOfBounds()) {
                return;
            }
            for (x = 0; x < this.eraserBrushSize; ++x) {
                for (y = 0; y < this.eraserBrushSize; ++y) {
                    if (this.checkOutOfBounds(x, y) || tiles[this.mouseRelX + x][this.mouseRelY + y] == null) continue;
                    tiles[this.mouseRelX + x][this.mouseRelY + y].nullify();
                }
            }
        }
        LevelEditorScene.updateLayerManagerThumbnail();
    }

    private void handleAnimatedTilePlacement(int mouseButton) {
        OrderedTile[][] tiles = layerManager.isOnBackgroundLayers() ? LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer()) : LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer());
        if (mouseButton == 1) {
            int xlen = this.mouseRelX + animatedTileViewer.getUnclonedSelectedTiles().length > tiles.length ? tiles.length - this.mouseRelX : animatedTileViewer.getUnclonedSelectedTiles().length;
            int ylen = this.mouseRelY + animatedTileViewer.getUnclonedSelectedTiles()[0].length > tiles[0].length ? tiles[0].length - this.mouseRelY : animatedTileViewer.getUnclonedSelectedTiles()[0].length;
            for (int x = 0; x < xlen; ++x) {
                for (int y = 0; y < ylen; ++y) {
                    if (this.mouseRelX + x < 0 || this.mouseRelY + y < 0) continue;
                    tiles[this.mouseRelX + x][this.mouseRelY + y] = new OrderedTile((AnimatedTile)animatedTileViewer.getUnclonedSelectedTiles()[x][y].clone(), new PhysicalTile(LevelEditorScene.animatedTileViewer.getSelectedPhysicalTiles()[x][y].type, LevelEditorScene.animatedTileViewer.getSelectedPhysicalTiles()[x][y].mask));
                    tiles[this.mouseRelX + x][this.mouseRelY + y].getPhysicalTile().translate((this.mouseRelX + x) * 32, (this.mouseRelY + y) * 32);
                }
            }
        }
        if (mouseButton == 3) {
            if (this.checkOutOfBounds()) {
                return;
            }
            for (int x = 0; x < this.eraserBrushSize; ++x) {
                for (int y = 0; y < this.eraserBrushSize; ++y) {
                    if (this.checkOutOfBounds(x, y) || tiles[this.mouseRelX + x][this.mouseRelY + y] == null) continue;
                    tiles[this.mouseRelX + x][this.mouseRelY + y].nullify();
                }
            }
        }
        LevelEditorScene.updateLayerManagerThumbnail();
    }

    private void handleInteractiveTilePlacement(int mouseButton) {
        InteractiveTile[][] iTiles = LevelEditorScene.map.iTiles;
        if (this.checkOutOfBounds()) {
            return;
        }
        if (mouseButton == 1 && interactiveTileViewer.getUnclonedSelectedTile() != null) {
            InteractiveTile tile = interactiveTileViewer.getUnclonedSelectedTile();
            if (tile instanceof AbstractOnOffSwitch) {
                ((AbstractOnOffSwitch)tile).setColorOnOff(map);
            } else if (tile instanceof AbstractOnOffBlock) {
                ((AbstractOnOffBlock)tile).setColorOnOff(map);
            }
            iTiles[this.mouseRelX][this.mouseRelY] = (InteractiveTile)tile.clone();
            iTiles[this.mouseRelX][this.mouseRelY].setMapRelCoords(this.mouseRelX, this.mouseRelY);
        }
        if (mouseButton == 3) {
            for (int x = 0; x < this.eraserBrushSize; ++x) {
                for (int y = 0; y < this.eraserBrushSize; ++y) {
                    if (this.checkOutOfBounds(x, y) || iTiles[this.mouseRelX + x][this.mouseRelY + y] == null) continue;
                    iTiles[this.mouseRelX + x][this.mouseRelY + y] = null;
                }
            }
        }
    }

    private void handleTileTypePlacement(int mouseButton) {
        int l;
        int y;
        int x;
        if (this.checkOutOfBounds()) {
            return;
        }
        if (mouseButton == 1 && tileTypeViewer.getCurrentTileType() != null) {
            for (x = 0; x < this.brushSize; ++x) {
                for (y = 0; y < this.brushSize; ++y) {
                    if (this.checkOutOfBounds(x, y)) continue;
                    for (l = 0; l < LevelEditorScene.map.tilesForeground.size(); ++l) {
                        if (LevelEditorScene.map.tilesForeground.get(l)[this.mouseRelX + x][this.mouseRelY + y] == null) {
                            LevelEditorScene.map.tilesForeground.get((int)l)[this.mouseRelX + x][this.mouseRelY + y] = new OrderedTile();
                        }
                        LevelEditorScene.map.tilesForeground.get(l)[this.mouseRelX + x][this.mouseRelY + y].setPhysicalTile(new PhysicalTile(tileTypeViewer.getCurrentTileType(), PhysicalTile.DEFAULT));
                        LevelEditorScene.map.tilesForeground.get(l)[this.mouseRelX + x][this.mouseRelY + y].getPhysicalTile().translate(this.mouseRelX * 32, this.mouseRelY * 32);
                    }
                    for (l = 0; l < LevelEditorScene.map.tilesBackground.size(); ++l) {
                        if (LevelEditorScene.map.tilesBackground.get(l)[this.mouseRelX + x][this.mouseRelY + y] == null) {
                            LevelEditorScene.map.tilesBackground.get((int)l)[this.mouseRelX + x][this.mouseRelY + y] = new OrderedTile();
                        }
                        LevelEditorScene.map.tilesBackground.get(l)[this.mouseRelX + x][this.mouseRelY + y].setPhysicalTile(new PhysicalTile(tileTypeViewer.getCurrentTileType(), PhysicalTile.DEFAULT));
                        LevelEditorScene.map.tilesBackground.get(l)[this.mouseRelX + x][this.mouseRelY + y].getPhysicalTile().translate(this.mouseRelX * 32, this.mouseRelY * 32);
                    }
                }
            }
        }
        if (mouseButton == 3) {
            for (x = 0; x < this.eraserBrushSize; ++x) {
                for (y = 0; y < this.eraserBrushSize; ++y) {
                    if (this.checkOutOfBounds(x, y)) continue;
                    for (l = 0; l < LevelEditorScene.map.tilesForeground.size(); ++l) {
                        if (LevelEditorScene.map.tilesForeground.get(l)[this.mouseRelX + x][this.mouseRelY + y] == null) continue;
                        LevelEditorScene.map.tilesForeground.get(l)[this.mouseRelX + x][this.mouseRelY + y].setPhysicalTile(null);
                    }
                    for (l = 0; l < LevelEditorScene.map.tilesBackground.size(); ++l) {
                        if (LevelEditorScene.map.tilesBackground.get(l)[this.mouseRelX + x][this.mouseRelY + y] == null) continue;
                        LevelEditorScene.map.tilesBackground.get(l)[this.mouseRelX + x][this.mouseRelY + y].setPhysicalTile(null);
                    }
                }
            }
        }
    }

    private void handleSpawnZonePlacement(int mouseButton) {
        int y;
        int x;
        if (this.checkOutOfBounds()) {
            return;
        }
        if (mouseButton == 1) {
            for (x = 0; x < this.brushSize; ++x) {
                for (y = 0; y < this.brushSize; ++y) {
                    if (this.checkOutOfBounds(x, y)) continue;
                    LevelEditorScene.map.spawnLocs[this.mouseRelX + x][this.mouseRelY + y] = true;
                }
            }
        }
        if (mouseButton == 3) {
            for (x = 0; x < this.eraserBrushSize; ++x) {
                for (y = 0; y < this.eraserBrushSize; ++y) {
                    if (this.checkOutOfBounds(x, y)) continue;
                    LevelEditorScene.map.spawnLocs[this.mouseRelX + x][this.mouseRelY + y] = false;
                }
            }
        }
    }

    private void handleWarpPlacement(int mouseButton) {
        if (this.checkOutOfBounds()) {
            return;
        }
        if (mouseButton == 1) {
            Warp w = (Warp)warpViewer.getUnclonedSelectedWarp().clone();
            w.setRelCoords(this.mouseRelX, this.mouseRelY);
            LevelEditorScene.map.warps[LevelEditorScene.warpViewer.getCurrentColorID()][this.mouseRelX][this.mouseRelY] = w;
        }
        if (mouseButton == 3) {
            for (int i = 0; i < LevelEditorScene.map.warps.length; ++i) {
                for (int x = 0; x < this.eraserBrushSize; ++x) {
                    for (int y = 0; y < this.eraserBrushSize; ++y) {
                        if (this.checkOutOfBounds(x, y)) continue;
                        LevelEditorScene.map.warps[i][this.mouseRelX + x][this.mouseRelY + y] = null;
                    }
                }
            }
        }
    }

    private boolean checkOutOfBounds() {
        return this.checkOutOfBounds(0, 0);
    }

    private boolean checkOutOfBounds(int x, int y) {
        return this.mouseRelX + x >= LevelEditorScene.map.REL_WIDTH || this.mouseRelY + y >= LevelEditorScene.map.REL_HEIGHT || this.mouseRelX < 0 || this.mouseRelY < 0;
    }

    private boolean checkSelectionNull() {
        if (!this.selectionMode) {
            return true;
        }
        return this.topSelX == this.topSelY && this.topSelY == this.bottomSelX && this.bottomSelX == this.bottomSelY;
    }

    private boolean checkSelectionMismatch() {
        if (layerManager.isOnBackgroundLayers()) {
            if (layerManager.getCurrentBackgroundLayer() >= 0) {
                return this.tilesSelected == null;
            }
            if (layerManager.getCurrentBackgroundLayer() == -1) {
                return this.iTilesSelected == null;
            }
            if (layerManager.getCurrentBackgroundLayer() == -2) {
                return this.pTilesSelected == null;
            }
            return true;
        }
        return this.tilesSelected == null;
    }

    /*
     * WARNING - void declaration
     */
    protected void takeScreenshot() {
        void var5_16;
        int l;
        BufferedImage shot = new BufferedImage(1024, 768, 2);
        Graphics2D g2D = shot.createGraphics();
        g2D.setColor(LevelEditorScene.map.bgColor);
        g2D.fillRect(0, 0, LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT);
        if (LevelEditorScene.map.background != null) {
            Rectangle r = new Rectangle(0, 0, LevelEditorScene.map.background.getWidth(), LevelEditorScene.map.background.getHeight());
            Paint paint = g2D.getPaint();
            g2D.setPaint(new TexturePaint(LevelEditorScene.map.background, r));
            g2D.fill(new Rectangle(0, 0, LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT));
            g2D.setPaint(paint);
        }
        for (l = 0; l < LevelEditorScene.map.tilesBackground.size(); ++l) {
            for (int x = 0; x < LevelEditorScene.map.tilesBackground.get(l).length; ++x) {
                for (int i = 0; i < LevelEditorScene.map.tilesBackground.get(l)[x].length; ++i) {
                    if (LevelEditorScene.map.tilesBackground.get(l)[x][i] == null || LevelEditorScene.map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (l = 0; l < LevelEditorScene.map.tilesForeground.size(); ++l) {
            for (int x = 0; x < LevelEditorScene.map.tilesForeground.get(l).length; ++x) {
                for (int i = 0; i < LevelEditorScene.map.tilesForeground.get(l)[x].length; ++i) {
                    if (LevelEditorScene.map.tilesForeground.get(l)[x][i] == null || LevelEditorScene.map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (int x = 0; x < LevelEditorScene.map.iTiles.length; ++x) {
            for (int y2 = 0; y2 < LevelEditorScene.map.iTiles[x].length; ++y2) {
                if (LevelEditorScene.map.iTiles[x][y2] == null) continue;
                g2D.drawImage((Image)LevelEditorScene.map.iTiles[x][y2].tile.getImageAt(0), x * 32, y2 * 32, null);
            }
        }
        Warp[][][] arr$ = LevelEditorScene.map.warps;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_16 < len$) {
            Warp[][] array;
            Warp[][] arr$2 = array = arr$[var5_16];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Warp[] arrayTwo;
                for (Warp w : arrayTwo = arr$2[i$2]) {
                    if (w == null) continue;
                    g2D.drawImage((Image)w.sprite, w.mapRelX * 32, w.mapRelY * 32, null);
                }
            }
            ++var5_16;
        }
        for (Platform platform : LevelEditorScene.map.platforms) {
            int x;
            Point2D.Float startPoint = platform.helper.getStartPoint();
            for (x = 0; x < platform.gTiles.length; ++x) {
                for (int y3 = 0; y3 < platform.gTiles[x].length; ++y3) {
                    if (platform.gTiles[x][y3] == null) continue;
                    g2D.drawImage((Image)platform.gTiles[x][y3].getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y3 * 32, null);
                }
            }
            for (x = 0; x < platform.iTiles.length; ++x) {
                for (int y4 = 0; y4 < platform.iTiles[x].length; ++y4) {
                    if (platform.iTiles[x][y4] == null) continue;
                    g2D.drawImage((Image)platform.iTiles[x][y4].tile.getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y4 * 32, null);
                }
            }
            Shape s = platform.getPath();
            if (s instanceof Line2D) {
                g2D.setColor(Color.RED);
            } else if (s instanceof Ellipse2D) {
                g2D.setColor(Color.GREEN);
            } else if (s instanceof Rectangle) {
                g2D.setColor(Color.BLUE);
            } else if (s instanceof RoundRectangle2D) {
                g2D.setColor(Color.MAGENTA);
            } else if (s instanceof Polygon) {
                g2D.setColor(Color.GRAY);
            }
            g2D.draw(platform.getPath());
        }
        for (Entity entity : LevelEditorScene.map.mapEntities) {
            g2D.drawImage((Image)entity.getImage(), Math.round(entity.entityX), Math.round(entity.entityY), null);
            if (entity instanceof BulletBillEntity) {
                ((BulletBillEntity)entity).drawPath(g2D, map);
            }
            if (entity instanceof Rotodisc) {
                for (Rotodisc.Disc d : ((Rotodisc)entity).discs) {
                    d.drawToScreen(g2D, d.entityX, d.entityY);
                }
            }
            if (!(entity instanceof FireballBar)) continue;
            for (FireballBar.BarFireball b : ((FireballBar)entity).fireballs) {
                b.drawToScreen(g2D, b.entityX, b.entityY);
            }
        }
        g2D.dispose();
        try {
            ImageIO.write((RenderedImage)shot, "png", new File("res/screenshots/" + map.toString() + ".png"));
            this.statusLabel.setText("Took screenshot.");
        }
        catch (IOException e) {
            Logger.getLogger(LOGGER_NAME).log(Level.WARNING, "Error while taking screenshot", e);
            this.statusLabel.setText("An error occured while taking the screenshot. Check log for details");
            e.printStackTrace();
        }
    }

    public static void updateLayerManagerThumbnail() {
        if (layerManager.isOnBackgroundLayers()) {
            LevelEditorScene.updateLayerManagerThumbnail(layerManager.getCurrentBackgroundLayer());
        } else {
            LevelEditorScene.updateLayerManagerThumbnail(layerManager.getCurrentBackgroundLayer());
        }
    }

    public static void updateLayerManagerThumbnail(int l) {
        if (l < 0) {
            return;
        }
        BufferedImage newThumb = new BufferedImage(LevelEditorScene.map.REL_WIDTH, LevelEditorScene.map.REL_HEIGHT, 2);
        Graphics2D g2D = newThumb.createGraphics();
        g2D.scale(0.03125, 0.03125);
        if (layerManager.isOnBackgroundLayers()) {
            for (int x = 0; x < LevelEditorScene.map.tilesBackground.get(l).length; ++x) {
                for (int y = 0; y < LevelEditorScene.map.tilesBackground.get(l)[x].length; ++y) {
                    if (LevelEditorScene.map.tilesBackground.get(l)[x][y] == null || LevelEditorScene.map.tilesBackground.get(l)[x][y].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.tilesBackground.get(l)[x][y].getUnclonedGraphicTile().getImage(), x * 32, y * 32, null);
                }
            }
            LevelEditorScene.layerManager.tileBackgroundButtons.get(LevelEditorScene.layerManager.tileBackgroundButtons.size() - 1 - l).setIcon(newThumb);
        } else {
            for (int x = 0; x < LevelEditorScene.map.tilesForeground.get(l).length; ++x) {
                for (int y = 0; y < LevelEditorScene.map.tilesForeground.get(l)[x].length; ++y) {
                    if (LevelEditorScene.map.tilesForeground.get(l)[x][y] == null || LevelEditorScene.map.tilesForeground.get(l)[x][y].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)LevelEditorScene.map.tilesForeground.get(l)[x][y].getUnclonedGraphicTile().getImage(), x * 32, y * 32, null);
                }
            }
            LevelEditorScene.layerManager.tileForegroundButtons.get(LevelEditorScene.layerManager.tileForegroundButtons.size() - 1 - l).setIcon(newThumb);
        }
    }

    public static void updateToolset() {
        if (!layerManager.isOnBackgroundLayers()) {
            if (layerManager.getCurrentForegroundLayer() >= 0) {
                pane.setVerticalScrollBarPolicy(20);
                pane.setHorizontalScrollBarPolicy(30);
                if (!imageTileMode) {
                    pane.setViewportView(tileViewer);
                } else {
                    pane.setViewportView(animatedTileViewer);
                }
            } else {
                pane.setVerticalScrollBarPolicy(21);
                pane.setHorizontalScrollBarPolicy(31);
                pane.setViewportView(tileTypeViewer);
            }
            pane.validate();
            return;
        }
        if (layerManager.getCurrentBackgroundLayer() >= 0) {
            pane.setVerticalScrollBarPolicy(20);
            pane.setHorizontalScrollBarPolicy(30);
            if (imageTileMode) {
                pane.setViewportView(tileViewer);
            } else {
                pane.setViewportView(animatedTileViewer);
            }
        } else if (layerManager.getCurrentBackgroundLayer() == -1) {
            pane.setVerticalScrollBarPolicy(21);
            pane.setHorizontalScrollBarPolicy(31);
            pane.setViewportView(interactiveTileViewer);
        } else if (layerManager.getCurrentBackgroundLayer() == -2) {
            pane.setVerticalScrollBarPolicy(21);
            pane.setHorizontalScrollBarPolicy(31);
            pane.setViewportView(tileTypeViewer);
        } else if (layerManager.getCurrentBackgroundLayer() == -3) {
            pane.setVerticalScrollBarPolicy(21);
            pane.setHorizontalScrollBarPolicy(31);
            pane.setViewportView(null);
        } else if (layerManager.getCurrentBackgroundLayer() == -4) {
            pane.setVerticalScrollBarPolicy(21);
            pane.setHorizontalScrollBarPolicy(31);
            pane.setViewportView(warpViewer);
        }
        pane.validate();
    }

    public static boolean inImageTileMode() {
        return imageTileMode;
    }

    public static void setImageTileMode(boolean imageTileMode) {
        LevelEditorScene.imageTileMode = imageTileMode;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    static {
        map = null;
    }

    private class ResizeListener
    extends ComponentAdapter {
        LevelEditorScene scene;

        private ResizeListener(LevelEditorScene aThis) {
            this.scene = aThis;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (tabs.getWidth() > LevelEditorScene.map.MAP_WIDTH && tabs.getHeight() > LevelEditorScene.map.MAP_HEIGHT) {
                this.scene.scale = 1.0f;
                this.scene.setPreferredSize(new Dimension(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT));
                this.scene.centeringPanel.setPreferredSize(this.scene.getPreferredSize());
                this.scene.mainFrame.validate();
            } else {
                this.scene.scale = 0.5f;
                this.scene.setPreferredSize(new Dimension(LevelEditorScene.map.MAP_WIDTH / 2, LevelEditorScene.map.MAP_HEIGHT / 2));
                this.scene.centeringPanel.setPreferredSize(this.scene.getPreferredSize());
                this.scene.mainFrame.validate();
            }
        }
    }

    private class TileFXListener
    implements ActionListener {
        private TileFXListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LevelEditorScene.this.selectionMade) {
                GraphicTile[][] tiles = this.getGraphicTiles();
                TileFXDialog log = new TileFXDialog(tiles);
                log.setIconImage(LevelEditorScene.this.windowIcon);
                log.setVisible(true);
            }
        }

        private GraphicTile[][] getGraphicTiles() {
            GraphicTile[][] tilesSelected;
            block8: {
                block6: {
                    block7: {
                        tilesSelected = new GraphicTile[1][1];
                        if (!layerManager.isOnBackgroundLayers()) break block6;
                        if (layerManager.getCurrentBackgroundLayer() < 0) break block7;
                        tilesSelected = new GraphicTile[LevelEditorScene.this.bottomSelX - LevelEditorScene.this.topSelX][LevelEditorScene.this.bottomSelY - LevelEditorScene.this.topSelY];
                        for (int x = 0; x < tilesSelected.length; ++x) {
                            for (int y = 0; y < tilesSelected[x].length; ++y) {
                                if (LevelEditorScene.this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[LevelEditorScene.this.topSelX + x][LevelEditorScene.this.topSelY + y] == null) continue;
                                tilesSelected[x][y] = LevelEditorScene.map.tilesBackground.get(layerManager.getCurrentBackgroundLayer())[LevelEditorScene.this.topSelX + x][LevelEditorScene.this.topSelY + y].getUnclonedGraphicTile();
                            }
                        }
                        break block8;
                    }
                    if (layerManager.getCurrentBackgroundLayer() != -1) break block8;
                    tilesSelected = new InteractiveTile[LevelEditorScene.this.bottomSelX - LevelEditorScene.this.topSelX][LevelEditorScene.this.bottomSelY - LevelEditorScene.this.topSelY];
                    for (int x = 0; x < tilesSelected.length; ++x) {
                        for (int y = 0; y < tilesSelected[x].length; ++y) {
                            if (LevelEditorScene.this.checkOutOfBounds(x, y)) continue;
                            tilesSelected[x][y] = LevelEditorScene.map.iTiles[LevelEditorScene.this.topSelX + x][LevelEditorScene.this.topSelY + y];
                        }
                    }
                    break block8;
                }
                tilesSelected = new GraphicTile[LevelEditorScene.this.bottomSelX - LevelEditorScene.this.topSelX][LevelEditorScene.this.bottomSelY - LevelEditorScene.this.topSelY];
                for (int x = 0; x < tilesSelected.length; ++x) {
                    for (int y = 0; y < tilesSelected[x].length; ++y) {
                        if (LevelEditorScene.this.checkOutOfBounds(x, y) || LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[LevelEditorScene.this.topSelX + x][LevelEditorScene.this.topSelY + y] == null) continue;
                        tilesSelected[x][y] = LevelEditorScene.map.tilesForeground.get(layerManager.getCurrentForegroundLayer())[LevelEditorScene.this.topSelX + x][LevelEditorScene.this.topSelY + y].getUnclonedGraphicTile();
                    }
                }
            }
            return tilesSelected;
        }
    }

    public class MapEntityListener
    implements ActionListener {
        public static final String ADD_ENTITY_COMMAND = "addentity";
        public static final String DELETE_ENTITY_COMMAND = "deleteentity";
        public static final String ENTITY_PROEPRTIES_COMMAND = "entityproperties";
        private JMenu mapEntityMenu;
        private ButtonGroup mapEntityGroup;
        private LinkedList<JMenuItem> mapEntityMenuItems = new LinkedList();
        private int currentEntity = -1;
        private int counter = -1;
        private boolean locationsMode;

        public void setLocationMode(boolean locationMode) {
            this.locationsMode = locationMode;
        }

        public int getCurrentEntityIndex() {
            return this.currentEntity;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            if (s.equals(ADD_ENTITY_COMMAND)) {
                this.createNewMapEntity();
            } else if (s.equals(DELETE_ENTITY_COMMAND)) {
                this.deleteMapEntity(this.currentEntity);
            } else {
                int entity = Integer.parseInt(e.getActionCommand());
                this.changeToEntity(entity);
                extraComponentFrame.add(mapEntityEditor);
                extraComponentFrame.setJMenuBar(mapEntityEditor.getMenuBar());
                extraComponentFrame.pack();
                if (entity != -1) {
                    extraComponentFrame.setVisible(true);
                }
            }
        }

        public void changeToEntity(int entity) {
            this.currentEntity = entity;
            mapEntityEditor.changeToEntity(entity);
        }

        public void createNewMapEntity() {
            new MapEntityEditor.MapEntitySelecter(0.0f, 0.0f).start();
        }

        public void addEntityMenuItem() {
            ++this.counter;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Entity " + this.counter);
            item.setActionCommand(Integer.toString(this.counter));
            item.addActionListener(this);
            this.mapEntityGroup.add(item);
            this.mapEntityMenu.add(item);
            this.mapEntityMenuItems.add(item);
            this.mapEntityMenu.validate();
        }

        public void deleteMapEntity(int number) {
            if (number == -1) {
                return;
            }
            if (LevelEditorScene.map.mapEntities.size() == 0) {
                return;
            }
            LevelEditorScene.map.mapEntities.remove(number);
            this.mapEntityMenu.remove(this.mapEntityMenuItems.get(this.mapEntityMenuItems.size() - 1));
            this.mapEntityGroup.remove(this.mapEntityMenuItems.get(this.mapEntityMenuItems.size() - 1));
            this.mapEntityMenuItems.remove(this.mapEntityMenuItems.size() - 1);
            --this.counter;
            extraComponentFrame.setVisible(false);
        }

        public void resetEntityMenu() {
            while (!this.mapEntityMenuItems.isEmpty()) {
                this.mapEntityMenu.remove(this.mapEntityMenuItems.getLast());
                this.mapEntityGroup.remove(this.mapEntityMenuItems.getLast());
                this.mapEntityMenuItems.removeLast();
            }
            this.currentEntity = -1;
            this.counter = -1;
        }
    }

    public class PlatformListener
    implements ActionListener {
        public static final String ADD_PLATFORM_COMMAND = "addplatform";
        public static final String DELETE_PLATFORM_COMMAND = "deleteplatform";
        private JMenu platformMenu;
        private ButtonGroup platformGroup;
        private LinkedList<JMenuItem> platformMenuItems = new LinkedList();
        private int currentPlatformLayer = -1;
        private int selectedPlatform = 0;
        private int counter = -1;
        private boolean pointSelected;
        private boolean pathMode;

        public void setPathMode(boolean pathMode) {
            this.pathMode = pathMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            if (s.equals(ADD_PLATFORM_COMMAND)) {
                this.createNewPlatform();
            } else if (s.equals(DELETE_PLATFORM_COMMAND)) {
                this.deletePlatform(this.currentPlatformLayer);
            } else {
                int platform = Integer.parseInt(e.getActionCommand());
                this.changeToPlatform(platform);
            }
        }

        public void changeToPlatform(int platform) {
            this.currentPlatformLayer = platform;
            this.selectedPlatform = platform;
        }

        public void createNewPlatform() {
            LevelEditorScene.map.platforms.add(new Platform());
            this.addPlatformMenuItem();
        }

        public void addPlatformMenuItem() {
            ++this.counter;
            Platform p = LevelEditorScene.map.platforms.get(this.counter);
            PlatformEditor ed = new PlatformEditor(p);
            JPanel centeringPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            centeringPanel.add((Component)ed, c);
            tabs.add("Platform " + this.counter, centeringPanel);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Platform " + this.counter);
            item.setActionCommand(Integer.toString(this.counter));
            item.addActionListener(this);
            this.platformGroup.add(item);
            this.platformMenu.add(item);
            this.platformMenuItems.add(item);
            this.platformMenu.validate();
        }

        public void deletePlatform(int number) {
            if (number == -1) {
                return;
            }
            if (LevelEditorScene.map.platforms.size() == 0) {
                return;
            }
            LevelEditorScene.map.platforms.remove(number);
            this.platformMenu.remove(this.platformMenuItems.get(this.platformMenuItems.size() - 1));
            this.platformGroup.remove(this.platformMenuItems.get(this.platformMenuItems.size() - 1));
            this.platformMenuItems.remove(this.platformMenuItems.size() - 1);
            tabs.removeTabAt(number + 1);
            for (int i = 1; i < tabs.getTabCount(); ++i) {
                tabs.setTitleAt(i, "Platform " + (i - 1));
            }
            --this.counter;
        }

        public void resetPlatformMenu() {
            while (!this.platformMenuItems.isEmpty()) {
                this.platformMenu.remove(this.platformMenuItems.getLast());
                this.platformGroup.remove(this.platformMenuItems.getLast());
                this.platformMenuItems.removeLast();
            }
        }
    }

    private class OptionListener
    implements ActionListener {
        public static final String BACKGROUND_COMMAND = "background";
        public static final String BACKGROUND_COLOR_COMMAND = "backgroundcolor";
        public static final String BACKGROUND_MUSIC_COMMAND = "backgroundmusic";
        public static final String EYE_CANDY_COMMAND = "eyecandy";
        public static final String TAG_COMMAND = "tags";
        public static final String TOOLSET_COMMAND = "toolset";

        private OptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            if (s.equals(BACKGROUND_COMMAND)) {
                MapOptionDialog.showMapOptions(MapOptionDialog.Option.BG);
            } else if (s.equals(BACKGROUND_COLOR_COMMAND)) {
                MapOptionDialog.showMapOptions(MapOptionDialog.Option.BGCOLOR);
            } else if (s.equals(BACKGROUND_MUSIC_COMMAND)) {
                MapOptionDialog.showMapOptions(MapOptionDialog.Option.BGM);
            } else if (s.equals(EYE_CANDY_COMMAND)) {
                MapOptionDialog.showMapOptions(MapOptionDialog.Option.CANDY);
            } else if (s.equals(TAG_COMMAND)) {
                MapOptionDialog.showMapOptions(MapOptionDialog.Option.TAG);
            } else if (s.equals(TOOLSET_COMMAND)) {
                LevelEditorScene.updateToolset();
            }
        }
    }

    private class ModeListener
    implements ActionListener {
        public static final String NORMAL_MODE = "normal";
        public static final String SELECT_MODE = "select";
        public static final String PLATFORM_MODE = "platform";
        public static final String ENTITY_MODE = "entity";

        private ModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LevelEditorScene.this.normalModeButton.setSelected(false);
            LevelEditorScene.this.selectModeButton.setSelected(false);
            LevelEditorScene.this.pathModeButton.setSelected(false);
            LevelEditorScene.this.entityModeButton.setSelected(false);
            ((SMWButton)e.getSource()).setSelected(true);
            LevelEditorScene.this.selectionMode = false;
            platformListener.setPathMode(false);
            mapEntityListener.setLocationMode(false);
            if (e.getActionCommand().equals(SELECT_MODE)) {
                LevelEditorScene.this.selectionMode = true;
                LevelEditorScene.this.pasted = false;
                LevelEditorScene.this.selectionMade = false;
                LevelEditorScene.this.topSelX = (LevelEditorScene.this.topSelY = (LevelEditorScene.this.bottomSelX = (LevelEditorScene.this.bottomSelY = 0)));
            } else if (e.getActionCommand().equals(PLATFORM_MODE)) {
                if (LevelEditorScene.map.platforms.size() > 0) {
                    platformListener.setPathMode(true);
                }
            } else if (e.getActionCommand().equals(ENTITY_MODE)) {
                mapEntityListener.setLocationMode(true);
            }
        }
    }

    private class NewMapDialog
    extends JDialog
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = 7046310196944223229L;
        private JTextField mapName;
        private JTextField author;
        private JSpinner width;
        private JSpinner height;
        private JLabel pixelWidth;
        private JLabel pixelHeight;
        private JButton accept;
        private JButton decline;
        private int newWidth;
        private int newHeight;
        private String newName;
        private String newAuthor;
        private LevelEditorScene scene;

        public NewMapDialog(LevelEditorScene scene) {
            this.scene = scene;
            this.setTitle("create a new map...");
            JPanel mainPanel = new JPanel();
            JPanel panel1 = new JPanel();
            JPanel panel2 = new JPanel();
            JPanel panel3 = new JPanel();
            JPanel panel4 = new JPanel();
            JLabel mapLabel = new JLabel("Map name:");
            this.newName = "Untitled Map";
            this.mapName = new JTextField(this.newName);
            this.mapName.addActionListener(this);
            this.mapName.setColumns(20);
            JLabel authorLabel = new JLabel("Author:");
            this.newAuthor = "Anonymous";
            this.author = new JTextField(this.newAuthor);
            this.author.addActionListener(this);
            this.author.setColumns(20);
            Dimension d = new Dimension(mapLabel.getPreferredSize().width + this.mapName.getPreferredSize().width + authorLabel.getPreferredSize().width + this.author.getPreferredSize().width + 32, 36);
            panel1.setPreferredSize(d);
            panel2.setPreferredSize(d);
            panel3.setPreferredSize(d);
            panel4.setPreferredSize(d);
            mainPanel.setPreferredSize(new Dimension(mapLabel.getPreferredSize().width + this.mapName.getPreferredSize().width + authorLabel.getPreferredSize().width + this.author.getPreferredSize().width + 32, 180));
            JLabel widthLabel = new JLabel("width:");
            this.newWidth = Map.DEF_REL_WIDTH;
            this.width = new JSpinner(new SpinnerNumberModel(this.newWidth, 20, this.newWidth, 1));
            this.width.addChangeListener(this);
            JLabel heightLabel = new JLabel("Height:");
            this.newHeight = Map.DEF_REL_HEIGHT;
            this.height = new JSpinner(new SpinnerNumberModel(this.newHeight, 15, this.newHeight, 1));
            this.height.addChangeListener(this);
            this.pixelWidth = new JLabel("Width = 1024 px");
            this.pixelHeight = new JLabel("Height =768px");
            this.accept = new JButton("ok");
            this.accept.addActionListener(this);
            this.decline = new JButton("cancel");
            this.decline.addActionListener(this);
            panel1.add(mapLabel);
            panel1.add(this.mapName);
            panel1.add(authorLabel);
            panel1.add(this.author);
            panel2.add(widthLabel);
            panel2.add(this.width);
            panel2.add(heightLabel);
            panel2.add(this.height);
            panel3.add(this.pixelWidth);
            panel3.add(this.pixelHeight);
            panel4.add(this.accept);
            panel4.add(this.decline);
            mainPanel.add(panel1);
            mainPanel.add(panel2);
            mainPanel.add(panel3);
            mainPanel.add(panel4);
            this.add(mainPanel);
            this.pack();
            this.setResizable(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.mapName)) {
                this.newName = ((JTextField)e.getSource()).getText();
            } else if (e.getSource().equals(this.author)) {
                this.newAuthor = ((JTextField)e.getSource()).getText();
            } else if (e.getSource().equals(this.accept)) {
                map = new Map(this.newWidth, this.newHeight);
                LevelEditorScene.map.mapName = this.newName;
                LevelEditorScene.map.creatorName = this.newAuthor;
                LevelEditorScene.map.background = map.getBackground();
                layerManager.reloadTileLayerButtons();
                pane.setVerticalScrollBarPolicy(20);
                pane.setHorizontalScrollBarPolicy(30);
                if (imageTileMode) {
                    pane.setViewportView(tileViewer);
                } else {
                    pane.setViewportView(animatedTileViewer);
                }
                LevelEditorScene.recalculateMapImages();
                this.scene.scale = 0.5f;
                this.scene.setPreferredSize(new Dimension(LevelEditorScene.map.MAP_WIDTH / 2, LevelEditorScene.map.MAP_HEIGHT / 2));
                this.scene.setSize(this.getPreferredSize());
                this.scene.centeringPanel.setPreferredSize(this.getPreferredSize());
                this.scene.validate();
                this.scene.centeringPanel.validate();
                this.scene.mainFrame.validate();
                this.dispose();
            } else {
                this.dispose();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source = (JSpinner)e.getSource();
            if (source.equals(this.width)) {
                this.newWidth = (Integer)source.getValue();
            } else {
                this.newHeight = (Integer)source.getValue();
            }
            this.pixelWidth.setText("Width = " + this.newWidth * 32 + " px");
            this.pixelHeight.setText("Height = " + this.newHeight * 32 + " px");
        }
    }
}

