/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Flamethrower;
import com.dmgame.entity.KuriboShoe;
import com.dmgame.entity.PiranhaPlant;
import com.dmgame.entity.Rotodisc;
import com.dmgame.entity.Spike;
import com.dmgame.entity.Spring;
import com.dmgame.entity.ThrowBox;
import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class MapEntityEditor
extends EditorComponent {
    private static final long serialVersionUID = -1976387344240081373L;
    private final Dimension EDITOR_DIM = new Dimension(256, 256);
    private final Dimension LAYOUT_DIM = new Dimension(256, 64);
    private EditableEntity currentEntity;
    private JMenuBar menuBar;
    private JPanel contentPanel = new JPanel();

    public MapEntityEditor() {
        this.contentPanel.setBorder(new LineBorder(Color.BLACK));
        this.contentPanel.setPreferredSize(this.LAYOUT_DIM);
        this.add(this.contentPanel);
        this.validate();
        this.setPreferredSize(this.EDITOR_DIM);
        this.setupMenuBar();
        this.setupEntityComponents();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void setupMenuBar() {
        this.menuBar = new JMenuBar();
        if (this.currentEntity != null && this.currentEntity.menuOptions != null) {
            for (JMenu m : this.currentEntity.menuOptions) {
                this.menuBar.add(m);
            }
        }
        this.menuBar.validate();
    }

    private void setupEntityComponents() {
        for (Component component : this.contentPanel.getComponents()) {
            this.contentPanel.remove(component);
        }
        if (this.currentEntity != null) {
            if (this.currentEntity.layout != null) {
                this.contentPanel.setLayout(this.currentEntity.layout);
            } else {
                this.contentPanel.setLayout(new FlowLayout());
            }
            if (this.currentEntity.components != null) {
                for (Component component : this.currentEntity.components) {
                    this.contentPanel.add(component);
                }
            }
        }
        this.contentPanel.validate();
    }

    public void reset(final EditableEntity currentEntity) {
        this.currentEntity = currentEntity;
        currentEntity.setSwingComponents();
        this.setupMenuBar();
        this.setupEntityComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LevelEditorScene.map.mapEntities.add(currentEntity);
                LevelEditorScene.mapEntityListener.addEntityMenuItem();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(Color.LIGHT_GRAY);
            g2D.fill(new Rectangle(this.EDITOR_DIM));
            BufferedImage draw = this.currentEntity instanceof Rotodisc ? ((Rotodisc)this.currentEntity).discs.get(0).getImage() : (this.currentEntity instanceof FireballBar ? ((FireballBar)this.currentEntity).fireballs.get(0).getImage() : this.currentEntity.getImage());
            int width = draw.getWidth();
            int height = draw.getHeight();
            g2D.drawImage((Image)draw, (int)((this.EDITOR_DIM.getWidth() - (double)width) / 2.0), (int)((this.EDITOR_DIM.getHeight() - (double)height) / 2.0), null);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.currentEntity != null) {
            this.currentEntity.update(timePassed);
        }
    }

    public void changeToEntity(int entity) {
        if (LevelEditorScene.mapEntityListener.getCurrentEntityIndex() != -1) {
            this.currentEntity = LevelEditorScene.map.mapEntities.get(LevelEditorScene.mapEntityListener.getCurrentEntityIndex());
        }
        this.currentEntity.setSwingComponents();
        this.setupMenuBar();
        this.setupEntityComponents();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.currentEntity instanceof MouseListener) {
            ((MouseListener)((Object)this.currentEntity)).mousePressed(e);
        }
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.currentEntity instanceof MouseListener) {
            ((MouseListener)((Object)this.currentEntity)).mouseReleased(e);
        }
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentEntity instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.currentEntity)).mouseDragged(e);
        }
        e.consume();
    }

    @Override
    public void run() {
        try {
            long startTime;
            long totalTime = startTime = System.currentTimeMillis();
            while (LevelEditorScene.isRunning()) {
                long timePassed = System.currentTimeMillis() - totalTime;
                totalTime += timePassed;
                this.update(timePassed);
                Thread.sleep(16L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class MapEntitySelecter
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -1790629956666069880L;
        private static final Dimension BUTTON_DIM = new Dimension(96, 64);
        public static JButton[] entitiesButtons = MapEntitySelecter.setupEntities();
        public static final byte FIREBALL_BAR = 0;
        public static final byte ROTODISC = 1;
        public static final byte BULLET_BILL = 2;
        public static final byte FLAMETHROWER = 3;
        public static final byte PIRHANA_PLANT = 4;
        public static final byte SPRING = 5;
        public static final byte SPIKE = 6;
        public static final byte KURIBO_SHOE = 7;
        public static final byte THROW_BOX = 8;
        public byte currentEntityID;
        private JFrame holdingFrame;
        private float xPos;
        private float yPos;

        public MapEntitySelecter(float xPos, float yPos) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setLayout(new GridLayout(3, 3));
            for (JButton b : entitiesButtons) {
                for (ActionListener a : b.getActionListeners()) {
                    b.removeActionListener(a);
                }
                b.setPreferredSize(BUTTON_DIM);
                b.addActionListener(this);
                this.add(b);
            }
            this.currentEntityID = (byte)-1;
        }

        protected static JButton[] setupEntities() {
            JButton[] toReturn = new JButton[9];
            try {
                ImageIcon buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/projectiles/fireball.png")));
                JButton entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)0));
                toReturn[0] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/hazards/rotodisc.png")).getSubimage(0, 0, 32, 32));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)1));
                toReturn[1] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/powerups/bulletbill.png")));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)2));
                toReturn[2] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/hazards/flamethrower.png")).getSubimage(0, 0, 96, 32));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)3));
                toReturn[3] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/hazards/redpiranhaplant.png")).getSubimage(0, 0, 32, 48));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)4));
                toReturn[4] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/mapobjects/greenspring.png")).getSubimage(0, 0, 32, 32));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)5));
                toReturn[5] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/mapobjects/spike.png")));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)6));
                toReturn[6] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/mapobjects/greenkuriboshoe.png")).getSubimage(0, 0, 32, 32));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)7));
                toReturn[7] = entityButton;
                buttonIcon = new ImageIcon(ImageIO.read(new File("res/gfx/packs/Default/mapobjects/throwbox.png")).getSubimage(0, 0, 32, 32));
                entityButton = new JButton(buttonIcon);
                entityButton.setActionCommand(Byte.toString((byte)8));
                toReturn[8] = entityButton;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return toReturn;
        }

        public void start() {
            this.holdingFrame = new JFrame("Select An Entity");
            this.holdingFrame.setResizable(false);
            this.holdingFrame.setDefaultCloseOperation(2);
            this.holdingFrame.add(this);
            this.holdingFrame.pack();
            this.holdingFrame.setLocation(4, 4);
            this.holdingFrame.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.currentEntityID = Byte.parseByte(e.getActionCommand());
            LevelEditorScene.mapEntityEditor.reset(this.getCurrentEntity());
            this.holdingFrame.dispose();
        }

        public EditableEntity getCurrentEntity() {
            switch (this.currentEntityID) {
                case 0: {
                    return new FireballBar(this.xPos, this.yPos, true);
                }
                case 1: {
                    return new Rotodisc(this.xPos, this.yPos, true);
                }
                case 2: {
                    return new BulletBillEntity(this.xPos, this.yPos, true);
                }
                case 3: {
                    return new Flamethrower(this.xPos, this.yPos, true);
                }
                case 4: {
                    return new PiranhaPlant(this.xPos, this.yPos, true);
                }
                case 5: {
                    return new Spring(this.xPos, this.yPos, true);
                }
                case 6: {
                    return new Spike(this.xPos, this.yPos, true);
                }
                case 7: {
                    return new KuriboShoe(this.xPos, this.yPos, true);
                }
                case 8: {
                    return new ThrowBox(this.xPos, this.yPos, true);
                }
            }
            return null;
        }
    }
}

