/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.Map;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MapOptionDialog
extends JDialog {
    private static final long serialVersionUID = 6285394441711600426L;
    private static MapOptionDialog optionDialog;
    private JTabbedPane optionsPane;
    private BackgroundChooser bgChooser;
    private JColorChooser bgColorChooser;
    private JScrollPane pane;
    private MusicChooser bgmChooser;
    private EyeCandyChooser candyChooser;
    private TagCreator tagCreator;

    private MapOptionDialog() {
        this.setResizable(false);
        this.optionsPane = new JTabbedPane();
        this.bgChooser = new BackgroundChooser();
        this.pane = new JScrollPane(this.bgChooser);
        this.pane.setPreferredSize(new Dimension(320, 240));
        this.pane.getVerticalScrollBar().setUnitIncrement(120);
        this.optionsPane.addTab("Background", this.pane);
        this.bgColorChooser = new JColorChooser();
        this.bgColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DefaultColorSelectionModel model = (DefaultColorSelectionModel)e.getSource();
                LevelEditorScene.map.bgColor = model.getSelectedColor();
            }
        });
        this.bgColorChooser.setColor(LevelEditorScene.map.bgColor);
        this.optionsPane.addTab("BG Color", this.bgColorChooser);
        this.bgmChooser = new MusicChooser();
        this.optionsPane.addTab("Music", this.bgmChooser);
        this.candyChooser = new EyeCandyChooser();
        this.optionsPane.addTab("Eye Candy", this.candyChooser);
        this.tagCreator = new TagCreator();
        this.optionsPane.addTab("Tags", this.tagCreator);
        this.setTitle("Map Options");
        this.setLocation(4, 4);
        this.add(this.optionsPane);
        this.pack();
    }

    public static void showMapOptions(Option o) {
        if (optionDialog == null) {
            optionDialog = new MapOptionDialog();
        }
        switch (o) {
            case BG: {
                MapOptionDialog.optionDialog.optionsPane.setSelectedIndex(0);
                break;
            }
            case BGCOLOR: {
                MapOptionDialog.optionDialog.optionsPane.setSelectedIndex(1);
                break;
            }
            case BGM: {
                MapOptionDialog.optionDialog.optionsPane.setSelectedIndex(2);
                break;
            }
            case CANDY: {
                MapOptionDialog.optionDialog.optionsPane.setSelectedIndex(3);
                break;
            }
            case TAG: {
                MapOptionDialog.optionDialog.optionsPane.setSelectedIndex(4);
            }
        }
        optionDialog.setVisible(true);
        optionDialog.requestFocus();
    }

    public static void updateTags() {
        if (optionDialog == null) {
            optionDialog = new MapOptionDialog();
        }
        MapOptionDialog.optionDialog.tagCreator.updateTags();
    }

    public static void updateToCurrentMap() {
        if (optionDialog == null) {
            optionDialog = new MapOptionDialog();
        }
        MapOptionDialog.optionDialog.bgChooser.updateToMap(LevelEditorScene.map);
        MapOptionDialog.optionDialog.bgColorChooser.setColor(LevelEditorScene.map.bgColor);
        MapOptionDialog.optionDialog.bgmChooser.updateToMap(LevelEditorScene.map);
        optionDialog.remove(MapOptionDialog.optionDialog.candyChooser);
        optionDialog.resetEyecandy();
    }

    private void resetEyecandy() {
        this.optionsPane.removeTabAt(3);
        this.optionsPane.removeTabAt(3);
        this.candyChooser = new EyeCandyChooser();
        this.optionsPane.addTab("Eye Candy", this.candyChooser);
        this.optionsPane.addTab("Tags", this.tagCreator);
    }

    private class TagCreator
    extends JPanel {
        private static final long serialVersionUID = 4585584712379571965L;
        private DefaultListModel<String> listModel;
        private JList<String> list;
        private JTextField text;
        private JButton addButton;
        private JButton removeButton;

        public TagCreator() {
            this.setLayout(new BorderLayout(24, 24));
            this.listModel = new DefaultListModel();
            for (String s : LevelEditorScene.userTags) {
                this.listModel.addElement(s);
            }
            this.list = new JList<String>(this.listModel);
            this.list.setSelectionMode(2);
            this.add(this.list, "Before");
            JPanel container = new JPanel();
            container.setLayout(new GridLayout(3, 1, 10, 100));
            this.text = new JTextField();
            this.addButton = new JButton("add tag");
            ActionListener a = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LevelEditorScene.userTags.add(TagCreator.this.text.getText());
                    TagCreator.this.listModel.addElement(TagCreator.this.text.getText());
                    TagCreator.this.text.setText("");
                }
            };
            this.text.addActionListener(a);
            this.addButton.addActionListener(a);
            this.removeButton = new JButton("remove selected tags");
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (String o : TagCreator.this.list.getSelectedValuesList()) {
                        TagCreator.this.listModel.removeElement(o);
                        LevelEditorScene.userTags.remove(o);
                    }
                }
            });
            container.add(this.text);
            container.add(this.addButton);
            container.add(this.removeButton);
            this.add((Component)container, "After");
        }

        private void updateTags() {
            this.listModel.removeAllElements();
            for (String s : LevelEditorScene.userTags) {
                this.listModel.addElement(s);
            }
        }
    }

    private class EyeCandyChooser
    extends JPanel {
        private static final long serialVersionUID = -2830496583918019611L;
        private BufferedImage previews;

        public EyeCandyChooser() {
            try {
                this.setLayout(new GridLayout(LevelEditorScene.map.eyeCandyValues.size(), 3));
                this.previews = ImageIO.read(new File("res/gfx/leveleditor/eyecandypreviews.png"));
                BufferedImage cloud = this.previews.getSubimage(0, 0, 32, 32);
                BufferedImage fish = this.previews.getSubimage(32, 0, 32, 32);
                BufferedImage leaf = this.previews.getSubimage(64, 0, 32, 32);
                BufferedImage ghost = this.previews.getSubimage(96, 0, 32, 32);
                BufferedImage bubble = this.previews.getSubimage(128, 0, 32, 32);
                BufferedImage rain = this.previews.getSubimage(160, 0, 32, 32);
                BufferedImage snow = this.previews.getSubimage(192, 0, 32, 32);
                this.addRow(cloud, "cloud");
                this.addRow(fish, "fish");
                this.addRow(leaf, "leaf");
                this.addRow(ghost, "ghost");
                this.addRow(bubble, "bubble");
                this.addRow(rain, "rain");
                this.addRow(snow, "snow");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void addRow(BufferedImage rowImage, String key) {
            int sliderNum = LevelEditorScene.map.eyeCandyValues.containsKey(key) ? (int)(LevelEditorScene.map.eyeCandyValues.get(key).floatValue() * 100.0f) : 50;
            JSlider slider = new JSlider(0, 100, sliderNum);
            JLabel sliderLabel = new JLabel(sliderNum + "%");
            slider.addChangeListener(new SliderChangeListener(sliderLabel, key));
            this.add(new JLabel(new ImageIcon(rowImage)));
            this.add(slider);
            this.add(sliderLabel);
        }

        private class SliderChangeListener
        implements ChangeListener {
            private final JLabel sliderValue;
            private String value;

            public SliderChangeListener(JLabel sliderValue, String value) {
                this.sliderValue = sliderValue;
                this.value = value;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                this.sliderValue.setText(slider.getValue() + "%");
                LevelEditorScene.map.eyeCandyValues.put(this.value, Float.valueOf((float)slider.getValue() / 100.0f));
            }
        }
    }

    private class MusicChooser
    extends JPanel {
        private static final long serialVersionUID = 3463279349209738091L;
        private JList<String> categories;

        public MusicChooser() {
            this.setLayout(new BorderLayout());
            JButton chooseFileButton = new JButton("Choose a specific music file");
            chooseFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File base = new File("res/music/game/");
                    JFileChooser chooser = new JFileChooser(base);
                    if (chooser.showOpenDialog(MapOptionDialog.this.optionsPane) == 0) {
                        File f = chooser.getSelectedFile();
                        LevelEditorScene.map.specificSong = f.getPath().replace(base.getAbsolutePath(), "").replace("\\", "/");
                    } else {
                        LevelEditorScene.map.specificSong = null;
                    }
                }
            });
            JLabel label = new JLabel("Music categories:");
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String s : Map.MUSIC_CATEGORIES) {
                model.addElement(s);
            }
            this.categories = new JList(model);
            this.categories.setSelectedIndex(model.indexOf(LevelEditorScene.map.musicCategory));
            this.categories.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LevelEditorScene.map.musicCategory = (String)MusicChooser.this.categories.getSelectedValue();
                }
            });
            this.add((Component)chooseFileButton, "Last");
            this.add((Component)label, "First");
            this.add(this.categories, "Center");
        }

        private void updateToMap(Map map) {
            this.categories.setSelectedValue(map.musicCategory, false);
        }
    }

    private class BackgroundChooser
    extends JSplitPane
    implements TreeSelectionListener {
        private static final long serialVersionUID = 8216760652983967861L;
        private final String NO_BG = "No Background";
        private BufferedImage currentImage;
        private DefaultMutableTreeNode treeParent;
        private JTree tree;
        private double scale;
        private JLabel backgroundPreview;

        public BackgroundChooser() {
            super(1);
            this.NO_BG = "No Background";
            this.scale = 0.5;
            File parent = new File("res/gfx/backgrounds");
            this.treeParent = new DefaultMutableTreeNode("Backgrounds");
            this.treeParent.add(new DefaultMutableTreeNode("No Background"));
            for (File dir : parent.listFiles()) {
                if (!dir.isDirectory() || dir.getAbsolutePath().contains(".svn")) continue;
                DefaultMutableTreeNode branch = new DefaultMutableTreeNode(dir.getName());
                this.treeParent.add(branch);
                for (File f : dir.listFiles()) {
                    if (f.getName().endsWith(".svn") || f.getName().endsWith(".db")) continue;
                    branch.add(new DefaultMutableTreeNode(f.getName()));
                }
            }
            this.tree = new JTree(this.treeParent);
            this.tree.addTreeSelectionListener(this);
            this.backgroundPreview = new JLabel();
            this.backgroundPreview.setPreferredSize(new Dimension((int)((double)LevelEditorScene.map.MAP_WIDTH * this.scale), (int)((double)LevelEditorScene.map.MAP_HEIGHT * this.scale)));
            this.add((Component)this.tree, 0);
            this.add((Component)this.backgroundPreview, 1);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object[] treePath = null;
            try {
                treePath = e.getNewLeadSelectionPath().getPath();
            }
            catch (NullPointerException ex) {
                return;
            }
            String[] path = new String[treePath.length];
            for (int i = 0; i < treePath.length; ++i) {
                path[i] = (String)((DefaultMutableTreeNode)treePath[i]).getUserObject();
            }
            if (path[path.length - 1].equals("No Background")) {
                this.currentImage = null;
                LevelEditorScene.map.backgroundName = null;
                LevelEditorScene.map.background = null;
                this.backgroundPreview.setIcon(null);
            }
            String imagePath = "res/gfx/backgrounds/";
            if (!path[path.length - 1].contains(".")) {
                return;
            }
            for (int i = 1; i < path.length; ++i) {
                imagePath = imagePath + path[i];
                if (i == path.length - 1) continue;
                imagePath = imagePath + "/";
            }
            try {
                this.currentImage = ImageIO.read(new File(imagePath));
                LevelEditorScene.map.backgroundName = path[path.length - 2] + "/" + path[path.length - 1];
                LevelEditorScene.map.background = this.currentImage;
                this.backgroundPreview.setIcon(new ImageIcon(this.currentImage.getScaledInstance((int)((double)this.currentImage.getWidth() * this.scale), (int)((double)this.currentImage.getHeight() * this.scale), 2)));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private void updateToMap(Map map) {
            block0: for (int i = 0; i < this.treeParent.getChildCount(); ++i) {
                DefaultMutableTreeNode cat = (DefaultMutableTreeNode)this.treeParent.getChildAt(i);
                String s = (String)cat.getUserObject();
                if (s.contains("No Background") && map.backgroundName == null) {
                    this.tree.expandPath(new TreePath(cat.getPath()));
                    this.tree.setSelectionPath(new TreePath(cat.getPath()));
                    break;
                }
                for (int j = 0; j < cat.getChildCount(); ++j) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)cat.getChildAt(j);
                    s = (String)node.getUserObject();
                    if (!map.backgroundName.contains(s)) continue;
                    TreePath path = new TreePath(node.getPath());
                    this.tree.expandPath(new TreePath(cat.getPath()));
                    this.tree.setSelectionPath(path);
                    break block0;
                }
            }
        }
    }

    public static enum Option {
        BG,
        BGCOLOR,
        BGM,
        CANDY,
        TAG;

    }
}

