/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.map.Map;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class MapViewAccessory
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = -2722137209850393673L;
    private File displayMap;
    private final int SCALE = 4;
    private JLabel authorLabel;
    private JTextField authorField;
    private boolean savingMap;

    public MapViewAccessory(JFileChooser chooser, boolean savingMap, Map map) {
        this.savingMap = savingMap;
        this.authorLabel = new JLabel();
        this.authorField = map != null ? new JTextField(map.creatorName) : new JTextField("Anonymous");
        this.setLayout(new BorderLayout());
        this.add((Component)new MapDrawer(), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JSeparator(), "North");
        bottomPanel.add((Component)this.authorLabel, "Before");
        if (savingMap) {
            this.authorLabel.setText("Author: ");
            bottomPanel.add((Component)this.authorField, "Center");
        }
        this.add((Component)bottomPanel, "South");
        this.setPreferredSize(new Dimension(256, 192 + this.authorLabel.getHeight()));
        chooser.addPropertyChangeListener(this);
    }

    public String getAuthor() {
        return this.authorField.getText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.displayMap = (File)evt.getNewValue();
            if (this.displayMap == null || !this.displayMap.getPath().contains(".map")) {
                this.displayMap = null;
                if (!this.savingMap) {
                    this.authorLabel.setText("");
                }
            }
        }
        this.repaint();
    }

    private class MapDrawer
    extends JComponent {
        private static final long serialVersionUID = 3254079583715047342L;

        public MapDrawer() {
            this.setPreferredSize(new Dimension(256, 192));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (MapViewAccessory.this.displayMap == null) {
                return;
            }
            Graphics2D g2D = (Graphics2D)g;
            try {
                g2D.drawImage((Image)ImageIO.read(new File("res/maps/cache/" + MapViewAccessory.this.displayMap.getName().substring(0, MapViewAccessory.this.displayMap.getName().length() - 4) + ".png")), 0, 0, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

