/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.ImageTile;
import com.dmgame.map.PhysicalTile;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class MaskEditor
extends EditorComponent
implements ActionListener {
    private static final long serialVersionUID = 3465180141378014429L;
    private ImageTile currentGTile;
    private AnimatedTile currentATile;
    private PhysicalTile currentPTile;
    private Polygon polyMask = new Polygon();
    private Rectangle rectMask;
    private Ellipse2D circleMask;
    private JPopupMenu menu;
    private JRadioButtonMenuItem polyButton;
    private JRadioButtonMenuItem rectButton;
    private JRadioButtonMenuItem ellipseButton;
    private JMenuItem clearItem;
    private LinkedList<Point> points;
    private int index;
    private Mode mode = Mode.POLYGON;
    public static final String SHOW_MASKS_COMMAND = "show masks";
    private final String POLYGON_COMMAND = "polygon";
    private final String RECTANGLE_COMMAND = "rectangle";
    private final String ELLIPSE_COMMAND = "ellipse";
    private final String CLEAR_COMMAND = "clear";

    public MaskEditor() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.points = new LinkedList();
        this.points.add(new Point(0, 0));
        this.points.add(new Point(32, 32));
        this.points.add(new Point(0, 32));
        this.rectMask = new Rectangle(0, 0, 32, 32);
        this.circleMask = new Ellipse2D.Double(0.0, 0.0, 32.0, 32.0);
        this.index = -1;
        this.setPreferredSize(new Dimension(128, 128));
        this.setupMenu();
        this.changeTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][0], LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][0]);
    }

    private void setupMenu() {
        this.menu = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        this.polyButton = new JRadioButtonMenuItem("Polygon Mode");
        this.polyButton.setSelected(true);
        this.polyButton.setActionCommand("polygon");
        this.polyButton.addActionListener(this);
        group.add(this.polyButton);
        this.menu.add(this.polyButton);
        this.rectButton = new JRadioButtonMenuItem("Rectangle Mode");
        this.rectButton.setActionCommand("rectangle");
        this.rectButton.addActionListener(this);
        group.add(this.rectButton);
        this.menu.add(this.rectButton);
        this.ellipseButton = new JRadioButtonMenuItem("Ellipse Mode");
        this.ellipseButton.setActionCommand("ellipse");
        this.ellipseButton.addActionListener(this);
        group.add(this.ellipseButton);
        this.menu.add(this.ellipseButton);
        this.menu.add(new JSeparator());
        this.clearItem = new JMenuItem("Clear Mask");
        this.clearItem.setActionCommand("clear");
        this.clearItem.addActionListener(this);
        this.menu.add(this.clearItem);
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        this.saveMaskData();
    }

    public void saveMaskData() {
        if (this.currentPTile == null) {
            return;
        }
        if (LevelEditorScene.inImageTileMode()) {
            Shape mask = null;
            switch (this.mode) {
                case POLYGON: {
                    mask = this.polyMask;
                    break;
                }
                case RECTANGLE: {
                    mask = this.rectMask;
                    break;
                }
                case ELLIPSE: {
                    mask = this.circleMask;
                }
            }
            this.currentPTile.mask = mask;
        } else {
            Shape mask = null;
            switch (this.mode) {
                case POLYGON: {
                    mask = this.polyMask;
                    break;
                }
                case RECTANGLE: {
                    mask = this.rectMask;
                    break;
                }
                case ELLIPSE: {
                    mask = this.circleMask;
                }
            }
            this.currentPTile.mask = mask;
        }
    }

    private int getPointSelection() {
        double smallest = 3.0;
        int pointIndex = -1;
        for (int i = 0; i < this.points.size(); ++i) {
            if (!(this.points.get(i).distance(this.mouseRelX, this.mouseRelY) < smallest)) continue;
            smallest = this.points.get(i).distance(this.mouseRelX, this.mouseRelY);
            pointIndex = i;
        }
        return pointIndex;
    }

    private void addClosestPoint() {
        double smallest = 32.0;
        int closeIndex = -1;
        Point mousePoint = new Point(this.mouseRelX, this.mouseRelY);
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Line2D.Double l = new Line2D.Double(this.points.get(i), this.points.get(i + 1));
            if (!(l.ptLineDist(mousePoint) < smallest)) continue;
            smallest = l.ptSegDist(mousePoint);
            closeIndex = i + 1;
        }
        Line2D.Double l = new Line2D.Double(this.points.get(this.points.size() - 1), this.points.get(0));
        if (l.ptLineDist(mousePoint) < smallest) {
            smallest = l.ptSegDist(mousePoint);
            closeIndex = this.points.size();
        }
        this.points.add(closeIndex, mousePoint);
        this.index = closeIndex;
    }

    public void changeTile(PhysicalTile tile, ImageTile gTile) {
        if (tile == null) {
            return;
        }
        if (tile.mask instanceof Polygon) {
            this.mode = Mode.POLYGON;
            this.polyButton.setSelected(true);
            this.polyMask = (Polygon)tile.mask;
            this.points.clear();
            for (int i = 0; i < this.polyMask.npoints; ++i) {
                this.points.add(new Point(this.polyMask.xpoints[i], this.polyMask.ypoints[i]));
            }
            if (this.points.isEmpty()) {
                this.clearMasks();
            }
        } else if (tile.mask instanceof Rectangle) {
            this.mode = Mode.RECTANGLE;
            this.rectButton.setSelected(true);
            Rectangle r = (Rectangle)tile.mask;
            this.rectMask = (Rectangle)r.clone();
        } else if (tile.mask instanceof Ellipse2D) {
            this.mode = Mode.ELLIPSE;
            this.ellipseButton.setSelected(true);
            Ellipse2D e = (Ellipse2D)tile.mask;
            this.circleMask = (Ellipse2D)e.clone();
        }
        this.repaint();
        this.currentPTile = tile;
        this.currentGTile = gTile;
    }

    public void changeTile(PhysicalTile tile, AnimatedTile aTile) {
        if (tile == null) {
            return;
        }
        if (tile.mask instanceof Polygon) {
            this.mode = Mode.POLYGON;
            this.polyButton.setSelected(true);
            Polygon p = (Polygon)tile.mask;
            this.points.clear();
            for (int i = 0; i < p.npoints; ++i) {
                this.points.add(new Point(p.xpoints[i], p.ypoints[i]));
            }
            if (this.points.isEmpty()) {
                this.clearMasks();
            }
        } else if (tile.mask instanceof Rectangle) {
            this.mode = Mode.RECTANGLE;
            this.rectButton.setSelected(true);
            Rectangle r = (Rectangle)tile.mask;
            this.rectMask = (Rectangle)r.clone();
        } else if (tile.mask instanceof Ellipse2D) {
            this.mode = Mode.ELLIPSE;
            this.ellipseButton.setSelected(true);
            Ellipse2D e = (Ellipse2D)tile.mask;
            this.circleMask = (Ellipse2D)e.clone();
        }
        this.currentPTile = tile;
        this.currentATile = aTile;
        this.repaint();
    }

    public void updateMask() {
        if (this.mode == Mode.POLYGON) {
            int[] xcoords = new int[this.points.size()];
            int[] ycoords = new int[this.points.size()];
            for (int i = 0; i < this.points.size(); ++i) {
                xcoords[i] = this.points.get((int)i).x;
                ycoords[i] = this.points.get((int)i).y;
            }
            if (this.currentPTile != null) {
                this.currentPTile.mask = new Polygon(xcoords, ycoords, this.points.size());
            }
        } else if (this.mode == Mode.RECTANGLE) {
            this.currentPTile.mask = new Rectangle(this.rectMask.x, this.rectMask.y, this.rectMask.width, this.rectMask.height);
        } else if (this.mode == Mode.ELLIPSE) {
            Rectangle r = this.circleMask.getBounds();
            this.currentPTile.mask = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.scale(4.0, 4.0);
        if (LevelEditorScene.inImageTileMode() && this.currentGTile != null) {
            g2D.drawImage((Image)this.currentGTile.tile, 0, 0, null);
        } else if (!LevelEditorScene.inImageTileMode() && this.currentATile != null) {
            g2D.drawImage((Image)this.currentATile.tile.getImage(), 0, 0, null);
        }
        g2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
        g2D.setColor(Color.RED);
        if (this.mode == Mode.POLYGON) {
            int x;
            for (x = 0; x < this.points.size() - 1; ++x) {
                g2D.drawLine(this.points.get((int)x).x, this.points.get((int)x).y, this.points.get((int)(x + 1)).x, this.points.get((int)(x + 1)).y);
            }
            g2D.drawLine(this.points.get((int)0).x, this.points.get((int)0).y, this.points.get((int)x).x, this.points.get((int)x).y);
            g2D.setColor(Color.GREEN);
            for (Point p : this.points) {
                g2D.fillOval(p.x - 2, p.y - 2, 4, 4);
            }
        } else if (this.mode == Mode.RECTANGLE) {
            g2D.fill(this.rectMask);
            g2D.setColor(Color.GREEN);
            g2D.fillOval(this.rectMask.x - 2, this.rectMask.y - 2, 4, 4);
            g2D.setColor(Color.BLUE);
            g2D.fillOval(this.rectMask.x + this.rectMask.width - 2, this.rectMask.y + this.rectMask.height - 2, 4, 4);
        } else if (this.mode == Mode.ELLIPSE) {
            g2D.fill(this.circleMask);
            g2D.draw(this.circleMask.getBounds());
            Rectangle r = this.circleMask.getBounds();
            g2D.setColor(Color.GREEN);
            g2D.fillOval(r.x - 2, r.y - 2, 4, 4);
            g2D.setColor(Color.BLUE);
            g2D.fillOval(r.x + r.width - 2, r.y + r.height - 2, 4, 4);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mouseRelX = (int)Math.floor(this.mouseX / 4);
        if (this.mouseRelX < 0) {
            this.mouseRelX = 0;
        }
        if (this.mouseRelX > 32) {
            this.mouseRelX = 32;
        }
        this.mouseRelY = (int)Math.floor(this.mouseY / 4);
        if (this.mouseRelY < 0) {
            this.mouseRelY = 0;
        }
        if (this.mouseRelY > 32) {
            this.mouseRelY = 32;
        }
        this.index = this.getPointSelection();
        if (this.mode == Mode.POLYGON && this.index == -1) {
            this.addClosestPoint();
        }
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
        if (this.mode == Mode.POLYGON && e.getButton() == 3 && this.index != -1 && this.points.size() > 3) {
            this.points.remove(this.index);
        }
        if (this.mode == Mode.POLYGON) {
            int[] xcoords = new int[this.points.size()];
            int[] ycoords = new int[this.points.size()];
            for (int i = 0; i < this.points.size(); ++i) {
                xcoords[i] = this.points.get((int)i).x;
                ycoords[i] = this.points.get((int)i).y;
            }
            this.polyMask = new Polygon(xcoords, ycoords, this.points.size());
        }
        e.consume();
        this.index = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkPopup(e);
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mouseRelX = (int)Math.floor(this.mouseX / 4);
        if (this.mouseRelX < 0) {
            this.mouseRelX = 0;
        }
        if (this.mouseRelX > 32) {
            this.mouseRelX = 32;
        }
        this.mouseRelY = (int)Math.floor(this.mouseY / 4);
        if (this.mouseRelY < 0) {
            this.mouseRelY = 0;
        }
        if (this.mouseRelY > 32) {
            this.mouseRelY = 32;
        }
        if (this.index != -1 && this.mode == Mode.POLYGON) {
            this.points.get(this.index).setLocation(this.mouseRelX, this.mouseRelY);
        } else if (this.mode == Mode.RECTANGLE) {
            Point origin = new Point(this.rectMask.x, this.rectMask.y);
            Point diag = new Point(this.rectMask.x + this.rectMask.width, this.rectMask.y + this.rectMask.height);
            if (origin.distance(this.mouseRelX, this.mouseRelY) < diag.distance(this.mouseRelX, this.mouseRelY)) {
                this.rectMask.x = this.mouseRelX;
                this.rectMask.y = e.isControlDown() ? this.rectMask.x : this.mouseRelY;
                if (this.rectMask.width + this.rectMask.x > 32) {
                    this.rectMask.width = 32 - this.rectMask.x;
                }
                if (this.rectMask.height + this.rectMask.y > 32) {
                    this.rectMask.height = 32 - this.rectMask.y;
                }
            } else {
                int width = this.mouseRelX - this.rectMask.x;
                this.rectMask.width = width > 0 ? width : 0;
                int height = e.isControlDown() ? this.rectMask.width : this.mouseRelY - this.rectMask.y;
                this.rectMask.height = height > 0 ? height : 0;
            }
        } else if (this.mode == Mode.ELLIPSE) {
            Rectangle r = this.circleMask.getBounds();
            Point origin = new Point(r.x, r.y);
            Point diag = new Point(r.x + r.width, r.y + r.height);
            if (origin.distance(this.mouseRelX, this.mouseRelY) < diag.distance(this.mouseRelX, this.mouseRelY)) {
                r.x = this.mouseRelX;
                r.y = e.isControlDown() ? r.x : this.mouseRelY;
                if (r.width + r.x > 32) {
                    r.width = 32 - r.x;
                }
                if (r.height + r.y > 32) {
                    r.height = 32 - r.y;
                }
            } else {
                int width = this.mouseRelX - r.x;
                r.width = width > 0 ? width : 0;
                int height = e.isControlDown() ? r.width : this.mouseRelY - r.y;
                r.height = height > 0 ? height : 0;
            }
            this.circleMask.setFrame(r);
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("polygon")) {
            this.mode = Mode.POLYGON;
        } else if (s.equals("rectangle")) {
            this.mode = Mode.RECTANGLE;
        } else if (s.equals("ellipse")) {
            this.mode = Mode.ELLIPSE;
        } else if (s.equals("clear")) {
            this.clearMasks();
        }
        this.repaint();
    }

    private void clearMasks() {
        switch (this.mode) {
            case POLYGON: {
                this.points.clear();
                this.points.add(new Point(0, 0));
                this.points.add(new Point(32, 32));
                this.points.add(new Point(0, 32));
                int[] xcoords = new int[this.points.size()];
                int[] ycoords = new int[this.points.size()];
                for (int i = 0; i < this.points.size(); ++i) {
                    xcoords[i] = this.points.get((int)i).x;
                    ycoords[i] = this.points.get((int)i).y;
                }
                this.polyMask = new Polygon(xcoords, ycoords, this.points.size());
                break;
            }
            case RECTANGLE: {
                this.rectMask = new Rectangle(0, 0, 32, 32);
                break;
            }
            case ELLIPSE: {
                this.circleMask = new Ellipse2D.Double(0.0, 0.0, 32.0, 32.0);
            }
        }
    }

    @Override
    public void run() {
        try {
            while (LevelEditorScene.isRunning()) {
                this.update(0L);
                Thread.sleep(16L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static enum Mode {
        POLYGON,
        RECTANGLE,
        ELLIPSE;

    }
}

