/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.interactivetiles.AbstractOnOffBlock;
import com.dmgame.map.interactivetiles.AbstractOnOffSwitch;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlatformEditor
extends JPanel
implements ActionListener,
ChangeListener,
Runnable {
    private static final long serialVersionUID = 1035124008035346432L;
    public static final Dimension EDITOR_DIM = new Dimension(LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT);
    private double scale = 0.5;
    private BufferedImage linearImage;
    private BufferedImage ellipseImage;
    private BufferedImage rectangleImage;
    private BufferedImage roundRectImage;
    private BufferedImage freeformImage;
    private boolean dragging;
    private boolean rightClick;
    private int topSelX;
    private int topSelY;
    private int bottomSelX;
    private int bottomSelY;
    private Platform currentPlatform;
    private Point2D.Double resizePoint;
    private boolean resizeMode;
    private JSpinner speedSpinner;
    private JSpinner startSpinner;
    public final String REVERSE_COMMAND = "reverse";
    public final String LINEAR_COMMAND = "linear";
    public final String ELLIPSE_COMMAND = "ellipse";
    public final String RECTANGLE_COMMAND = "rectangle";
    public final String ROUND_RECTANGLE_COMMAND = "round rectangle";
    public final String FREEFORM_COMMAND = "freeform";
    private PlatformDisplay disp;

    public PlatformEditor(Platform p) {
        try {
            this.linearImage = ImageIO.read(new File("res/gfx/leveleditor/linemode.png"));
            this.ellipseImage = ImageIO.read(new File("res/gfx/leveleditor/ellipsemode.png"));
            this.rectangleImage = ImageIO.read(new File("res/gfx/leveleditor/rectanglemode.png"));
            this.roundRectImage = ImageIO.read(new File("res/gfx/leveleditor/roundrectanglemode.png"));
            this.freeformImage = ImageIO.read(new File("res/gfx/leveleditor/freeformmode.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentPlatform = p;
        this.setLayout(new BorderLayout());
        this.disp = new PlatformDisplay();
        this.add((Component)this.setupControlPanel(), "First");
        this.add((Component)this.disp, "Center");
        this.dragging = false;
        this.rightClick = false;
        this.bottomSelY = 0;
        this.bottomSelX = 0;
        this.topSelY = 0;
        this.topSelX = 0;
        this.resizeMode = false;
        this.setPreferredSize(new Dimension((int)((double)LevelEditorScene.map.MAP_WIDTH * this.scale), (int)((double)LevelEditorScene.map.MAP_HEIGHT * this.scale)));
        this.resizePoint = new Point2D.Double(this.currentPlatform.pTiles.length * 32, this.currentPlatform.pTiles[0].length * 32);
        LevelEditorScene.tabs.addKeyListener(this.disp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("reverse")) {
            this.currentPlatform.setDirection(!this.currentPlatform.getDirection());
            JCheckBox source = (JCheckBox)e.getSource();
            source.setSelected(this.currentPlatform.getDirection());
        }
        Rectangle s = this.currentPlatform.getPath().getBounds();
        if (str.equals("linear")) {
            this.currentPlatform.setPath(new Line2D.Double(s.x, s.y, s.x + s.width, s.y + s.height));
        } else if (str.equals("ellipse")) {
            this.currentPlatform.setPath(new Ellipse2D.Double(s.x, s.y, s.width, s.height));
        } else if (str.equals("rectangle")) {
            this.currentPlatform.setPath(new Rectangle(s.x, s.y, s.width, s.height));
        } else if (str.equals("round rectangle")) {
            this.currentPlatform.setPath(new RoundRectangle2D.Double(s.x, s.y, s.width, s.height, 64.0, 64.0));
        } else if (str.equals("freeform")) {
            this.currentPlatform.setPath(new Polygon(new int[]{s.x, s.x + s.width, s.x + s.width}, new int[]{s.y, s.y + s.height, s.y}, 3));
        }
        this.currentPlatform.setPathIterator();
    }

    private JPanel setupControlPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Speed:"));
        this.speedSpinner = new JSpinner(new SpinnerNumberModel(this.currentPlatform.speed, 0.0, 1000.0, 5.0));
        this.speedSpinner.addChangeListener(this);
        panel.add(this.speedSpinner);
        panel.add(new JLabel("Start:"));
        this.startSpinner = new JSpinner(new SpinnerNumberModel(this.currentPlatform.startTime * 100.0, 0.0, 100.0, 5.0));
        this.startSpinner.addChangeListener(this);
        panel.add(this.startSpinner);
        JCheckBox box = new JCheckBox("Reverse");
        box.setActionCommand("reverse");
        box.addActionListener(this);
        panel.add(box);
        Dimension preferredDim = new Dimension(20, 20);
        ButtonGroup group = new ButtonGroup();
        JToggleButton button = new JToggleButton(new ImageIcon(this.linearImage));
        button.setPreferredSize(preferredDim);
        button.setActionCommand("linear");
        button.addActionListener(this);
        if (this.currentPlatform.getPath() instanceof Line2D) {
            button.setSelected(true);
        }
        group.add(button);
        panel.add(button);
        button = new JToggleButton(new ImageIcon(this.ellipseImage));
        button.setPreferredSize(preferredDim);
        button.setActionCommand("ellipse");
        button.addActionListener(this);
        if (this.currentPlatform.getPath() instanceof Ellipse2D) {
            button.setSelected(true);
        }
        group.add(button);
        panel.add(button);
        button = new JToggleButton(new ImageIcon(this.rectangleImage));
        button.setPreferredSize(preferredDim);
        button.setActionCommand("rectangle");
        button.addActionListener(this);
        if (this.currentPlatform.getPath() instanceof Rectangle) {
            button.setSelected(true);
        }
        group.add(button);
        panel.add(button);
        button = new JToggleButton(new ImageIcon(this.roundRectImage));
        button.setPreferredSize(preferredDim);
        button.setActionCommand("round rectangle");
        button.addActionListener(this);
        if (this.currentPlatform.getPath() instanceof RoundRectangle2D) {
            button.setSelected(true);
        }
        group.add(button);
        panel.add(button);
        button = new JToggleButton(new ImageIcon(this.freeformImage));
        button.setPreferredSize(preferredDim);
        button.setActionCommand("freeform");
        button.addActionListener(this);
        if (this.currentPlatform.getPath() instanceof Polygon) {
            button.setSelected(true);
        }
        group.add(button);
        panel.add(button);
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner source = (JSpinner)e.getSource();
        if (source == this.speedSpinner) {
            this.currentPlatform.speed = (Double)source.getValue();
        } else {
            this.currentPlatform.startTime = (Double)source.getValue() / 100.0;
        }
        this.currentPlatform.setPathIterator();
    }

    @Override
    public void run() {
        this.disp.run();
    }

    private class PlatformDisplay
    extends EditorComponent
    implements KeyListener {
        private static final long serialVersionUID = -839306416960068634L;

        public PlatformDisplay() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            int y;
            int x;
            super.paintComponent(g);
            Graphics2D g2D = (Graphics2D)g;
            g2D.scale(PlatformEditor.this.scale, PlatformEditor.this.scale);
            g2D.setColor(Color.DARK_GRAY);
            g2D.fillRect(0, 0, LevelEditorScene.map.MAP_WIDTH, LevelEditorScene.map.MAP_HEIGHT);
            g2D.setColor(Color.LIGHT_GRAY);
            g2D.fillRect(0, 0, ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles.length * 32, ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles[0].length * 32);
            for (x = 0; x < ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles.length; ++x) {
                for (y = 0; y < ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles[0].length; ++y) {
                    if (((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles[x][y] == null) continue;
                    g2D.drawImage((Image)((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles[x][y].getImage(), x * 32, y * 32, null);
                }
            }
            for (int i = 0; i < ((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles.length; ++i) {
                for (int j = 0; j < ((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles[i].length; ++j) {
                    if (((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles[i][j] == null) continue;
                    g2D.drawImage((Image)((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles[i][j].tile.getImage(), i * 32, j * 32, null);
                }
            }
            g2D.setColor(Color.GREEN);
            if (!PlatformEditor.this.rightClick && PlatformEditor.this.dragging && LevelEditorScene.tileViewer.getUnclonedSelectedTiles() != null && LevelEditorScene.tileViewer.getUnclonedSelectedTiles().length == 3 && LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][2].tile, PlatformEditor.this.bottomSelX * 32, PlatformEditor.this.bottomSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][2].tile, PlatformEditor.this.topSelX * 32, PlatformEditor.this.bottomSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][0].tile, PlatformEditor.this.bottomSelX * 32, PlatformEditor.this.topSelY * 32, null);
                g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][0].tile, PlatformEditor.this.topSelX * 32, PlatformEditor.this.topSelY * 32, null);
                for (x = PlatformEditor.this.topSelX + 1; x < PlatformEditor.this.bottomSelX; ++x) {
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][0].tile, x * 32, PlatformEditor.this.topSelY * 32, null);
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][2].tile, x * 32, PlatformEditor.this.bottomSelY * 32, null);
                }
                for (int y2 = PlatformEditor.this.topSelY + 1; y2 < PlatformEditor.this.bottomSelY; ++y2) {
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][1].tile, PlatformEditor.this.topSelX * 32, y2 * 32, null);
                    g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][1].tile, PlatformEditor.this.bottomSelX * 32, y2 * 32, null);
                }
                for (x = PlatformEditor.this.topSelX + 1; x < PlatformEditor.this.bottomSelX; ++x) {
                    for (y = PlatformEditor.this.topSelY + 1; y < PlatformEditor.this.bottomSelY; ++y) {
                        g2D.drawImage((Image)LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][1].tile, x * 32, y * 32, null);
                    }
                }
            }
            g2D.drawImage(LevelEditorScene.brightNodeImage, null, (int)(((PlatformEditor)PlatformEditor.this).resizePoint.x - (double)(LevelEditorScene.brightNodeImage.getWidth() / 2)), (int)(((PlatformEditor)PlatformEditor.this).resizePoint.y - (double)(LevelEditorScene.brightNodeImage.getHeight() / 2)));
            if (this.mouseInWindow) {
                g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
            }
            if (LevelEditorScene.layerManager.getCurrentBackgroundLayer() == -2) {
                g2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
                for (x = 0; x < ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles.length; ++x) {
                    for (y = 0; y < ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles[0].length; ++y) {
                        if (((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles[x][y] == null) continue;
                        g2D.drawImage((Image)LevelEditorScene.tileTypeViewer.getTileTypeSubimage(((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles[x][y].type), x * 32, y * 32, null);
                    }
                }
            }
        }

        @Override
        public void update(long timePassed) {
            super.update(timePassed);
            if (PlatformEditor.this.currentPlatform != null) {
                GraphicTile[] array;
                int i$;
                GraphicTile[][] arr$ = ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    for (GraphicTile gTile : array = arr$[i$]) {
                        if (gTile == null || !(gTile instanceof AnimatedTile)) continue;
                        ((AnimatedTile)gTile).update(timePassed);
                    }
                }
                arr$ = ((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    for (GraphicTile iTile : array = arr$[i$]) {
                        if (iTile == null) continue;
                        ((InteractiveTile)iTile).update(timePassed);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PlatformEditor.this.rightClick = e.getButton() == 3;
            LevelEditorScene.tabs.requestFocus();
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int mouseButton = e.getButton();
            PlatformEditor.this.rightClick = false;
            PlatformEditor.this.dragging = false;
            if (PlatformEditor.this.resizeMode) {
                PlatformEditor.this.resizeMode = false;
                e.consume();
                return;
            }
            switch (LevelEditorScene.layerManager.getCurrentBackgroundLayer()) {
                case -1: {
                    this.handleInteractiveTilePlacement(mouseButton);
                    break;
                }
                case -2: {
                    this.handleTileTypePlacement(mouseButton);
                    break;
                }
                default: {
                    if (LevelEditorScene.inImageTileMode()) {
                        this.handleImageTilePlacement(mouseButton);
                        break;
                    }
                    this.handleAnimatedTilePlacement(mouseButton);
                }
            }
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseX = (int)((double)e.getX() / PlatformEditor.this.scale);
            this.mouseY = (int)((double)e.getY() / PlatformEditor.this.scale);
            this.mouseRelX = (int)Math.floor(this.mouseX / 32);
            this.mouseRelY = (int)Math.floor(this.mouseY / 32);
            PlatformEditor.this.dragging = true;
            Ellipse2D.Double resizeArea = new Ellipse2D.Double(((PlatformEditor)PlatformEditor.this).resizePoint.x - 8.0, ((PlatformEditor)PlatformEditor.this).resizePoint.y - 8.0, 16.0, 16.0);
            resizeArea.setFrame(resizeArea.getX(), resizeArea.getY(), resizeArea.getWidth(), resizeArea.getHeight());
            if (PlatformEditor.this.resizeMode || resizeArea.contains((double)e.getX() / PlatformEditor.this.scale, (double)e.getY() / PlatformEditor.this.scale)) {
                PlatformEditor.this.resizeMode = true;
                double scaleAmount = 32.0;
                int width = (int)((double)e.getX() / scaleAmount / PlatformEditor.this.scale) - ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles.length;
                int height = (int)((double)e.getY() / scaleAmount / PlatformEditor.this.scale) - ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles[0].length;
                PlatformEditor.this.currentPlatform.alterSize(width, height);
                PlatformEditor.this.resizePoint.setLocation(((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles.length * 32, ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles[0].length * 32);
                this.repaint();
                return;
            }
            if (PlatformEditor.this.rightClick) {
                switch (LevelEditorScene.layerManager.getCurrentBackgroundLayer()) {
                    case -2: {
                        this.handleTileTypePlacement(3);
                        break;
                    }
                    default: {
                        if (LevelEditorScene.inImageTileMode()) {
                            this.handleImageTilePlacement(3);
                            break;
                        }
                        this.handleAnimatedTilePlacement(3);
                        break;
                    }
                }
            } else if (LevelEditorScene.layerManager.getCurrentBackgroundLayer() >= 0 && LevelEditorScene.inImageTileMode() && LevelEditorScene.tileViewer.getUnclonedSelectedTiles().length == 3 && LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
                PlatformEditor.this.topSelX = this.mouseRelX > e.getX() / 32 ? e.getX() / 32 : this.mouseRelX;
                PlatformEditor.this.topSelY = this.mouseRelY > e.getY() / 32 ? e.getY() / 32 : this.mouseRelY;
                PlatformEditor.this.bottomSelX = this.mouseRelX < e.getX() / 32 ? e.getX() / 32 : this.mouseRelX;
                PlatformEditor.this.bottomSelY = this.mouseRelY < e.getY() / 32 ? e.getY() / 32 : this.mouseRelY;
                if (PlatformEditor.this.bottomSelX > LevelEditorScene.map.REL_WIDTH - 1) {
                    PlatformEditor.this.bottomSelX = LevelEditorScene.map.REL_WIDTH - 1;
                }
                if (PlatformEditor.this.bottomSelY > LevelEditorScene.map.REL_HEIGHT - 1) {
                    PlatformEditor.this.bottomSelY = LevelEditorScene.map.REL_HEIGHT - 1;
                }
            } else if (e.isShiftDown()) {
                switch (LevelEditorScene.layerManager.getCurrentBackgroundLayer()) {
                    case -2: {
                        this.handleTileTypePlacement(1);
                        break;
                    }
                    default: {
                        if (LevelEditorScene.inImageTileMode()) {
                            this.handleImageTilePlacement(1);
                            break;
                        }
                        this.handleAnimatedTilePlacement(1);
                    }
                }
            }
            this.repaint();
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseX = (int)((double)e.getX() / PlatformEditor.this.scale);
            this.mouseY = (int)((double)e.getY() / PlatformEditor.this.scale);
            this.mouseRelX = (int)Math.floor(this.mouseX / 32);
            this.mouseRelY = (int)Math.floor(this.mouseY / 32);
            this.repaint();
        }

        private void handleTileTypePlacement(int mouseButton) {
            PhysicalTile[][] pTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles;
            if (mouseButton == 1 && LevelEditorScene.tileTypeViewer.getCurrentTileType() != null) {
                if (pTiles[this.mouseRelX][this.mouseRelY] != null) {
                    pTiles[this.mouseRelX][this.mouseRelY].type = LevelEditorScene.tileTypeViewer.getCurrentTileType();
                } else {
                    pTiles[this.mouseRelX][this.mouseRelY] = new PhysicalTile(LevelEditorScene.tileTypeViewer.getCurrentTileType(), new Rectangle(0, 0, 32, 32));
                    pTiles[this.mouseRelX][this.mouseRelY].translate(this.mouseRelX * 32, this.mouseRelY * 32);
                }
            }
            if (mouseButton == 3) {
                pTiles[this.mouseRelX][this.mouseRelY] = null;
            }
        }

        private void handleInteractiveTilePlacement(int mouseButton) {
            InteractiveTile[][] iTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.iTiles;
            if (mouseButton == 1 && LevelEditorScene.interactiveTileViewer.getUnclonedSelectedTile() != null) {
                InteractiveTile tile = LevelEditorScene.interactiveTileViewer.getUnclonedSelectedTile();
                if (tile instanceof AbstractOnOffSwitch) {
                    ((AbstractOnOffSwitch)tile).setColorOnOff(PlatformEditor.this.currentPlatform);
                } else if (tile instanceof AbstractOnOffBlock) {
                    ((AbstractOnOffBlock)tile).setColorOnOff(PlatformEditor.this.currentPlatform);
                }
                iTiles[this.mouseRelX][this.mouseRelY] = (InteractiveTile)tile.clone();
                iTiles[this.mouseRelX][this.mouseRelY].setMapRelCoords(this.mouseRelX, this.mouseRelY);
            }
            if (mouseButton == 3) {
                iTiles[this.mouseRelX][this.mouseRelY] = null;
            }
        }

        private void handleAnimatedTilePlacement(int mouseButton) {
            PhysicalTile[][] pTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles;
            GraphicTile[][] gTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles;
            int xOffset = PlatformEditor.this.currentPlatform.getCurrentX();
            int yOffset = PlatformEditor.this.currentPlatform.getCurrentY();
            if (mouseButton == 1) {
                int xlen = this.mouseRelX + LevelEditorScene.animatedTileViewer.getUnclonedSelectedTiles().length > pTiles.length ? pTiles.length - this.mouseRelX : LevelEditorScene.animatedTileViewer.getUnclonedSelectedTiles().length;
                int ylen = this.mouseRelY + LevelEditorScene.animatedTileViewer.getUnclonedSelectedTiles()[0].length > pTiles[0].length ? pTiles[0].length - this.mouseRelY : LevelEditorScene.animatedTileViewer.getUnclonedSelectedTiles()[0].length;
                for (int x = 0; x < xlen; ++x) {
                    for (int y = 0; y < ylen; ++y) {
                        if (this.mouseRelX + x < 0 || this.mouseRelY + y < 0) continue;
                        pTiles[this.mouseRelX + x][this.mouseRelY + y] = new PhysicalTile(LevelEditorScene.animatedTileViewer.getSelectedPhysicalTiles()[x][y].type, LevelEditorScene.animatedTileViewer.getSelectedPhysicalTiles()[x][y].mask);
                        pTiles[this.mouseRelX + x][this.mouseRelY + y].translate(xOffset + (this.mouseRelX + x) * 32, yOffset + (this.mouseRelY + y) * 32);
                        gTiles[this.mouseRelX + x][this.mouseRelY + y] = (AnimatedTile)LevelEditorScene.animatedTileViewer.getUnclonedSelectedTiles()[x][y].clone();
                    }
                }
            }
            if (mouseButton == 3) {
                pTiles[this.mouseRelX][this.mouseRelY] = null;
                gTiles[this.mouseRelX][this.mouseRelY] = null;
            }
        }

        private void handleImageTilePlacement(int mouseButton) {
            PhysicalTile[][] pTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.pTiles;
            GraphicTile[][] gTiles = ((PlatformEditor)PlatformEditor.this).currentPlatform.gTiles;
            int xOffset = PlatformEditor.this.currentPlatform.getCurrentX();
            int yOffset = PlatformEditor.this.currentPlatform.getCurrentY();
            if (mouseButton == 1) {
                if (PlatformEditor.this.bottomSelX - PlatformEditor.this.topSelX > 0 && PlatformEditor.this.bottomSelY - PlatformEditor.this.topSelY > 0 && LevelEditorScene.tileViewer.getUnclonedSelectedTiles().length == 3 && LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0].length == 3) {
                    int x;
                    pTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][((PlatformEditor)PlatformEditor.this).bottomSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][2].mask);
                    pTiles[PlatformEditor.this.bottomSelX][PlatformEditor.this.bottomSelY].translate(PlatformEditor.this.bottomSelX * 32, PlatformEditor.this.bottomSelY * 32);
                    gTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][((PlatformEditor)PlatformEditor.this).bottomSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][2];
                    pTiles[((PlatformEditor)PlatformEditor.this).topSelX][((PlatformEditor)PlatformEditor.this).bottomSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][2].mask);
                    pTiles[PlatformEditor.this.topSelX][PlatformEditor.this.bottomSelY].translate(xOffset + PlatformEditor.this.topSelX * 32, yOffset + PlatformEditor.this.bottomSelY * 32);
                    gTiles[((PlatformEditor)PlatformEditor.this).topSelX][((PlatformEditor)PlatformEditor.this).bottomSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][2];
                    pTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][((PlatformEditor)PlatformEditor.this).topSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][0].mask);
                    pTiles[PlatformEditor.this.bottomSelX][PlatformEditor.this.topSelY].translate(xOffset + PlatformEditor.this.bottomSelX * 32, yOffset + PlatformEditor.this.topSelY * 32);
                    gTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][((PlatformEditor)PlatformEditor.this).topSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][0];
                    pTiles[((PlatformEditor)PlatformEditor.this).topSelX][((PlatformEditor)PlatformEditor.this).topSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][0].mask);
                    pTiles[PlatformEditor.this.topSelX][PlatformEditor.this.topSelY].translate(xOffset + PlatformEditor.this.topSelX * 32, yOffset + PlatformEditor.this.topSelY * 32);
                    gTiles[((PlatformEditor)PlatformEditor.this).topSelX][((PlatformEditor)PlatformEditor.this).topSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][0];
                    for (x = PlatformEditor.this.topSelX + 1; x < PlatformEditor.this.bottomSelX; ++x) {
                        pTiles[x][((PlatformEditor)PlatformEditor.this).bottomSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][2].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][2].mask);
                        pTiles[x][PlatformEditor.this.bottomSelY].translate(x * 32, PlatformEditor.this.bottomSelY * 32);
                        gTiles[x][((PlatformEditor)PlatformEditor.this).bottomSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][2];
                        pTiles[x][((PlatformEditor)PlatformEditor.this).topSelY] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][0].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][0].mask);
                        pTiles[x][PlatformEditor.this.topSelY].translate(xOffset + x * 32, yOffset + PlatformEditor.this.topSelY * 32);
                        gTiles[x][((PlatformEditor)PlatformEditor.this).topSelY] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][0];
                    }
                    for (int y = PlatformEditor.this.topSelY + 1; y < PlatformEditor.this.bottomSelY; ++y) {
                        pTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][y] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[2][1].mask);
                        pTiles[PlatformEditor.this.bottomSelX][y].translate(xOffset + PlatformEditor.this.bottomSelX * 32, yOffset + y * 32);
                        gTiles[((PlatformEditor)PlatformEditor.this).bottomSelX][y] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[2][1];
                        pTiles[((PlatformEditor)PlatformEditor.this).topSelX][y] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[0][1].mask);
                        pTiles[PlatformEditor.this.topSelX][y].translate(xOffset + PlatformEditor.this.topSelX * 32, yOffset + y * 32);
                        gTiles[((PlatformEditor)PlatformEditor.this).topSelX][y] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0][1];
                    }
                    for (x = PlatformEditor.this.topSelX + 1; x < PlatformEditor.this.bottomSelX; ++x) {
                        for (int y = PlatformEditor.this.topSelY + 1; y < PlatformEditor.this.bottomSelY; ++y) {
                            pTiles[x][y] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][1].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[1][1].mask);
                            pTiles[x][y].translate(xOffset + x * 32, yOffset + y * 32);
                            gTiles[x][y] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[1][1];
                        }
                    }
                    PlatformEditor.this.topSelX = 0;
                    PlatformEditor.this.bottomSelX = 0;
                    PlatformEditor.this.topSelY = 0;
                    PlatformEditor.this.bottomSelY = 0;
                } else {
                    int xlen = this.mouseRelX + LevelEditorScene.tileViewer.getUnclonedSelectedTiles().length > pTiles.length ? pTiles.length - this.mouseRelX : LevelEditorScene.tileViewer.getUnclonedSelectedTiles().length;
                    int ylen = this.mouseRelY + LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0].length > pTiles[0].length ? pTiles[0].length - this.mouseRelY : LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[0].length;
                    for (int x = 0; x < xlen; ++x) {
                        for (int y = 0; y < ylen; ++y) {
                            if (this.mouseRelX + x < 0 || this.mouseRelY + y < 0) continue;
                            pTiles[this.mouseRelX + x][this.mouseRelY + y] = new PhysicalTile(LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[x][y].type, LevelEditorScene.tileViewer.getSelectedPhysicalTiles()[x][y].mask);
                            pTiles[this.mouseRelX + x][this.mouseRelY + y].translate(xOffset + (this.mouseRelX + x) * 32, yOffset + (this.mouseRelY + y) * 32);
                            gTiles[this.mouseRelX + x][this.mouseRelY + y] = LevelEditorScene.tileViewer.getUnclonedSelectedTiles()[x][y];
                        }
                    }
                }
            }
            if (mouseButton == 3) {
                try {
                    pTiles[this.mouseRelX][this.mouseRelY] = null;
                    gTiles[this.mouseRelX][this.mouseRelY] = null;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return;
                }
            }
        }

        @Override
        public void run() {
            try {
                long startTime;
                long totalTime = startTime = System.currentTimeMillis();
                while (LevelEditorScene.isRunning()) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    this.update(timePassed);
                    Thread.sleep(16L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                switch (e.getKeyCode()) {
                    case 37: {
                        PlatformEditor.this.currentPlatform.shiftTiles(0);
                        break;
                    }
                    case 39: {
                        PlatformEditor.this.currentPlatform.shiftTiles(1);
                        break;
                    }
                    case 38: {
                        PlatformEditor.this.currentPlatform.shiftTiles(2);
                        break;
                    }
                    case 40: {
                        PlatformEditor.this.currentPlatform.shiftTiles(3);
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

