/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.graphics.TileFX;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.ImageTile;
import com.dmgame.map.InteractiveTile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TileFXDialog
extends JDialog {
    private static final long serialVersionUID = -3070039587878583591L;
    private GraphicTile[][] editTiles;
    private TileFX.FXType currentType;
    private TileFX currentFX;
    private JComponent displayComponent;
    private JComponent editComponent;

    public TileFXDialog(GraphicTile[][] tiles) {
        this.setTitle("TileFX");
        this.setLocation(4, 4);
        this.editTiles = tiles;
        this.setLayout(new BorderLayout());
        final JPanel secondComponent = new JPanel();
        secondComponent.setLayout(new BorderLayout());
        JList<TileFX.FXType> fxTypes = new JList<TileFX.FXType>(TileFX.FXType.values());
        fxTypes.setSelectedIndex(0);
        this.changeFXtype(TileFX.FXType.RECOLOR, secondComponent);
        fxTypes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TileFX.FXType type = (TileFX.FXType)((Object)((JList)e.getSource()).getSelectedValue());
                TileFXDialog.this.changeFXtype(type, secondComponent);
            }
        });
        this.add(fxTypes, "West");
        this.add((Component)secondComponent, "East");
        this.pack();
        this.displayComponent.repaint();
    }

    private void changeFXtype(TileFX.FXType type, JComponent secondComponent) {
        GraphicTile[] array;
        int i$;
        if (type == this.currentType) {
            return;
        }
        this.currentType = type;
        GraphicTile[][] arr$ = this.editTiles;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (GraphicTile tile : array = arr$[i$]) {
                if (tile == null) continue;
                if (tile instanceof ImageTile) {
                    ((ImageTile)tile).tileFX = null;
                    continue;
                }
                if (tile instanceof AnimatedTile) {
                    ((AnimatedTile)tile).tileFX = null;
                    continue;
                }
                ((InteractiveTile)tile).tileFX = null;
            }
        }
        this.currentFX = TileFX.getFXByType(type);
        if (this.displayComponent != null) {
            secondComponent.remove(this.displayComponent);
        }
        if (this.editComponent != null) {
            secondComponent.remove(this.editComponent);
        }
        this.displayComponent = this.currentFX.getDrawingComponent(this.editTiles);
        this.editComponent = this.currentFX.getEditingComponent(this.editTiles);
        secondComponent.add((Component)this.displayComponent, "North");
        secondComponent.add((Component)this.editComponent, "South");
        arr$ = this.editTiles;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (GraphicTile tile : array = arr$[i$]) {
                if (tile == null) continue;
                if (tile instanceof ImageTile) {
                    ((ImageTile)tile).tileFX = this.currentFX;
                    continue;
                }
                if (tile instanceof AnimatedTile) {
                    ((AnimatedTile)tile).tileFX = this.currentFX;
                    continue;
                }
                ((InteractiveTile)tile).tileFX = this.currentFX;
            }
        }
    }
}

