/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.TileType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TileTypeViewer
extends EditorComponent {
    private static final long serialVersionUID = -5249988667936641060L;
    private Rectangle selected;
    private BufferedImage typeSet;
    private TileType currentTileType = TileType.NONE;

    public TileTypeViewer() {
        this.selected = new Rectangle(0, 0, 32, 32);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        try {
            this.typeSet = ImageIO.read(new File("res/gfx/leveleditor/tiletypeimages.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(this.typeSet.getWidth(), this.typeSet.getHeight()));
    }

    public TileType getCurrentTileType() {
        return this.currentTileType;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.drawImage((Image)this.typeSet, 0, 0, null);
        if (this.mouseInWindow) {
            g2D.setColor(Color.GREEN);
            g2D.drawRect(this.mouseRelX * 32, this.mouseRelY * 32, 32, 32);
        }
        g2D.setColor(Color.RED);
        g2D.draw(this.selected);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseButton = e.getButton();
        this.mouseRelX = (int)Math.floor(e.getX() / 32);
        if (mouseButton == 1) {
            switch (this.mouseRelX) {
                case 0: {
                    this.currentTileType = TileType.SOLID;
                    break;
                }
                case 1: {
                    this.currentTileType = TileType.FALLTHROUGH;
                    break;
                }
                case 2: {
                    this.currentTileType = TileType.SLIPPERY;
                    break;
                }
                case 3: {
                    this.currentTileType = TileType.KILL;
                    break;
                }
                case 4: {
                    this.currentTileType = TileType.KILLTOP;
                    break;
                }
                case 5: {
                    this.currentTileType = TileType.KILLBOTTOM;
                    break;
                }
                case 6: {
                    this.currentTileType = TileType.KILLLEFT;
                    break;
                }
                case 7: {
                    this.currentTileType = TileType.KILLRIGHT;
                    break;
                }
                case 8: {
                    this.currentTileType = TileType.FALLTHROUGH_SLIPPERY;
                    break;
                }
                case 9: {
                    this.currentTileType = TileType.KILLBOTTOM_SLIPPERY;
                    break;
                }
                case 10: {
                    this.currentTileType = TileType.KILLLEFT_SLIPPERY;
                    break;
                }
                case 11: {
                    this.currentTileType = TileType.KILLRIGHT_SLIPPERY;
                    break;
                }
                default: {
                    this.currentTileType = TileType.NONE;
                }
            }
        }
        this.selected.x = this.mouseRelX * 32;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
    }

    @Override
    public void run() {
        try {
            while (LevelEditorScene.isRunning()) {
                this.update(0L);
                Thread.sleep(16L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getTileTypeSubimage(TileType tileType) {
        switch (tileType) {
            case SOLID: {
                return this.typeSet.getSubimage(0, 0, 32, 32);
            }
            case FALLTHROUGH: {
                return this.typeSet.getSubimage(32, 0, 32, 32);
            }
            case SLIPPERY: {
                return this.typeSet.getSubimage(64, 0, 32, 32);
            }
            case KILL: {
                return this.typeSet.getSubimage(96, 0, 32, 32);
            }
            case KILLTOP: {
                return this.typeSet.getSubimage(128, 0, 32, 32);
            }
            case KILLBOTTOM: {
                return this.typeSet.getSubimage(160, 0, 32, 32);
            }
            case KILLLEFT: {
                return this.typeSet.getSubimage(192, 0, 32, 32);
            }
            case KILLRIGHT: {
                return this.typeSet.getSubimage(224, 0, 32, 32);
            }
            case FALLTHROUGH_SLIPPERY: {
                return this.typeSet.getSubimage(256, 0, 32, 32);
            }
            case KILLBOTTOM_SLIPPERY: {
                return this.typeSet.getSubimage(288, 0, 32, 32);
            }
            case KILLLEFT_SLIPPERY: {
                return this.typeSet.getSubimage(320, 0, 32, 32);
            }
            case KILLRIGHT_SLIPPERY: {
                return this.typeSet.getSubimage(352, 0, 32, 32);
            }
        }
        return null;
    }
}

