/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.leveleditor;

import com.dmgame.Direction;
import com.dmgame.leveleditor.EditorComponent;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.Warp;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class WarpViewer
extends EditorComponent
implements ActionListener {
    private static final long serialVersionUID = -1074111391368781574L;
    private static JButton[] colors = WarpViewer.setupColors();
    private Warp upWarp;
    private Warp downWarp;
    private Warp leftWarp;
    private Warp rightWarp;
    private Warp selectedWarp;
    private JButton up = new JButton();
    private JButton down;
    private JButton left;
    private JButton right;
    private Color currentColor;
    private byte currentColorID;
    private final String UP_COMMAND = "up";
    private final String DOWN_COMMAND = "down";
    private final String LEFT_COMMAND = "left";
    private final String RIGHT_COMMAND = "right";

    public WarpViewer() {
        this.up.setActionCommand("up");
        this.up.addActionListener(this);
        this.down = new JButton();
        this.down.setActionCommand("down");
        this.down.addActionListener(this);
        this.left = new JButton();
        this.left.setActionCommand("left");
        this.left.addActionListener(this);
        this.right = new JButton();
        this.right.setActionCommand("right");
        this.right.addActionListener(this);
        this.currentColor = Warp.COLOR_IDS[0];
        this.reloadWarpButtons(this.currentColor);
        this.setLayout(new GridLayout(4, 4));
        for (JButton b : colors) {
            b.addActionListener(this);
            this.add(b);
        }
        this.add(this.up);
        this.add(this.down);
        this.add(this.left);
        this.add(this.right);
        this.selectedWarp = this.upWarp;
    }

    public Warp getUnclonedSelectedWarp() {
        return this.selectedWarp;
    }

    public byte getCurrentColorID() {
        return this.currentColorID;
    }

    private static JButton[] setupColors() {
        JButton[] toReturn = new JButton[Warp.COLOR_IDS.length];
        JButton colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)0));
        colorButton.setBackground(Warp.COLOR_IDS[0]);
        toReturn[0] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)1));
        colorButton.setBackground(Warp.COLOR_IDS[1]);
        toReturn[1] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)2));
        colorButton.setBackground(Warp.COLOR_IDS[2]);
        toReturn[2] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)3));
        colorButton.setBackground(Warp.COLOR_IDS[3]);
        toReturn[3] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)4));
        colorButton.setBackground(Warp.COLOR_IDS[4]);
        toReturn[4] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)5));
        colorButton.setBackground(Warp.COLOR_IDS[5]);
        toReturn[5] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)6));
        colorButton.setBackground(Warp.COLOR_IDS[6]);
        toReturn[6] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)7));
        colorButton.setBackground(Warp.COLOR_IDS[7]);
        toReturn[7] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)8));
        colorButton.setBackground(Warp.COLOR_IDS[8]);
        toReturn[8] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)9));
        colorButton.setBackground(Warp.COLOR_IDS[9]);
        toReturn[9] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)10));
        colorButton.setBackground(Warp.COLOR_IDS[10]);
        toReturn[10] = colorButton;
        colorButton = new JButton();
        colorButton.setActionCommand(Byte.toString((byte)11));
        colorButton.setBackground(Warp.COLOR_IDS[11]);
        toReturn[11] = colorButton;
        return toReturn;
    }

    private void reloadWarpButtons(Color id) {
        this.upWarp = new Warp(Direction.NORTH, id);
        this.downWarp = new Warp(Direction.SOUTH, id);
        this.leftWarp = new Warp(Direction.WEST, id);
        this.rightWarp = new Warp(Direction.EAST, id);
        this.up.setIcon(new ImageIcon(this.upWarp.sprite));
        this.down.setIcon(new ImageIcon(this.downWarp.sprite));
        this.left.setIcon(new ImageIcon(this.leftWarp.sprite));
        this.right.setIcon(new ImageIcon(this.rightWarp.sprite));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
    }

    @Override
    public void run() {
        try {
            while (LevelEditorScene.isRunning()) {
                this.update(0L);
                Thread.sleep(16L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("up")) {
            this.selectedWarp = this.upWarp;
        } else if (s.equals("down")) {
            this.selectedWarp = this.downWarp;
        } else if (s.equals("left")) {
            this.selectedWarp = this.leftWarp;
        } else if (s.equals("right")) {
            this.selectedWarp = this.rightWarp;
        } else {
            byte id = Byte.parseByte(e.getActionCommand());
            this.currentColor = Warp.COLOR_IDS[id];
            this.selectedWarp.changeColor(this.currentColor);
            this.reloadWarpButtons(this.currentColor);
            this.currentColorID = 0;
            while (this.currentColorID < Warp.COLOR_IDS.length && Warp.COLOR_IDS[this.currentColorID] != this.selectedWarp.id) {
                this.currentColorID = (byte)(this.currentColorID + 1);
            }
        }
    }
}

