/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Animation;
import com.dmgame.SMWException;
import com.dmgame.Updatable;
import com.dmgame.graphics.TileFX;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.Tilesets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;

public class AnimatedTile
extends GraphicTile
implements Serializable,
Updatable {
    private static final long serialVersionUID = -6673399790159946495L;
    public transient Animation tile;
    private int frames;
    private String animTilesetName;
    private int x;
    private int y;
    public TileFX tileFX;

    public AnimatedTile(Animation tile, String animTilesetName, int x, int y) {
        this.tile = tile;
        this.frames = tile.size();
        this.animTilesetName = animTilesetName;
        this.x = x;
        this.y = y;
    }

    public String getAnimTilesetName() {
        return this.animTilesetName;
    }

    @Override
    public void update(long timePassed) {
        if (this.tile != null) {
            this.tile.update(timePassed);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.animTilesetName);
        out.writeInt(this.frames);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeObject(this.tileFX);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SMWException {
        Object o = in.readObject();
        if (o instanceof String) {
            this.animTilesetName = (String)o;
        }
        this.frames = in.readInt();
        this.x = in.readInt();
        this.y = in.readInt();
        try {
            this.tileFX = (TileFX)in.readObject();
        }
        catch (OptionalDataException e) {
            // empty catch block
        }
        try {
            this.tile = (Animation)Tilesets.getAnimated((String)this.animTilesetName)[this.x][this.y].tile.clone();
        }
        catch (NullPointerException ex) {
            System.err.println("error loading animated tile");
        }
    }

    @Override
    public Object clone() {
        return new AnimatedTile((Animation)this.tile.clone(), this.animTilesetName, this.x, this.y);
    }

    @Override
    public BufferedImage getImage() {
        if (this.tileFX != null) {
            return this.tileFX.alterImage(this.tile.getImage(), this.tile.getCurrentIndex(), -1);
        }
        return this.tile.getImage();
    }

    @Override
    public String toString() {
        return "[Animated, " + this.animTilesetName + ", " + this.x + ", " + this.y + "]";
    }
}

