/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.graphics.TileFX;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.Tilesets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;

public class ImageTile
extends GraphicTile
implements Serializable {
    private static final long serialVersionUID = 596192897065530748L;
    public transient BufferedImage tile;
    private String tilesetName;
    private int x;
    private int y;
    public TileFX tileFX;

    public ImageTile(BufferedImage tile, String tilesetName, int x, int y) {
        this.tile = tile;
        this.tilesetName = tilesetName;
        this.x = x;
        this.y = y;
    }

    public String getTilesetName() {
        return this.tilesetName;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.tilesetName);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeObject(this.tileFX);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o instanceof String) {
            this.tilesetName = (String)o;
        }
        this.x = in.readInt();
        this.y = in.readInt();
        try {
            this.tileFX = (TileFX)in.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.tile = Tilesets.get(this.tilesetName).getSubimage(this.x * 32, this.y * 32, 32, 32);
    }

    @Override
    public BufferedImage getImage() {
        if (this.tileFX != null) {
            return this.tileFX.alterImage(this.tile, 0, -1);
        }
        return this.tile;
    }

    @Override
    public Object clone() {
        return new ImageTile(this.tile, this.tilesetName, this.x, this.y);
    }

    @Override
    public String toString() {
        return "[Image, " + this.tilesetName + ", " + this.x + ", " + this.y + "]";
    }
}

