/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.UnthreadedTimer;
import com.dmgame.Updatable;
import com.dmgame.graphics.TileFX;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.particle.AnimatedParticle;
import com.dmgame.particle.GravityParticleLogic;
import com.dmgame.particle.ParticleLogic;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public abstract class InteractiveTile
extends GraphicTile
implements Serializable,
Cloneable,
Interactive,
Updatable {
    private static final long serialVersionUID = 599616620754461040L;
    public static final transient Animation tileset = InteractiveTile.createInteractiveTileset();
    public transient Animation tile;
    protected int x;
    protected int y;
    public float mapX;
    public float mapY;
    public float platOffsetX;
    public float platOffsetY;
    protected int mapRelX;
    protected int mapRelY;
    protected transient UnthreadedTimer bumpOneTimer;
    protected transient UnthreadedTimer bumpTwoTimer;
    public final transient long BUMP_DISTANCE = 4L;
    public transient boolean bumpedUp;
    public transient boolean bumpedDown;
    public transient boolean bumpedLeft;
    public transient boolean bumpedRight;
    protected transient boolean canUpdateBumpOne;
    protected transient boolean canUpdateBumpTwo;
    protected PhysicalTile hiddenPTile;
    public TileFX tileFX;
    protected static final transient BufferedImage DISABLED_BLOCK = InteractiveTile.disabledBlock();

    public InteractiveTile(Animation tile, int x, int y) {
        this.tile = tile;
        this.x = x;
        this.y = y;
        this.platOffsetX = 0.0f;
        this.platOffsetY = 0.0f;
        this.setupTimers();
        this.bumpedRight = false;
        this.bumpedLeft = false;
        this.bumpedDown = false;
        this.bumpedUp = false;
        this.mapX = 0.0f;
        this.mapY = 0.0f;
        this.hiddenPTile = null;
    }

    protected static BufferedImage disabledBlock() {
        try {
            return ImageIO.read(new File("res/gfx/packs/Default/blocks/itemblockused.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setupTimers() {
        this.bumpOneTimer = new UnthreadedTimer(64L){

            @Override
            public void update(long timePassed) {
                super.update(timePassed);
                if (InteractiveTile.this.bumpedUp) {
                    InteractiveTile.this.mapY -= 1.0f;
                } else if (InteractiveTile.this.bumpedDown) {
                    InteractiveTile.this.mapY += 1.0f;
                } else if (InteractiveTile.this.bumpedLeft) {
                    InteractiveTile.this.mapX -= 1.0f;
                } else if (InteractiveTile.this.bumpedRight) {
                    InteractiveTile.this.mapX += 1.0f;
                }
            }

            @Override
            public void end() {
                InteractiveTile.this.canUpdateBumpOne = false;
                InteractiveTile.this.canUpdateBumpTwo = true;
                this.reset();
            }
        };
        this.bumpTwoTimer = new UnthreadedTimer(64L){

            @Override
            public void update(long timePassed) {
                super.update(timePassed);
                if (InteractiveTile.this.bumpedUp) {
                    InteractiveTile.this.mapY += 1.0f;
                } else if (InteractiveTile.this.bumpedDown) {
                    InteractiveTile.this.mapY -= 1.0f;
                } else if (InteractiveTile.this.bumpedLeft) {
                    InteractiveTile.this.mapX += 1.0f;
                } else if (InteractiveTile.this.bumpedRight) {
                    InteractiveTile.this.mapX -= 1.0f;
                }
            }

            @Override
            public void end() {
                InteractiveTile.this.mapY = InteractiveTile.this.mapRelY * 32;
                InteractiveTile.this.mapX = InteractiveTile.this.mapRelX * 32;
                if (InteractiveTile.this.bumpedUp) {
                    InteractiveTile.this.bumpedUp = false;
                } else if (InteractiveTile.this.bumpedDown) {
                    InteractiveTile.this.bumpedDown = false;
                } else if (InteractiveTile.this.bumpedLeft) {
                    InteractiveTile.this.bumpedLeft = false;
                } else if (InteractiveTile.this.bumpedRight) {
                    InteractiveTile.this.bumpedRight = false;
                }
                InteractiveTile.this.canUpdateBumpOne = false;
                InteractiveTile.this.canUpdateBumpTwo = false;
                this.reset();
            }
        };
    }

    public void setMapRelCoords(int mapRelX, int mapRelY) {
        this.mapRelX = mapRelX;
        this.mapRelY = mapRelY;
        this.mapY = mapRelY * 32;
        this.mapX = mapRelX * 32;
    }

    public int getMapRelX() {
        return this.mapRelX;
    }

    public int getMapRelY() {
        return this.mapRelY;
    }

    public PhysicalTile getHiddenPTile() {
        return this.hiddenPTile;
    }

    public void setHiddenPTile(PhysicalTile hiddenPTile) {
        this.hiddenPTile = hiddenPTile;
    }

    protected void reactBump(Direction direction) {
        this.reactBump(direction, false, 0);
    }

    protected void reactBump(Direction direction, boolean broken, int particles) {
        if (this.canUpdateBumpOne || this.canUpdateBumpTwo) {
            return;
        }
        switch (direction) {
            case UP: {
                this.bumpedUp = true;
                break;
            }
            case DOWN: {
                this.bumpedDown = true;
                break;
            }
            case LEFT: {
                this.bumpedLeft = true;
                break;
            }
            case RIGHT: {
                this.bumpedRight = true;
                break;
            }
        }
        if (broken) {
            SoundPlayer.playSound(Sound.BREAK);
        } else {
            SoundPlayer.playSound(Sound.BUMP);
        }
        this.canUpdateBumpOne = true;
        this.canUpdateBumpTwo = false;
        if (broken) {
            this.createParticles(particles);
        }
    }

    @Override
    public void update(long timePassed) {
        this.updateImage(timePassed);
        if (this.canUpdateBumpOne) {
            this.bumpOneTimer.update(timePassed);
        } else if (this.canUpdateBumpTwo) {
            this.bumpTwoTimer.update(timePassed);
        }
    }

    public final void updateImage(long timePassed) {
        this.tile.update(timePassed);
    }

    private static Animation createInteractiveTileset() {
        Animation a = null;
        try {
            BufferedImage[] tilesets = new BufferedImage[4];
            for (int i = 0; i < 4; ++i) {
                tilesets[i] = ImageIO.read(new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png"));
            }
            a = new Animation(190L, tilesets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    public void removeSelfFromMap() {
        GameLogic.currentMap.iTiles[this.mapRelX][this.mapRelY] = null;
        GameLogic.usePTiles[this.mapRelX][this.mapRelY] = this.hiddenPTile;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.mapRelX);
        out.writeInt(this.mapRelY);
        out.writeFloat(this.mapX);
        out.writeFloat(this.mapY);
        out.writeObject(this.hiddenPTile);
        out.writeObject(this.tileFX);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SMWException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.mapRelX = in.readInt();
        this.mapRelY = in.readInt();
        this.mapX = in.readFloat();
        this.mapY = in.readFloat();
        this.hiddenPTile = (PhysicalTile)in.readObject();
        try {
            this.tileFX = (TileFX)in.readObject();
        }
        catch (OptionalDataException e) {
            // empty catch block
        }
        BufferedImage[] tilesets = new BufferedImage[4];
        for (int i = 0; i < 4; ++i) {
            tilesets[i] = ImageIO.read(new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png")).getSubimage(this.x, this.y, 32, 32);
        }
        this.tile = new Animation(190L, tilesets);
        this.setupTimers();
    }

    private void createParticles(int particles) {
        try {
            String[] particleFile = new String[]{"brokenbrickblock.png", "brokenblueblock.png", "brokengrayblock.png", "brokenredblock.png", "brokenyellowblock.png"};
            int[] particleFrames = new int[]{4, 6, 6, 6, 4};
            BufferedImage brokeBlock = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/particles/" + particleFile[particles]));
            int width = brokeBlock.getWidth() / particleFrames[particles];
            int height = brokeBlock.getHeight();
            Animation ani = new Animation(90L, brokeBlock.getSubimage(0, 0, width, height), brokeBlock.getSubimage(width * 1, 0, width, height));
            for (int curframe = 2; curframe == particleFrames[particles]; ++curframe) {
                ani.addFrame(brokeBlock.getSubimage(width * curframe, 0, width, height));
            }
            AnimatedParticle p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, -8.0f), (float)((int)this.mapX), (float)((int)this.mapY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, -8.0f), (float)((int)this.mapX + this.getImage().getWidth() - width), (float)((int)this.mapY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, 0.0f), (float)((int)this.mapX + this.getImage().getWidth() - width), (float)((int)this.mapY + this.getImage().getHeight() - height));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, 0.0f), (float)((int)this.mapX), (float)((int)this.mapY + this.getImage().getHeight() - height));
            p.addToMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public BufferedImage getImage() {
        if (this.tileFX != null) {
            return this.tileFX.alterImage(this.tile.getImage(), this.tile.getCurrentIndex(), -1);
        }
        return this.tile.getImage();
    }

    @Override
    public String toString() {
        return "Map X: " + this.mapX + ", Map Y: " + this.mapY + ", Rel X: " + this.mapRelX + ", Rel Y: " + this.mapRelY;
    }

    @Override
    public abstract Object clone();

    public void setSetting(int j, int readIntByte) {
    }
}

